/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.provider;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.security.audit.AuditLogConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogRateLimiter
implements Reconfigurable {
    private RateLimiter authnAuditLogRateLimiter;
    private RateLimiter authzAuditLogRateLimiter;
    private RateLimiter kafkaRequestAuditLogRateLimiter;
    private RateLimiter authnSslHandshakeFailureLogRateLimiter;
    private RateLimiter authnUnknownUserLogRateLimiter;
    private final int authnSslHandshakeFailureEventPercent = 2;
    private final int authnUnknownUserEventPercent = 2;
    protected static final Logger log = LoggerFactory.getLogger(AuditLogRateLimiter.class);
    private final Time time;

    @VisibleForTesting
    public AuditLogRateLimiter(Time time) {
        Objects.requireNonNull(time);
        this.time = time;
    }

    public AuditLogRateLimiter() {
        this(Time.SYSTEM);
    }

    public void configure(Map<String, ?> configs) {
        AuditLogConfig auditLogConfig = new AuditLogConfig(configs);
        this.configureRateLimitersWithCustomWindowSize(1000, auditLogConfig);
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add("confluent.security.event.logger.authentication.event.rate.limit");
        configs.add("confluent.security.event.logger.authorization.event.rate.limit");
        configs.add("confluent.security.event.logger.kafka.request.rate.limit");
        return configs;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
        AuditLogConfig auditLogConfig = new AuditLogConfig(configs);
        this.configureRateLimitersWithCustomWindowSize(1000, auditLogConfig);
    }

    protected void configureRateLimitersWithCustomWindowSize(int windowSizeMs, AuditLogConfig auditLogConfig) {
        int authnMaxActionsPerWindow = auditLogConfig.getInt("confluent.security.event.logger.authentication.event.rate.limit");
        int authzMaxActionsPerWindow = auditLogConfig.getInt("confluent.security.event.logger.authorization.event.rate.limit");
        int kafkaRequestMaxActionsPerWindow = auditLogConfig.getInt("confluent.security.event.logger.kafka.request.rate.limit");
        this.authnAuditLogRateLimiter = authnMaxActionsPerWindow == -1 ? null : new RateLimiter.Builder().setMaxActionsPerWindow((int)Math.round((double)authnMaxActionsPerWindow * 0.96)).setWindowLength(windowSizeMs).setTime(this.time).build();
        this.authzAuditLogRateLimiter = authzMaxActionsPerWindow == -1 ? null : new RateLimiter.Builder().setMaxActionsPerWindow(authzMaxActionsPerWindow).setWindowLength(windowSizeMs).setTime(this.time).build();
        this.kafkaRequestAuditLogRateLimiter = kafkaRequestMaxActionsPerWindow == -1 ? null : new RateLimiter.Builder().setMaxActionsPerWindow(kafkaRequestMaxActionsPerWindow).setWindowLength(windowSizeMs).setTime(this.time).build();
        this.authnSslHandshakeFailureLogRateLimiter = authnMaxActionsPerWindow == -1 ? null : new RateLimiter.Builder().setMaxActionsPerWindow((int)Math.round((double)authnMaxActionsPerWindow * 0.02)).setWindowLength(windowSizeMs).setTime(this.time).build();
        this.authnUnknownUserLogRateLimiter = authnMaxActionsPerWindow == -1 ? null : new RateLimiter.Builder().setMaxActionsPerWindow((int)Math.round((double)authnMaxActionsPerWindow * 0.02)).setWindowLength(windowSizeMs).setTime(this.time).build();
        log.info("Audit Log rate limiter reconfigured: Authn: {}, Authz: {}, Kafka request: {}", new Object[]{authnMaxActionsPerWindow, authzMaxActionsPerWindow, kafkaRequestMaxActionsPerWindow});
    }

    @VisibleForTesting
    RateLimiter getRateLimiter(AuditEvent auditEvent) {
        switch (auditEvent.type()) {
            case AUTHORIZATION: {
                return this.authzAuditLogRateLimiter;
            }
            case AUTHENTICATION: {
                switch (auditEvent.status()) {
                    case UNKNOWN_USER_DENIED: {
                        return this.authnUnknownUserLogRateLimiter;
                    }
                    case SSL_HANDSHAKE_FAILED: {
                        return this.authnSslHandshakeFailureLogRateLimiter;
                    }
                }
                return this.authnAuditLogRateLimiter;
            }
            case KAFKA_REQUEST: {
                return this.kafkaRequestAuditLogRateLimiter;
            }
        }
        return null;
    }

    protected Boolean rateLimitReached(AuditEvent auditEvent) {
        RateLimiter rateLimiter = this.getRateLimiter(auditEvent);
        if (rateLimiter == null) {
            return false;
        }
        Boolean rateLimitReached = rateLimiter.maybeAllow() == false;
        if (rateLimitReached.booleanValue()) {
            log.debug("Rate limit of {} per window ({} ms) reached for {} audit events", new Object[]{rateLimiter.getMaxActionsPerWindow(), rateLimiter.getWindowLength(), auditEvent.type().toString()});
        }
        return rateLimitReached;
    }
}

