/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.confluent.auditlog.remote.RemoteAuditConfiguration;
import io.confluent.crn.ConfluentCloudCrnAuthority;
import io.confluent.crn.ConfluentServerCrnAuthority;
import io.confluent.crn.CrnAuthorityConfig;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuditLogConfig;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.security.audit.AuditLogConfig;
import io.confluent.security.audit.AuditLogEntry;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.audit.kafka.KafkaRequestToAuditEntry;
import io.confluent.security.audit.provider.AuditLogRateLimiter;
import io.confluent.security.audit.router.AuditLogRouter;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.audit.telemetry.exporter.config.remote.RemoteConfigConfiguration;
import io.confluent.security.audit.telemetry.exporter.config.remote.RemoteConfigurationSource;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.security.audit.telemetry.exporter.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationSource;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventLogger;
import io.confluent.telemetry.events.EventUtils;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.oauthbearer.internals.secured.Retry;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentAuditLogProvider
implements AuditLogProvider,
ClusterResourceListener {
    public static final String AUTHORIZATION_MESSAGE_TYPE = "io.confluent.kafka.server/authorization";
    public static final String AUTHENTICATION_MESSAGE_TYPE = "io.confluent.kafka.server/authentication";
    public static final String KAFKA_REQUEST_MESSAGE_TYPE = "io.confluent.kafka.server/request";
    protected static final Logger log = LoggerFactory.getLogger(ConfluentAuditLogProvider.class);
    private static final String FALLBACK_LOGGER = "io.confluent.security.audit.log.fallback";
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    protected final Logger fallbackLog = LoggerFactory.getLogger((String)"io.confluent.security.audit.log.fallback");
    private UnaryOperator<AuditEvent> sanitizer;
    private volatile Map<String, Object> originalInterBrokerListenerConfigs = new HashMap<String, Object>();
    private ConfiguredState configuredState;
    private ExecutorService initExecutor;
    private ExecutorService fallbackExecutor;
    private ConfluentServerCrnAuthority crnAuthority;
    private volatile boolean eventLoggerReady;
    private Scope scope;
    private Scope auditLogScope;
    private boolean omitClientAddressConfig;
    protected AuditLogRateLimiter auditLogRateLimiter;
    private Boolean isCloud;
    private volatile RemoteAuditConfiguration remoteConfiguration;
    private boolean namedConfigEnabled = false;
    private RemoteConfigurationSource<RemoteAuditConfiguration> kubernetesConfigMapRemoteConfigurationSource;
    private String physicalClusterId;
    private AuditLogMetrics auditLogMetrics;

    public void onUpdate(ClusterResource clusterResource) {
        this.scope = Scope.kafkaClusterScope((String)clusterResource.clusterId());
        this.auditLogScope = this.physicalClusterId == null || this.physicalClusterId.isEmpty() ? this.scope : Scope.kafkaClusterScope((String)this.physicalClusterId);
    }

    public void configure(Map<String, ?> configs) {
        AuditLogConfig auditLogConfig;
        CrnAuthorityConfig crnAuthorityConfig = new CrnAuthorityConfig(configs);
        String apiFlavor = crnAuthorityConfig.getString("confluent.metadata.server.api.flavor");
        if (apiFlavor.equals("CP")) {
            this.crnAuthority = new ConfluentServerCrnAuthority();
            this.isCloud = false;
        } else {
            this.crnAuthority = new ConfluentCloudCrnAuthority();
            this.isCloud = true;
        }
        this.namedConfigEnabled = this.getNamedConfigEnabled(configs);
        this.physicalClusterId = (String)configs.get("confluent.security.event.logger.physical.cluster.id");
        log.info("NamedConfigEnabled: {}", (Object)this.namedConfigEnabled);
        if (this.isDRFeatureEnabled()) {
            try {
                this.kubernetesConfigMapRemoteConfigurationSource = this.configureRemoteConfig(configs);
                if (Objects.nonNull(this.kubernetesConfigMapRemoteConfigurationSource.getConfig())) {
                    this.remoteConfiguration = this.kubernetesConfigMapRemoteConfigurationSource.getConfig();
                    this.updateConfigsWithNamedConfig(configs, this.remoteConfiguration);
                }
            }
            catch (Exception e) {
                log.error("Error occurred while configuring named Config. Continuing with the regular flow", (Throwable)e);
            }
        }
        if (!(auditLogConfig = new AuditLogConfig(configs)).getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            return;
        }
        this.configuredState = new ConfiguredState(new EventLogger(), new AuditLogRouter(auditLogConfig.routerJsonConfig(), auditLogConfig.getInt("confluent.security.event.router.cache.entries")), auditLogConfig);
        this.crnAuthority.configure(crnAuthorityConfig.values());
        MultiTenantAuditLogConfig multiTenantAuditLogConfig = new MultiTenantAuditLogConfig(configs);
        this.omitClientAddressConfig = false;
        if (multiTenantAuditLogConfig.getBoolean("confluent.security.event.logger.multitenant.enable").booleanValue()) {
            this.omitClientAddressConfig = multiTenantAuditLogConfig.getBoolean("confluent.security.event.logger.client.ip.enable") == false;
        }
        this.eventLoggerReady = false;
        this.auditLogRateLimiter = new AuditLogRateLimiter();
        this.auditLogRateLimiter.configure(configs);
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add("confluent.security.event.router.config");
        configs.add("confluent.security.event.logger.enable");
        configs.addAll(this.auditLogRateLimiter.reconfigurableConfigs());
        return configs;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        AuditLogConfig config = new AuditLogConfig(configs);
        AuditLogRouterJsonConfig routerJsonConfig = config.routerJsonConfig();
        HashMap newConfigs = new HashMap(configs);
        if (routerJsonConfig.bootstrapServers() == null || routerJsonConfig.bootstrapServers().isEmpty()) {
            newConfigs.putAll(this.originalInterBrokerListenerConfigs);
        }
        AuditLogConfig.toEventLoggerConfig(newConfigs);
    }

    private void updateConfiguredState(Map<String, Object> loggerConfig, AuditLogRouter router, AuditLogConfig config) {
        EventLogger oldLogger = this.configuredState != null ? this.configuredState.logger : null;
        EventLogger newLogger = new EventLogger();
        newLogger.configure(loggerConfig);
        this.configuredState = new ConfiguredState(newLogger, router, config);
        if (oldLogger != null) {
            Utils.closeQuietly((AutoCloseable)oldLogger, (String)"eventLogger");
        }
    }

    public synchronized void reconfigure(Map<String, ?> configs) {
        if (this.isRemoteAuditConfigurationEnabled()) {
            this.updateConfigsWithNamedConfig(configs, this.remoteConfiguration);
        }
        AuditLogConfig alc = new AuditLogConfig(configs);
        AuditLogRouterJsonConfig routerJsonConfig = alc.routerJsonConfig();
        HashMap newConfigs = new HashMap(configs);
        if (alc.routerJsonConfig().bootstrapServers() == null || alc.routerJsonConfig().bootstrapServers().isEmpty()) {
            newConfigs.putAll(this.originalInterBrokerListenerConfigs);
        }
        AuditLogRouter router = new AuditLogRouter(routerJsonConfig, alc.getInt("confluent.security.event.router.cache.entries"));
        Map<String, Object> elc = AuditLogConfig.toEventLoggerConfig(newConfigs);
        this.updateConfiguredState(elc, router, alc);
        this.auditLogRateLimiter.reconfigure(configs);
    }

    public CompletionStage<Void> start(Map<String, ?> interBrokerListenerConfigs) {
        this.initExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"audit-init-%d", (boolean)true));
        this.fallbackExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"audit-fallback-init-%d", (boolean)true));
        this.originalInterBrokerListenerConfigs = new HashMap(interBrokerListenerConfigs);
        CompletableFuture future = new CompletableFuture();
        this.initExecutor.submit(() -> {
            try {
                HashMap config = new HashMap(interBrokerListenerConfigs);
                config.putAll(this.configuredState.config.values());
                if (this.isRemoteAuditConfigurationEnabled()) {
                    this.updateConfigsWithNamedConfig(config, this.remoteConfiguration);
                    String activeRegion = this.remoteConfiguration.getActiveRegion();
                    this.auditLogMetrics.addRemoteAuditConfigurationMetrics(activeRegion);
                    this.auditLogMetrics.recordRemoteAuditLogConfigurationMetrics(activeRegion);
                }
                this.updateConfiguredState(AuditLogConfig.toEventLoggerConfig(config), this.configuredState.router, this.configuredState.config);
                this.eventLoggerReady = true;
                if (this.shouldStartKubernetesConfigMapRemoteConfigurationSource()) {
                    try {
                        this.kubernetesConfigMapRemoteConfigurationSource.start();
                        log.info("Started the Kubernetes remote config for pkcId: {}", (Object)this.physicalClusterId);
                        this.auditLogMetrics.remoteAuditlogConfigurationSourceSuccessMetrics();
                    }
                    catch (IllegalStateException e) {
                        log.error("RemoteConfigmapSource in illegal state");
                        this.auditLogMetrics.remoteAuditlogConfigurationSourceFailure();
                    }
                } else if (this.isDRFeatureEnabled()) {
                    log.error("Unable to start RemoteConfigurationSource. It is null");
                    this.auditLogMetrics.remoteAuditlogConfigurationSourceStartFailure();
                }
                future.complete(null);
            }
            catch (Throwable e) {
                log.error("Audit log provider could not be started", e);
                if (this.auditLogMetrics != null) {
                    this.auditLogMetrics.recordAuditLoggerCreationFailureMetrics();
                }
                future.completeExceptionally(e);
            }
        });
        return future.whenComplete((unused, e) -> this.initExecutor.shutdownNow());
    }

    public void logEvent(AuditEvent auditEvent) {
        this.logEvent(auditEvent, false);
    }

    public void logEvent(AuditEvent auditEvent, boolean isProxyModeLocal) {
        boolean shouldOmitIpFromLogs = this.shouldOmitIpFromLogs(isProxyModeLocal);
        if (auditEvent.type() == AuditEventType.AUTHORIZATION && this.configuredState.config.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            this.logAuthorization((ConfluentAuthorizationEvent)auditEvent, shouldOmitIpFromLogs);
        } else if (auditEvent.type() == AuditEventType.AUTHENTICATION && this.configuredState.config.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            this.logAuthentication((AuthenticationEvent)auditEvent, shouldOmitIpFromLogs);
        } else if (auditEvent.type() == AuditEventType.KAFKA_REQUEST) {
            this.logKafkaRequestEvent((KafkaRequestEvent)auditEvent, shouldOmitIpFromLogs);
        } else if (this.configuredState.config.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            log.error("Unknown event received {}", (Object)auditEvent);
        }
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return true;
    }

    public boolean providerConfigured(Map<String, ?> configs) {
        AuditLogConfig cfg = new AuditLogConfig(configs);
        return cfg.getBoolean("confluent.security.event.logger.enable");
    }

    public void setSanitizer(UnaryOperator<AuditEvent> sanitizer) {
        this.sanitizer = sanitizer;
    }

    public void setMetrics(Metrics metrics) {
        this.auditLogMetrics = new AuditLogMetrics(metrics);
    }

    public void onReceiveCallback(RemoteAuditConfiguration newRemoteConfiguration) {
        try {
            ConfiguredState state = this.configuredState;
            String activeRegion = newRemoteConfiguration.getActiveRegion();
            if (this.isDRFeatureEnabled()) {
                log.info("Received new remoteAuditConfiguration with active Region: {}", (Object)activeRegion);
                this.remoteConfiguration = newRemoteConfiguration;
                this.reconfigure(state.config.originals());
                this.auditLogMetrics.addRemoteAuditConfigurationMetrics(activeRegion);
                this.auditLogMetrics.recordRemoteAuditLogConfigurationMetrics(activeRegion);
            }
        }
        catch (Exception e) {
            log.error("Error occurred while handling named config", (Throwable)e);
        }
    }

    private boolean getNamedConfigEnabled(Map<String, ?> configs) {
        try {
            String namedConfigEnabled = configs.getOrDefault("confluent.security.event.router.named.config.enabled", "false");
            return namedConfigEnabled.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            log.error("Error occurred while handling named config", (Throwable)e);
            throw new ConfigException("Invalid named config", (Object)e);
        }
    }

    private boolean shouldStartKubernetesConfigMapRemoteConfigurationSource() {
        return this.isDRFeatureEnabled() && Objects.nonNull(this.kubernetesConfigMapRemoteConfigurationSource);
    }

    private boolean isRemoteAuditConfigurationEnabled() {
        return this.isDRFeatureEnabled() && Objects.nonNull(this.remoteConfiguration);
    }

    private boolean isDRFeatureEnabled() {
        return this.isCloud != false && this.namedConfigEnabled;
    }

    public RemoteConfigurationSource<RemoteAuditConfiguration> configureRemoteConfig(Map<String, ?> configs) {
        try {
            Optional<RemoteConfigConfiguration> remoteConfigConfiguration = this.parseRemoteConfigSourceConfiguration(configs, true);
            if (!remoteConfigConfiguration.isPresent()) {
                log.error("Remote configuration is not present");
                throw new ConfigException("Remote configuration is not present");
            }
            return this.getRemoteKubernetesConfigurationSource(remoteConfigConfiguration.get());
        }
        catch (Exception e) {
            log.error("Error occurred while handling named config", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    RemoteConfigurationSource<RemoteAuditConfiguration> getRemoteKubernetesConfigurationSource(RemoteConfigConfiguration remoteConfigConfiguration) {
        try {
            KubernetesConfigMapRemoteConfigurationSource<RemoteAuditConfiguration> remoteConfigurationSource = new KubernetesConfigMapRemoteConfigurationSource<RemoteAuditConfiguration>((KubernetesConfigMapRemoteConfigurationConfig)remoteConfigConfiguration, Optional.of(this.physicalClusterId), this::onReceiveCallback, RemoteAuditConfiguration.class);
            long retryBackOffMaxMs = ((KubernetesConfigMapRemoteConfigurationConfig)remoteConfigConfiguration).getRetryBackoffMs();
            long maxRetryBackOffMs = ((KubernetesConfigMapRemoteConfigurationConfig)remoteConfigConfiguration).getMaxRetryBackoffMs();
            Retry remoteAuditConfigurationRetry = new Retry(retryBackOffMaxMs, maxRetryBackOffMs);
            try {
                RemoteAuditConfiguration remoteAuditConfiguration = (RemoteAuditConfiguration)remoteAuditConfigurationRetry.execute(remoteConfigurationSource);
                log.info("RemoteAuditConfiguration Region: {}", (Object)remoteAuditConfiguration.getActiveRegion());
            }
            catch (ExecutionException e) {
                log.error("Error while setting the RemoteAuditConfig in the kubernetesConfigurationSource in pkc: {}", (Object)this.physicalClusterId, (Object)e);
            }
            return remoteConfigurationSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to configure RemoteConfigurationSource", e);
        }
    }

    Optional<RemoteConfigConfiguration> parseRemoteConfigSourceConfiguration(Map<String, ?> configs, boolean doLog) {
        AuditLogConfig config = new AuditLogConfig(configs);
        Map remoteConfigSourceConfigs = config.originalsWithPrefix("confluent.security.remoteconfig.cloud.");
        Boolean cloudEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        boolean cloudEnabled = Optional.ofNullable(cloudEnabledConfig).orElse(false);
        if (cloudEnabled) {
            return Optional.of(new KubernetesConfigMapRemoteConfigurationConfig(remoteConfigSourceConfigs, doLog));
        }
        return Optional.empty();
    }

    void updateConfigsWithNamedConfig(Map<String, ?> configs, RemoteAuditConfiguration remoteAuditConfiguration) {
        if (this.namedConfigEnabled) {
            try {
                String activeRegion = remoteAuditConfiguration.getActiveRegion();
                log.info("Active Region: {} in pkc: {}", (Object)activeRegion, (Object)this.physicalClusterId);
                String namedRouterConfig = remoteAuditConfiguration.getAuditProducerConfig(activeRegion).getRouterConfig();
                String namedSaslJaasConfig = remoteAuditConfiguration.getAuditProducerConfig(activeRegion).getJaasConfig();
                configs.put("confluent.security.event.router.config", namedRouterConfig);
                configs.put("confluent.security.event.logger.exporter.kafka.sasl.jaas.config", namedSaslJaasConfig);
            }
            catch (Exception e) {
                log.error("Error occurred while handling named config", (Throwable)e);
                throw new ConfigException("Invalid named config", (Object)e);
            }
        }
    }

    private boolean shouldThrottleAuditEvent(AuditEvent auditEvent) {
        return this.isCloud != false && this.auditLogRateLimiter.rateLimitReached(auditEvent) != false;
    }

    private void logAuthorization(ConfluentAuthorizationEvent authorizationEvent, boolean shouldOmitIpFromLogs) {
        ConfiguredState state = this.configuredState;
        if (!this.shouldLog(authorizationEvent, state) || this.shouldThrottleAuditEvent((AuditEvent)authorizationEvent)) {
            return;
        }
        try {
            KafkaPrincipal origPrincipal = authorizationEvent.requestContext().principal();
            AuditLogEntry auditLogEntry = AuditLogUtils.authorizationEvent(authorizationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            Optional<String> route = state.router.topic(auditLogEntry);
            if (this.isSuppressed(route)) {
                return;
            }
            if (this.sanitizer != null) {
                if ((authorizationEvent = (ConfluentAuthorizationEvent)this.sanitizer.apply((AuditEvent)authorizationEvent)) == null) {
                    return;
                }
                auditLogEntry = AuditLogUtils.authorizationEvent(authorizationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            }
            Event event = this.event(auditLogEntry.getServiceName(), auditLogEntry.getResourceName(), (Message)auditLogEntry, state, (AuditEvent)authorizationEvent, AUTHORIZATION_MESSAGE_TYPE);
            this.logEventToRoute(state, route, event, !this.eventLoggerReady);
            this.auditLogMetrics.recordAuthorizationAuditLogMetrics();
        }
        catch (CrnSyntaxException e) {
            log.error("Couldn't create cloud event due to internally generated CRN syntax problem", (Throwable)e);
            this.auditLogMetrics.recordAuthorizationAuditLogFailureMetrics();
        }
        catch (Exception e) {
            log.error("Error occurred while handling authorization event", (Throwable)e);
            this.auditLogMetrics.recordAuthorizationAuditLogFailureMetrics();
        }
    }

    private boolean isSuppressed(Optional<String> route) {
        return route.isPresent() && route.get().equalsIgnoreCase("");
    }

    private void logEventToRoute(ConfiguredState state, Optional<String> route, Event event, boolean fallback) {
        if (fallback) {
            this.fallbackLog.info(EventUtils.toJson((Event)event));
            this.auditLogMetrics.recordFallbackAuditLogMetrics(FallbackReason.EVENT_LOGGER_NOT_READY);
            return;
        }
        if (!route.isPresent()) {
            log.debug("sending audit log to fallback logger because route not set in event. Event type {}", (Object)event.type());
            this.fallbackLog.error(EventUtils.toJson((Event)event));
            this.auditLogMetrics.recordFallbackAuditLogMetrics(FallbackReason.ROUTE_NOT_SET);
            return;
        }
        event.setExtension("route", route.get());
        boolean routeReady = state.logger.ready(event);
        if (routeReady) {
            this.emitEvent(event, state.logger).whenCompleteAsync((response, throwable) -> {
                if (throwable != null && throwable instanceof KafkaException) {
                    log.debug("sending audit log to fallback logger because of kafka exception:{}", (Object)throwable.getMessage());
                    this.fallbackLog.info(EventUtils.toJson((Event)event));
                    this.auditLogMetrics.recordFallbackAuditLogMetrics(FallbackReason.KAFKA_EXCEPTION);
                }
                if (response != null) {
                    if (!response.booleanValue()) {
                        this.fallbackLog.info(EventUtils.toJson((Event)event));
                        this.auditLogMetrics.recordFallbackAuditLogMetrics(FallbackReason.AUDIT_LOGGER_CLOSED);
                    } else {
                        this.auditLogMetrics.recordNormalAuditLogMetrics();
                    }
                }
            }, (Executor)this.fallbackExecutor);
        } else {
            log.debug("sending audit log to fallback logger because route is not ready for the event. event type:{} route:{}", (Object)event.type(), (Object)route.get());
            this.fallbackLog.info(EventUtils.toJson((Event)event));
            this.auditLogMetrics.recordFallbackAuditLogMetrics(FallbackReason.ROUTE_NOT_READY);
        }
    }

    @VisibleForTesting
    CompletableFuture<Boolean> emitEvent(Event event, EventLogger logger) {
        return logger.logAndGetFuture(event);
    }

    private Event event(String serviceName, String subject, Message message, ConfiguredState state, AuditEvent auditEvent, String messageType) {
        String dataContentType = this.dataContentType(state);
        return new Event().setId(auditEvent.uuid().toString()).setTime(auditEvent.timestamp().atOffset(ZoneOffset.UTC)).setSource(serviceName).setSubject(subject).setType(messageType).setData(dataContentType, EventUtils.protoToBytes((Message)message, (String)dataContentType));
    }

    private String dataContentType(ConfiguredState state) {
        String dataContentType;
        String encodingConfig;
        switch (encodingConfig = state.config.getString("confluent.security.event.logger.cloudevent.codec")) {
            case "structured": {
                dataContentType = "application/json";
                break;
            }
            case "binary": {
                dataContentType = "application/protobuf";
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding " + encodingConfig);
            }
        }
        return dataContentType;
    }

    private boolean shouldLog(ConfluentAuthorizationEvent authorizationEvent, ConfiguredState state) {
        if (!state.router.isEventRoutable(authorizationEvent)) {
            return false;
        }
        switch (authorizationEvent.authorizeResult()) {
            case ALLOWED: {
                return authorizationEvent.action().logIfAllowed();
            }
            case DENIED: {
                return authorizationEvent.action().logIfDenied();
            }
        }
        return true;
    }

    private void logAuthentication(AuthenticationEvent auditEvent, boolean shouldOmitIpFromLogs) {
        try {
            if (this.shouldThrottleAuditEvent((AuditEvent)auditEvent)) {
                return;
            }
            ConfluentAuthenticationEvent authenticationEvent = new ConfluentAuthenticationEvent(auditEvent, this.auditLogScope);
            KafkaPrincipal origPrincipal = authenticationEvent.principal().isPresent() ? (KafkaPrincipal)authenticationEvent.principal().get() : null;
            AuditLogEntry entry = AuditLogUtils.authenticationEvent(authenticationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            ConfiguredState state = this.configuredState;
            Optional<String> route = state.router.topic(entry);
            if (this.isSuppressed(route)) {
                return;
            }
            if (this.sanitizer != null) {
                if ((authenticationEvent = (ConfluentAuthenticationEvent)this.sanitizer.apply((AuditEvent)authenticationEvent)) == null) {
                    return;
                }
                entry = AuditLogUtils.authenticationEvent(authenticationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            }
            Event event = this.event(entry.getServiceName(), entry.getResourceName(), (Message)entry, state, (AuditEvent)auditEvent, AUTHENTICATION_MESSAGE_TYPE);
            this.logEventToRoute(state, route, event, !this.eventLoggerReady);
            this.auditLogMetrics.recordAuthenticationAuditLogMetrics();
        }
        catch (Exception e) {
            this.auditLogMetrics.recordAuthenticationAuditLogFailureMetrics();
            log.error("Error occurred while handling authentication event : {}", (Object)auditEvent, (Object)e);
        }
    }

    private void logKafkaRequestEvent(KafkaRequestEvent auditEvent, boolean shouldOmitIpFromLogs) {
        try {
            if (this.shouldThrottleAuditEvent((AuditEvent)auditEvent)) {
                return;
            }
            if (this.sanitizer != null) {
                AuditExtractorOptions auditExtractorOptions = new AuditExtractorOptions(this.crnAuthority, shouldOmitIpFromLogs);
                List<AuditLog> auditLogList = KafkaRequestToAuditEntry.extractAuditLog(auditEvent, auditExtractorOptions);
                ConfiguredState state = this.configuredState;
                int successEvents = 0;
                int failureEvents = 0;
                for (AuditLog auditLog : auditLogList) {
                    try {
                        Event event = this.event(auditLog.getServiceName(), auditLog.getResourceName(), (Message)auditLog, state, (AuditEvent)auditEvent, KAFKA_REQUEST_MESSAGE_TYPE);
                        this.logEventToRoute(state, AuditLogRouterJsonConfig.DEFAULT_V2_TOPIC_ROUTE, event, !this.eventLoggerReady);
                        ++successEvents;
                    }
                    catch (Exception e) {
                        ++failureEvents;
                        log.error("Error occurred while handling Kafka management event : {}", (Object)auditLog, (Object)e);
                    }
                }
                if (successEvents != 0) {
                    this.auditLogMetrics.recordKafkaRequestEventAuditLogMetrics(ApiKeys.forId((int)auditEvent.requestContext().requestType()), successEvents);
                }
                if (failureEvents != 0) {
                    this.auditLogMetrics.recordKafkaRequestAuditLogFailureMetrics(failureEvents);
                }
            }
        }
        catch (Exception e) {
            this.auditLogMetrics.recordKafkaRequestAuditLogFailureMetrics(1.0);
            log.error("Error occurred while handling Kafka management events : {}", (Object)auditEvent, (Object)e);
        }
    }

    private boolean shouldOmitIpFromLogs(boolean isLocalProxyMode) {
        return this.omitClientAddressConfig || isLocalProxyMode;
    }

    public void close(String brokerSessionUuid) throws Exception {
        this.close();
    }

    public void close() {
        if (this.initExecutor != null) {
            this.initExecutor.shutdownNow();
            try {
                this.initExecutor.awaitTermination(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.debug("ConfluentAuditLogProvider was interrupted while waiting to close initExecutor");
                throw new InterruptException(e);
            }
        }
        if (this.fallbackExecutor != null) {
            this.fallbackExecutor.shutdownNow();
            try {
                this.fallbackExecutor.awaitTermination(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.debug("ConfluentAuditLogProvider was interrupted while waiting to close fallbackExecutor");
                throw new InterruptException(e);
            }
        }
        if (this.kubernetesConfigMapRemoteConfigurationSource != null) {
            log.debug("Stopping kubernetesConfigMapRemoteConfigurationSource");
            this.kubernetesConfigMapRemoteConfigurationSource.stop();
        }
        Utils.closeQuietly((AutoCloseable)this.configuredState.logger, (String)"eventLogger");
    }

    public ExecutorService initExecutor() {
        return this.initExecutor;
    }

    public EventLogger getEventLogger() {
        return this.configuredState.logger;
    }

    public AuditLogConfig getAuditLogConfig() {
        return this.configuredState.config;
    }

    public AuditLogRouterJsonConfig getAuditLogRouterJsonConfig() {
        return this.configuredState.config.routerJsonConfig();
    }

    public boolean isEventLoggerReady() {
        return this.eventLoggerReady;
    }

    public Metrics metrics() {
        return this.auditLogMetrics.metrics();
    }

    protected void setupMetrics(Time time) {
        this.auditLogMetrics = new AuditLogMetrics(time);
    }

    protected Time metricsTime() {
        return this.auditLogMetrics.metricsTime();
    }

    public class AuditLogMetrics {
        public static final String GROUP_NAME = "confluent-audit-metrics";
        public static final String AUDIT_LOG_RATE_MINUTE = "audit-log-rate-per-minute";
        public static final String AUDIT_LOG_FALLBACK_RATE_MINUTE = "audit-log-fallback-rate-per-minute";
        public static final String AUTHENTICATION_AUDIT_LOG_RATE = "authentication-audit-log-rate";
        public static final String AUTHENTICATION_AUDIT_LOG_FAILURE_RATE = "authentication-audit-log-failure-rate";
        public static final String AUTHORIZATION_AUDIT_LOG_RATE = "authorization-audit-log-rate";
        public static final String AUTHORIZATION_AUDIT_LOG_FAILURE_RATE = "authorization-audit-log-failure-rate";
        public static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_RATE = "kafka-request-event-audit-log-rate";
        public static final String REMOTE_AUDIT_LOG_REGION_COUNT = "remote-audit-log-region-count";
        public static final String REMOTE_AUDIT_LOG_SOURCE_SUCCESS_COUNT = "remote-audit-log-source-success-count";
        public static final String REMOTE_AUDIT_LOG_SOURCE_FAILURE_COUNT = "remote-audit-log-source-failure-count";
        public static final String REMOTE_AUDIT_LOG_SOURCE_START_FAILURE_COUNT = "remote-audit-log-source-start-failure-count";
        public static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_RATE = "kafka-request-event-audit-log-failure-rate";
        public static final String AUDIT_LOGGER_CREATION_FAILURE = "audit-logger-creation-failure-count";
        private static final String AUDIT_LOG_NORMAL_SENSOR = "audit-log-normal";
        private static final String AUDIT_LOG_FALLBACK_SENSOR = "audit-log-fallback";
        private static final String AUTHENTICATION_AUDIT_LOG_SENSOR = "authentication-audit-log";
        private static final String AUTHENTICATION_AUDIT_LOG_FAILURE_SENSOR = "authentication-audit-log-failure";
        private static final String AUTHORIZATION_AUDIT_LOG_SENSOR = "authorization-audit-log";
        private static final String AUTHORIZATION_AUDIT_LOG_FAILURE_SENSOR = "authorization-audit-log-failure";
        private static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_SENSOR = "kafka-request-event-audit-log";
        private static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_SENSOR = "kafka-request-event-audit-log-failure";
        private static final String AUDIT_LOGGER_CREATION_FAILURE_SENSOR = "audit-logger-creation-failure";
        private static final String REMOTE_AUDIT_LOG_REGION_COUNT_SENSOR = "remote-audit-log-region";
        private static final String REMOTE_AUDIT_LOG_CONFIGURATION_SOURCE_SENSOR = "remote-audit-log-configuration-source";
        private Sensor normalAuditSensor = null;
        private Map<FallbackReason, Sensor> fallbackAuditSensor = new EnumMap<FallbackReason, Sensor>(FallbackReason.class);
        private Sensor authenticationAuditLogSensor = null;
        private Sensor authenticationAuditLogFailureSensor = null;
        private Sensor authorizationAuditLogSensor = null;
        private Sensor authorizationAuditLogFailureSensor = null;
        private Map<ApiKeys, Sensor> kafkaRequestEventAuditLogSensor = new EnumMap<ApiKeys, Sensor>(ApiKeys.class);
        private Sensor kafkaRequestEventAuditLogFailureSensor = null;
        private Sensor auditLoggerCreationFailureSensor = null;
        private Map<String, Sensor> remoteAuditlogConfigurationRegion = new HashMap<String, Sensor>();
        private Sensor remoteAuditlogConfigurationSourceSuccessSensor = null;
        private Sensor remoteAuditlogConfigurationSourceFailureSensor = null;
        private Sensor remoteAuditlogConfigurationSourceStartFailureSensor = null;
        private Time time;
        private Metrics metrics;

        AuditLogMetrics(Metrics metrics) {
            this.metrics = metrics;
            this.setupMetrics();
        }

        AuditLogMetrics(Time time) {
            this.time = time;
            this.metrics = new Metrics(time);
            this.setupMetrics();
        }

        void recordNormalAuditLogMetrics() {
            this.normalAuditSensor.record();
        }

        void recordAuditLoggerCreationFailureMetrics() {
            this.auditLoggerCreationFailureSensor.record();
        }

        void recordFallbackAuditLogMetrics(FallbackReason reason) {
            this.fallbackAuditSensor.get((Object)reason).record();
        }

        void recordAuthenticationAuditLogMetrics() {
            this.authenticationAuditLogSensor.record();
        }

        void recordAuthenticationAuditLogFailureMetrics() {
            this.authenticationAuditLogFailureSensor.record();
        }

        void recordAuthorizationAuditLogMetrics() {
            this.authorizationAuditLogSensor.record();
        }

        void recordAuthorizationAuditLogFailureMetrics() {
            this.authorizationAuditLogFailureSensor.record();
        }

        void recordKafkaRequestEventAuditLogMetrics(ApiKeys apiKeys, double value) {
            this.kafkaRequestEventAuditLogSensor.get(apiKeys).record(value);
        }

        void recordKafkaRequestAuditLogFailureMetrics(double value) {
            this.kafkaRequestEventAuditLogFailureSensor.record(value);
        }

        void recordRemoteAuditLogConfigurationMetrics(String region) {
            if (Objects.isNull(region)) {
                log.error("Region is null. Cannot record remote audit configuration metrics");
                return;
            }
            if (Objects.isNull(this.remoteAuditlogConfigurationRegion)) {
                log.error("remoteAuditlogConfigurationRegion sensor is null. Cannot record remote audit configuration region metrics");
                return;
            }
            if (!this.remoteAuditlogConfigurationRegion.containsKey(region)) {
                log.error("Region {} is not present in remoteAuditlogConfigurationRegion. Cannot record remote audit configuration region metrics", (Object)region);
                return;
            }
            for (Map.Entry<String, Sensor> entry : this.remoteAuditlogConfigurationRegion.entrySet()) {
                entry.getValue().record(0.0);
            }
            this.remoteAuditlogConfigurationRegion.get(region).record();
        }

        void remoteAuditlogConfigurationSourceSuccessMetrics() {
            this.remoteAuditlogConfigurationSourceSuccessSensor.record();
        }

        void remoteAuditlogConfigurationSourceFailure() {
            this.remoteAuditlogConfigurationSourceFailureSensor.record();
        }

        void remoteAuditlogConfigurationSourceStartFailure() {
            this.remoteAuditlogConfigurationSourceStartFailureSensor.record();
        }

        Metrics metrics() {
            return this.metrics;
        }

        Time metricsTime() {
            return this.time;
        }

        void setupMetrics() {
            this.normalAuditSensor = this.metrics.sensor(AUDIT_LOG_NORMAL_SENSOR);
            this.normalAuditSensor.add(this.metrics.metricName(AUDIT_LOG_RATE_MINUTE, GROUP_NAME, "The number of audit log per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES, (SampledStat)new WindowedCount()));
            this.authenticationAuditLogSensor = this.metrics.sensor(AUTHENTICATION_AUDIT_LOG_SENSOR);
            this.authenticationAuditLogSensor.add(this.metrics.metricName(AUTHENTICATION_AUDIT_LOG_RATE, GROUP_NAME, "The number of authentication audit log per second"), (MeasurableStat)new Rate());
            this.authenticationAuditLogFailureSensor = this.metrics.sensor(AUTHENTICATION_AUDIT_LOG_FAILURE_SENSOR);
            this.authenticationAuditLogFailureSensor.add(this.metrics.metricName(AUTHENTICATION_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of authentication audit log failure per second"), (MeasurableStat)new Rate());
            this.authorizationAuditLogSensor = this.metrics.sensor(AUTHORIZATION_AUDIT_LOG_SENSOR);
            this.authorizationAuditLogSensor.add(this.metrics.metricName(AUTHORIZATION_AUDIT_LOG_RATE, GROUP_NAME, "The number of authorization audit log per second"), (MeasurableStat)new Rate());
            this.authorizationAuditLogFailureSensor = this.metrics.sensor(AUTHORIZATION_AUDIT_LOG_FAILURE_SENSOR);
            this.authorizationAuditLogFailureSensor.add(this.metrics.metricName(AUTHORIZATION_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of authorization audit log failure per second"), (MeasurableStat)new Rate());
            this.kafkaRequestEventAuditLogFailureSensor = this.metrics.sensor(KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_SENSOR);
            this.kafkaRequestEventAuditLogFailureSensor.add(this.metrics.metricName(KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of kafka request event audit log failure per second"), (MeasurableStat)new Rate());
            this.auditLoggerCreationFailureSensor = this.metrics.sensor(AUDIT_LOGGER_CREATION_FAILURE_SENSOR);
            this.auditLoggerCreationFailureSensor.add(this.metrics.metricName(AUDIT_LOGGER_CREATION_FAILURE, GROUP_NAME, "Audit Logger creation failure metric"), (MeasurableStat)new CumulativeCount());
            this.addKafkaRequestEventMetrics();
            this.addFallbackAuditLogMetrics();
            if (ConfluentAuditLogProvider.this.isDRFeatureEnabled()) {
                this.remoteAuditlogConfigurationSourceSuccessSensor = this.metrics.sensor("remote-audit-log-configuration-source-success");
                this.remoteAuditlogConfigurationSourceSuccessSensor.add(this.metrics.metricName(REMOTE_AUDIT_LOG_SOURCE_SUCCESS_COUNT, GROUP_NAME, "The count of kafka brokers that have successfully setup remote polling source"), (MeasurableStat)new CumulativeCount());
                this.remoteAuditlogConfigurationSourceFailureSensor = this.metrics.sensor("remote-audit-log-configuration-source-failure");
                this.remoteAuditlogConfigurationSourceFailureSensor.add(this.metrics.metricName(REMOTE_AUDIT_LOG_SOURCE_FAILURE_COUNT, GROUP_NAME, "The count of kafka brokers that have failed to setup remote polling source"), (MeasurableStat)new CumulativeCount());
                this.remoteAuditlogConfigurationSourceStartFailureSensor = this.metrics.sensor("remote-audit-log-configuration-source-start-failure");
                this.remoteAuditlogConfigurationSourceStartFailureSensor.add(this.metrics.metricName(REMOTE_AUDIT_LOG_SOURCE_START_FAILURE_COUNT, GROUP_NAME, "The count of kafka brokers that have failed to start remote polling source"), (MeasurableStat)new CumulativeCount());
            }
        }

        void addKafkaRequestEventMetrics() {
            EnumSet<ApiKeys> supportedApis = EnumSet.copyOf(DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS);
            supportedApis.addAll(DetailedRequestAuditLogFilter.SUPPORTED_APIS_PRODUCE_CONSUME);
            for (ApiKeys apiKey : supportedApis) {
                this.kafkaRequestEventAuditLogSensor.put(apiKey, this.metrics.sensor("kafka-request-event-audit-log-" + apiKey.name()));
                this.kafkaRequestEventAuditLogSensor.get(apiKey).add(this.metrics.metricName(KAFKA_REQUEST_EVENT_AUDIT_LOG_RATE, GROUP_NAME, "The number of kafka request event audit log per second", new String[]{"api-key", apiKey.name()}), (MeasurableStat)new Rate());
            }
        }

        void addFallbackAuditLogMetrics() {
            for (FallbackReason reason : FallbackReason.values()) {
                this.fallbackAuditSensor.put(reason, this.metrics.sensor("audit-log-fallback-" + reason.name().toLowerCase(Locale.ROOT)));
                this.fallbackAuditSensor.get((Object)reason).add(this.metrics.metricName(AUDIT_LOG_FALLBACK_RATE_MINUTE, GROUP_NAME, "The number of audit log fallback per minute", new String[]{"reason", reason.name().toLowerCase(Locale.ROOT)}), (MeasurableStat)new Rate(TimeUnit.MINUTES, (SampledStat)new WindowedCount()));
            }
        }

        void addRemoteAuditConfigurationMetrics(String region) {
            if (Objects.isNull(region)) {
                log.error("Region is null. Cannot add remote audit configuration metrics");
                return;
            }
            if (!this.remoteAuditlogConfigurationRegion.containsKey(region)) {
                this.remoteAuditlogConfigurationRegion.put(region, this.metrics.sensor("remote-audit-log-region-" + region));
                this.remoteAuditlogConfigurationRegion.get(region).add(this.metrics.metricName(REMOTE_AUDIT_LOG_REGION_COUNT, GROUP_NAME, "The count of kafka brokers audit logging to a region", new String[]{"auditlog_region", region}), (MeasurableStat)new Value());
            }
        }
    }

    private class ConfiguredState {
        final EventLogger logger;
        final AuditLogRouter router;
        final AuditLogConfig config;

        private ConfiguredState(EventLogger logger, AuditLogRouter router, AuditLogConfig config) {
            this.logger = logger;
            this.router = router;
            this.config = config;
        }
    }

    static enum FallbackReason {
        EVENT_LOGGER_NOT_READY,
        KAFKA_EXCEPTION,
        ROUTE_NOT_SET,
        ROUTE_NOT_READY,
        AUDIT_LOGGER_CLOSED;

    }
}

