/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.router;

import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.security.audit.AuditLogEntry;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.AuthenticationInfo;
import io.confluent.security.audit.router.AuditLogRouterResult;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import io.confluent.security.audit.router.Router;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogCategoryResultRouter
implements Router {
    private static final Logger log = LoggerFactory.getLogger(AuditLogCategoryResultRouter.class);
    private final HashMap<String, HashMap<AuditLogRouterResult, String>> routes = new HashMap();

    public AuditLogCategoryResultRouter setRoute(String category, AuditLogRouterResult result, String topic) {
        this.routes.computeIfAbsent(category, k -> new HashMap()).put(result, topic);
        return this;
    }

    public Optional<String> route(String category, AuditLogRouterResult result) {
        return Optional.ofNullable(this.routes.get(category).get((Object)result));
    }

    private AuditLogRouterResult auditLogRouterResult(AuditLogEntry entry) {
        if ("kafka.Authentication".equals(entry.getMethodName())) {
            String status = entry.getResult().getStatus();
            return AuditEventStatus.SUCCESS == AuditEventStatus.valueOf((String)status) ? AuditLogRouterResult.ALLOWED : AuditLogRouterResult.DENIED;
        }
        return entry.getAuthorizationInfo().getGranted() ? AuditLogRouterResult.ALLOWED : AuditLogRouterResult.DENIED;
    }

    @Override
    public Optional<String> topic(AuditLogEntry auditLogEntry) {
        try {
            ConfluentResourceName.Element resource;
            String category = AuditLogRouterUtils.category(auditLogEntry);
            if (!this.routes.containsKey(category)) {
                return Optional.empty();
            }
            AuditLogRouterResult result = this.auditLogRouterResult(auditLogEntry);
            Optional<String> topic = Optional.ofNullable(this.routes.get(category).get((Object)result));
            if (topic.isPresent() && !topic.get().isEmpty() && ("consume".equals(category) || "produce".equals(category)) && (resource = AuditLogUtils.resourceNameElement(auditLogEntry)).resourceType().equals("topic") && resource.encodedResourceName().equals(topic.get())) {
                AuthenticationInfo info = auditLogEntry.getAuthenticationInfo();
                String principal = info == null ? "Unknown" : info.getPrincipal();
                log.error("Audit log event for {} event on audit log topic {} was routed to same topic. This indicates that there may be a feedback loop. Principal {} should be excluded from audit logging or this event should be routed to a different topic.", new Object[]{auditLogEntry.getMethodName(), topic.get(), principal});
                return Optional.of("");
            }
            return topic;
        }
        catch (CrnSyntaxException | NoSuchElementException e) {
            log.debug("Attempted to route a invalid AuditLogEntry", e);
            return Optional.empty();
        }
    }

    public String toString() {
        return "AuditLogCategoryResultRouter(" + this.routes + ")";
    }
}

