/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.security.authentication.utils.JacksonSerde;
import io.confluent.security.config.ConfigurationException;
import io.confluent.security.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class YamlConfigReader
implements ResourceLoader {
    private final ObjectMapper objectMapper;

    public YamlConfigReader() {
        this(JacksonSerde.objectMapper(JacksonSerde.DataFormat.YAML));
    }

    YamlConfigReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T load(URL url, Class<T> clazz) {
        try {
            return this.load(url.openStream(), clazz);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load configuration", e);
        }
    }

    @Override
    public <T> T load(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(inputStream, clazz);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load configuration ", e);
        }
    }
}

