/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.cel;

import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.Library;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Container;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Trait;
import org.projectnessie.cel.interpreter.functions.Overload;
import org.projectnessie.cel.parser.Macro;

public class TrustPolicyCelLibrary
implements Library {
    public static EnvOption customEnvOption() {
        return Library.Lib((Library)new TrustPolicyCelLibrary());
    }

    public List<EnvOption> getCompileOptions() {
        return Arrays.asList(EnvOption.declarations(TrustPolicyCelLibrary.subsetDeclarations()), EnvOption.macros(TrustPolicyCelLibrary.subsetMacros()));
    }

    public List<ProgramOption> getProgramOptions() {
        return Collections.singletonList(ProgramOption.functions((Overload[])TrustPolicyCelLibrary.subsetOverloads()));
    }

    private static Val inAggregate(Val lhs, Val rhs) {
        if (rhs.type().hasTrait(Trait.ContainerType)) {
            return ((Container)rhs).contains(lhs);
        }
        return Err.noSuchOverload((Val)lhs, (String)Operator.In.id, (Val)rhs);
    }

    private static Overload[] subsetOverloads() {
        return new Overload[]{Overload.unary((Operator)Operator.LogicalNot, (Trait)Trait.NegatorType, v -> {
            if (v.type().typeEnum() == TypeEnum.Bool) {
                return ((Negater)v).negate();
            }
            return Err.noSuchOverload(null, (String)Operator.LogicalNot.id, (Val)v);
        }), Overload.binary((Operator)Operator.In, TrustPolicyCelLibrary::inAggregate)};
    }

    private static List<Macro> subsetMacros() {
        return Collections.singletonList(Macro.AllMacros.stream().filter(macro -> Operator.Has.id.equals(macro.function())).findFirst().orElse(null));
    }

    private static List<Decl> subsetDeclarations() {
        Type paramA = Decls.newTypeParamType((String)"A");
        List<String> typeParamAList = Collections.singletonList("A");
        Type listOfA = Decls.newListType((Type)paramA);
        Type paramB = Decls.newTypeParamType((String)"B");
        List<String> typeParamABList = Arrays.asList("A", "B");
        Type mapOfAB = Decls.newMapType((Type)paramA, (Type)paramB);
        ArrayList<Decl> allowedIdents = new ArrayList<Decl>();
        allowedIdents.add(Decls.newFunction((String)Operator.LogicalAnd.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newOverload((String)"logical_and", Arrays.asList(Decls.Bool, Decls.Bool), (Type)Decls.Bool)}));
        allowedIdents.add(Decls.newFunction((String)Operator.LogicalOr.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newOverload((String)"logical_or", Arrays.asList(Decls.Bool, Decls.Bool), (Type)Decls.Bool)}));
        allowedIdents.add(Decls.newFunction((String)Operator.LogicalNot.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newOverload((String)"logical_not", Collections.singletonList(Decls.Bool), (Type)Decls.Bool)}));
        allowedIdents.add(Decls.newFunction((String)Operator.Equals.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newParameterizedOverload((String)"equals", Arrays.asList(paramA, paramA), (Type)Decls.Bool, typeParamAList)}));
        allowedIdents.add(Decls.newFunction((String)Operator.NotEquals.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newParameterizedOverload((String)"not_equals", Arrays.asList(paramA, paramA), (Type)Decls.Bool, typeParamAList)}));
        allowedIdents.add(Decls.newFunction((String)Operator.In.id, (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newParameterizedOverload((String)"in_list", Arrays.asList(paramA, listOfA), (Type)Decls.Bool, typeParamAList), Decls.newParameterizedOverload((String)"in_map", Arrays.asList(paramA, mapOfAB), (Type)Decls.Bool, typeParamABList)}));
        allowedIdents.add(Decls.newFunction((String)"endsWith", (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newInstanceOverload((String)"ends_with_string", Arrays.asList(Decls.String, Decls.String), (Type)Decls.Bool)}));
        allowedIdents.add(Decls.newFunction((String)"startsWith", (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newInstanceOverload((String)"starts_with_string", Arrays.asList(Decls.String, Decls.String), (Type)Decls.Bool)}));
        allowedIdents.add(Decls.newFunction((String)"contains", (Decl.FunctionDecl.Overload[])new Decl.FunctionDecl.Overload[]{Decls.newInstanceOverload((String)"contains_string", Arrays.asList(Decls.String, Decls.String), (Type)Decls.Bool)}));
        return allowedIdents;
    }
}

