/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.events.broker.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import io.confluent.kafka.durability.events.serdes.BaseInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MirrorStateChange
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static MirrorStateChange getRootAsMirrorStateChange(ByteBuffer _bb) {
        return MirrorStateChange.getRootAsMirrorStateChange(_bb, new MirrorStateChange());
    }

    public static MirrorStateChange getRootAsMirrorStateChange(ByteBuffer _bb, MirrorStateChange obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public MirrorStateChange __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int mirrorState() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : -1;
    }

    public BaseInfo info() {
        return this.info(new BaseInfo());
    }

    public BaseInfo info(BaseInfo obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int nodeId() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : -1;
    }

    public int isr(int j) {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int isrLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector isrVector() {
        return this.isrVector(new IntVector());
    }

    public IntVector isrVector(IntVector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer isrAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 4);
    }

    public ByteBuffer isrInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 4);
    }

    public static void startMirrorStateChange(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addMirrorState(FlatBufferBuilder builder, int mirrorState) {
        builder.addInt(0, mirrorState, -1);
    }

    public static void addInfo(FlatBufferBuilder builder, int infoOffset) {
        builder.addStruct(1, infoOffset, 0);
    }

    public static void addNodeId(FlatBufferBuilder builder, int nodeId) {
        builder.addInt(2, nodeId, -1);
    }

    public static void addIsr(FlatBufferBuilder builder, int isrOffset) {
        builder.addOffset(3, isrOffset, 0);
    }

    public static int createIsrVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startIsrVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endMirrorStateChange(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishMirrorStateChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedMirrorStateChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public MirrorStateChange get(int j) {
            return this.get(new MirrorStateChange(), j);
        }

        public MirrorStateChange get(MirrorStateChange obj, int j) {
            return obj.__assign(MirrorStateChange.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

