/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.storage.checksum.ChecksumAlgorithm;
import io.confluent.kafka.storage.checksum.ChecksumHeader;
import io.confluent.kafka.storage.checksum.ChecksumProtectionForTopicChecker;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.Crc32cChecksumStore;
import io.confluent.kafka.storage.checksum.Crc64ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumMetrics;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStoreConfig;
import io.confluent.kafka.storage.checksum.NoOpChecksumStore;
import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2EChecksumStore {
    public static final String STORE_FILE_NAME = "checksum.store";
    private static final Logger LOG = LoggerFactory.getLogger(E2EChecksumStore.class);
    private final E2EChecksumMetrics metrics;
    private final Time time;
    private final ChecksumStoreReaderWriter readerWriter;
    private final E2EChecksumStoreConfig config;
    private final boolean shouldRecover;
    private final ChecksumProtectionForTopicChecker checksumProtectionForTopicChecker;
    private volatile ChecksumStore store;
    private volatile boolean initialized;

    public E2EChecksumStore(E2EChecksumStoreConfig e2EChecksumStoreConfig, Time time, ChecksumStoreReaderWriter readerWriter, Metrics rootMetrics, boolean shouldRecover, ChecksumProtectionForTopicChecker checksumProtectionForTopicChecker) throws IOException {
        LOG.info("Initializing checksum store to protect Kafka files with config : {} ", (Object)e2EChecksumStoreConfig);
        this.metrics = new E2EChecksumMetrics(rootMetrics);
        this.time = time;
        this.readerWriter = readerWriter;
        this.config = e2EChecksumStoreConfig;
        this.checksumProtectionForTopicChecker = checksumProtectionForTopicChecker;
        this.shouldRecover = shouldRecover;
        this.store = this.createStore();
        this.initialized = true;
        LOG.info("Checksum store initialized successfully : {} ", this.store.getClass());
    }

    public E2EChecksumStore(E2EChecksumStoreConfig e2EChecksumStoreConfig, Time time, ChecksumStoreReaderWriter readerWriter, Metrics metrics) throws IOException {
        this(e2EChecksumStoreConfig, time, readerWriter, metrics, false, (partition, config) -> true);
    }

    private synchronized ChecksumStore createStore() throws IOException {
        ChecksumStore store;
        switch (this.config.tierBackend()) {
            case ABS: {
                store = new Crc64ChecksumStore(this.config.storeEntryTTL(), this.time, this.readerWriter, this.metrics);
                break;
            }
            case S3: 
            case GCS: 
            case MOCK: 
            case NONE: {
                store = new Crc32cChecksumStore(this.config.storeEntryTTL(), this.time, this.readerWriter, this.metrics);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TierBackend: " + (Object)((Object)this.config.tierBackend()));
            }
        }
        if (this.shouldRecover) {
            store.recover();
        }
        return store;
    }

    public void disableFeature() throws IOException {
        this.initialized = false;
        this.readerWriter.deleteIfExists();
        this.metrics.recordStoreFileSize(0L);
        this.store = new NoOpChecksumStore(new ChecksumHeader(0, ChecksumAlgorithm.CRC32C), this.config.storeEntryTTL(), this.time, this.readerWriter, this.metrics);
    }

    public void reEnableFeature() throws IOException {
        this.store = this.createStore();
        this.initialized = true;
    }

    public ChecksumStore store() {
        return this.store;
    }

    public ChecksumStoreReaderWriter readerWriter() {
        return this.readerWriter;
    }

    public synchronized void deRegisterMetrics() {
        if (this.initialized) {
            this.store().metrics().deRegister();
        }
    }

    public boolean checksumProtectionEnabled() {
        return this.initialized;
    }

    public boolean checksumProtectionEnabled(E2EChecksumProtectedObjectType objectType) {
        return this.checksumProtectionEnabled() && this.config.filesProtected().contains(objectType.suffix());
    }

    public boolean checksumProtectionEnabledForTopic(TopicPartition topicPartition, LogConfig config) {
        return this.checksumProtectionEnabled() && this.checksumProtectionForTopicChecker.enabled(topicPartition, config);
    }
}

