/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.nio.ByteBuffer;
import java.security.DigestException;
import org.apache.kafka.storage.internals.log.OffsetMap;

public class ExtendedOffsetMap
implements OffsetMap {
    private static final long TOMBSTONE_MASK = Long.MIN_VALUE;
    private final OffsetMap internalOffsetMap;
    private int tombstoneEntries = 0;

    public ExtendedOffsetMap(OffsetMap internalOffsetMap) {
        this.internalOffsetMap = internalOffsetMap;
    }

    @Override
    public int slots() {
        return this.internalOffsetMap.slots();
    }

    @Override
    public void put(ByteBuffer key, long offset) throws DigestException {
        this.internalOffsetMap.put(key, offset);
    }

    @Override
    public void put(ByteBuffer key, long offset, boolean isTombstone) throws DigestException {
        long oldOffset = this.internalOffsetMap.get(key);
        if (!isTombstone) {
            this.internalOffsetMap.put(key, offset);
            if (oldOffset != -1L && this.isTombstoneEntry(oldOffset)) {
                --this.tombstoneEntries;
            }
        } else {
            this.internalOffsetMap.put(key, offset | Long.MIN_VALUE);
            if (oldOffset == -1L || !this.isTombstoneEntry(oldOffset)) {
                ++this.tombstoneEntries;
            }
        }
    }

    @Override
    public long get(ByteBuffer key) throws DigestException {
        long res = this.internalOffsetMap.get(key);
        if (res == -1L) {
            return res;
        }
        return res & Long.MAX_VALUE;
    }

    @Override
    public void updateLatestOffset(long offset) {
        this.internalOffsetMap.updateLatestOffset(offset);
    }

    @Override
    public void clear() {
        this.internalOffsetMap.clear();
        this.tombstoneEntries = 0;
    }

    @Override
    public int size() {
        return this.internalOffsetMap.size();
    }

    @Override
    public long latestOffset() {
        return this.internalOffsetMap.latestOffset();
    }

    @Override
    public int memory() {
        return this.internalOffsetMap.memory();
    }

    @Override
    public double utilization() {
        return this.internalOffsetMap.utilization();
    }

    public int tombstoneCount() {
        return this.tombstoneEntries;
    }

    private boolean isTombstoneEntry(long offset) {
        return (offset & Long.MIN_VALUE) != 0L;
    }
}

