/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.model.Entity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSample<E extends Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSample.class);
    private static final long MIN_SAMPLE_OPEN_TIMESTAMP = Long.MAX_VALUE;
    private static final long MAX_SAMPLE_CLOSE_TIMESTAMP = -1L;
    protected final E entity;
    protected final Map<Short, Float> valuesByMetricId;
    protected long sampleOpenTime;
    protected long sampleCloseTime;

    public MetricSample(E entity) {
        this.entity = entity;
        this.valuesByMetricId = new HashMap<Short, Float>();
        this.sampleOpenTime = Long.MAX_VALUE;
        this.sampleCloseTime = -1L;
    }

    public void record(MetricInfo info, double sampleValue) {
        if (this.sampleOpenTime == Long.MAX_VALUE) {
            throw new IllegalStateException("The metric sample has not been opened yet");
        }
        if (this.sampleCloseTime >= 0L) {
            throw new IllegalStateException("The metric sample has been closed.");
        }
        Float origValue = this.valuesByMetricId.putIfAbsent(info.id(), Float.valueOf((float)sampleValue));
        if (origValue != null) {
            throw new IllegalStateException("Trying to record sample value " + sampleValue + " for " + (Object)((Object)info.kafkaMetricDef()) + ", but there is already a value " + origValue + " recorded.");
        }
    }

    public E entity() {
        return this.entity;
    }

    public long sampleOpenTime() {
        return this.sampleOpenTime;
    }

    public long sampleCloseTime() {
        return this.sampleCloseTime;
    }

    public Float metricValue(short metricId) {
        return this.valuesByMetricId.getOrDefault(metricId, Float.valueOf(Float.NaN));
    }

    public Map<Short, Float> allMetricValues() {
        return Collections.unmodifiableMap(this.valuesByMetricId);
    }

    public void open(long openingTime) {
        if (openingTime < 0L) {
            throw new IllegalArgumentException("Invalid closing time " + openingTime + ". The closing time cannot be negative.");
        }
        if (this.sampleOpenTime == Long.MAX_VALUE) {
            this.sampleOpenTime = openingTime;
        }
    }

    public void close(long closingTime) {
        if (closingTime < 0L) {
            throw new IllegalArgumentException("Invalid closing time " + closingTime + ". The closing time cannot be negative.");
        }
        if (this.sampleOpenTime == Long.MAX_VALUE) {
            throw new IllegalStateException("Cannot close a sample that has not been opened first.");
        }
        if (this.sampleCloseTime == -1L) {
            this.sampleCloseTime = closingTime;
        }
    }

    protected MetricDef metricDefForToString() {
        return null;
    }

    public boolean isValid(MetricDef metricDef) {
        boolean isValid;
        boolean bl = isValid = this.valuesByMetricId.size() == metricDef.size();
        if (!isValid && LOG.isDebugEnabled()) {
            Set missingMetricIds = metricDef.all().stream().map(MetricInfo::id).filter(metricId -> !this.valuesByMetricId.containsKey(metricId)).map(metricId -> metricDef.metricInfo((short)metricId).kafkaMetricDef()).collect(Collectors.toSet());
            LOG.debug("This metric sample is invalid since it has missing metrics. Missing metrics: {}. Sample: {}.", missingMetricIds, (Object)this);
        }
        return isValid;
    }

    public String toString() {
        MetricDef metricDef = this.metricDefForToString();
        if (metricDef == null) {
            return String.format("{entity=%s,sampleOpenTime=%d,sampleCloseTime=%d,metrics=%s}", this.entity, this.sampleOpenTime, this.sampleCloseTime, this.valuesByMetricId);
        }
        StringJoiner sj = new StringJoiner(",", "{", "}");
        sj.add(String.format("entity=(%s)", this.entity));
        sj.add(String.format("sampleOpenTime=%d", this.sampleOpenTime));
        sj.add(String.format("sampleCloseTime=%d", this.sampleCloseTime));
        for (MetricInfo metricInfo : this.metricDefForToString().all()) {
            sj.add(String.format("%s=%.3f", new Object[]{metricInfo.kafkaMetricDef(), this.valuesByMetricId.get(metricInfo.id())}));
        }
        return sj.toString();
    }
}

