/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregatorState;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.RawMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowCalculationHelper;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowState;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSampleAggregator<E extends Entity>
extends LongGenerationed {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSampleAggregator.class);
    private static final long INITIAL_BASE_MS = 0L;
    private final ConcurrentMap<E, RawMetricValues> rawMetrics;
    private final MetricSampleAggregatorState<E> aggregatorState;
    private final ConcurrentMap<E, E> identityEntityMap = new ConcurrentHashMap<E, E>();
    protected final int numWindows;
    protected final byte minSamplesPerWindow;
    protected final int numWindowsToKeep;
    protected final long windowMs;
    protected final MetricDef metricDef;
    protected SampleType sampleType;
    protected volatile long baseTimeMs;
    private volatile WindowIndex currentWindowIndex;
    private volatile WindowIndex startWindowIndex;
    private volatile WindowIndex preInvalidationWindowRangeStartIndex;
    private volatile WindowIndex preInvalidationWindowRangeEndIndex;

    public MetricSampleAggregator(int numWindows, long windowMs, byte minSamplesPerWindow, int completenessCacheSize, MetricDef metricDef) {
        super(0L);
        this.rawMetrics = new ConcurrentHashMap<E, RawMetricValues>();
        this.numWindows = numWindows;
        this.windowMs = windowMs;
        this.numWindowsToKeep = this.numWindows + 1;
        this.minSamplesPerWindow = minSamplesPerWindow;
        this.metricDef = metricDef;
        this.aggregatorState = new MetricSampleAggregatorState(numWindows, this.windowMs, completenessCacheSize);
        this.startWindowIndex = new WindowIndex(0L, WindowIndex.initialWindowIndex());
        this.currentWindowIndex = new WindowIndex(0L, WindowIndex.initialWindowIndex());
        this.baseTimeMs = 0L;
        this.preInvalidationWindowRangeEndIndex = new WindowIndex(0L, WindowIndex.initialWindowIndex());
        this.preInvalidationWindowRangeStartIndex = new WindowIndex(0L, WindowIndex.initialWindowIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSample(MetricSample<E> sample) {
        long windowIndex;
        if (!sample.isValid(this.metricDef)) {
            LOG.debug("The metric sample is discarded due to missing metrics. Sample: {}", sample);
            return false;
        }
        if (this.baseTimeMs != 0L && sample.sampleOpenTime() < this.baseTimeMs) {
            LOG.debug("This is unexpected, we found sample.open():{}({}) being older than invalidation ts:{}({}). Sampler should not have collected these metric points, one possibility is clock skew in some part which could have allowed other checks to pass.", new Object[]{KafkaCruiseControlUtils.toTimeString(sample.sampleOpenTime()), sample.sampleOpenTime(), KafkaCruiseControlUtils.toTimeString(this.baseTimeMs), this.baseTimeMs});
            return false;
        }
        if (sample.sampleOpenTime() < WindowCalculationHelper.findWindowStartTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs)) {
            LOG.debug("This is unexpected, we found sample open:{} being older than start window: {}. Sampler should not have collected these metric points, one possibility is clock skew in some part which could have allowed other checks to pass.", (Object)sample.sampleOpenTime(), (Object)WindowCalculationHelper.findWindowStartTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs));
            return false;
        }
        MetricSampleAggregator metricSampleAggregator = this;
        synchronized (metricSampleAggregator) {
            windowIndex = WindowCalculationHelper.windowIndex(sample.sampleCloseTime(), this.baseTimeMs, this.windowMs);
            this.maybeRollOutNewWindow(windowIndex);
        }
        RawMetricValues rawMetricValues = this.rawMetrics.computeIfAbsent(this.identity(sample.entity()), k -> this.defaultRawMetricValue());
        LOG.trace("Adding sample {} to window index {}", sample, (Object)windowIndex);
        rawMetricValues.addSample(sample, windowIndex, this.metricDef);
        return true;
    }

    private synchronized RawMetricValues defaultRawMetricValue() {
        RawMetricValues rawValues = new RawMetricValues(this.numWindowsToKeep, this.minSamplesPerWindow, this.metricDef.size());
        rawValues.updateStartWindowIndex(this.startWindowIndex.windowIndex());
        return rawValues;
    }

    public synchronized MetricSampleAggregationResult<E> aggregate(long from, long to, AggregationOptions<E> options, Set<Integer> failedBrokers) throws NotEnoughValidWindowsException {
        long fromWindowIndex = Math.max(WindowCalculationHelper.windowIndex(from, this.baseTimeMs, this.windowMs), this.startWindowIndex.windowIndex());
        long toWindowIndex = Math.min(WindowCalculationHelper.windowIndex(to, this.baseTimeMs, this.windowMs), this.currentWindowIndex.windowIndex() - 1L);
        LOG.debug("Aggregating metrics from timestamps {} (index: {}) to {} (index: {}) and indices from {} to {} (currentWindowIndex {})", new Object[]{KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(from), WindowCalculationHelper.windowIndex(from, this.baseTimeMs, this.windowMs), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(to), WindowCalculationHelper.windowIndex(to, this.baseTimeMs, this.windowMs), fromWindowIndex, toWindowIndex, this.currentWindowIndex.windowIndex()});
        if (fromWindowIndex > this.currentWindowIndex.windowIndex() || toWindowIndex < this.startWindowIndex.windowIndex()) {
            String errMsg = String.format("There is no window available in range [%d, %d] (%s - %s). In other words calculated window indices: (fromWindowIndex: %d, toWindowIndex: %d) are out of range (currentWindowIndex: %d, startWindowIndex: %d)", from, to, KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(from), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(to), fromWindowIndex, toWindowIndex, this.currentWindowIndex.windowIndex(), this.startWindowIndex.windowIndex());
            throw new NotEnoughValidWindowsException(errMsg);
        }
        this.maybeUpdateAggregatorState();
        AggregationOptions<E> interpretedOptions = this.interpretAggregationOptions(options);
        MetricSampleCompleteness<E> completeness = this.aggregatorState.completeness(fromWindowIndex, toWindowIndex, interpretedOptions, this.generation(), failedBrokers);
        this.validateCompleteness(from, to, completeness, interpretedOptions);
        List<Long> windows = WindowCalculationHelper.toWindows(completeness.validWindowIndices(), this.baseTimeMs, this.windowMs);
        MetricSampleAggregationResult<Entity> result = new MetricSampleAggregationResult<Entity>(this.generation(), completeness);
        Set<E> entitiesToInclude = interpretedOptions.includeInvalidEntities() ? interpretedOptions.interestedEntities() : completeness.validEntities();
        for (Entity entity : entitiesToInclude) {
            ValuesAndExtrapolations valuesAndExtrapolations;
            RawMetricValues rawValues = (RawMetricValues)this.rawMetrics.get(entity);
            if (rawValues == null) {
                valuesAndExtrapolations = ValuesAndExtrapolations.empty(completeness.validWindowIndices().size(), this.metricDef);
                valuesAndExtrapolations.setWindows(windows);
                result.addResult(entity, valuesAndExtrapolations);
                result.recordInvalidEntity(entity);
                continue;
            }
            valuesAndExtrapolations = rawValues.aggregate(completeness.validWindowIndices(), this.metricDef);
            valuesAndExtrapolations.setWindows(windows);
            result.addResult(entity, valuesAndExtrapolations);
            if (rawValues.isValid(options.maxAllowedExtrapolationsPerEntity())) continue;
            result.recordInvalidEntity(entity);
        }
        return result;
    }

    public MetricSampleAggregationResult<E> aggregate(long from, long to, AggregationOptions<E> options) throws NotEnoughValidWindowsException {
        return this.aggregate(from, to, options, Collections.emptySet());
    }

    public synchronized Map<E, ValuesAndExtrapolations> peekCurrentWindow() {
        HashMap result = new HashMap();
        this.rawMetrics.forEach((entity, rawMetric) -> {
            ValuesAndExtrapolations vae = rawMetric.peekCurrentWindow(this.currentWindowIndex.windowIndex(), this.metricDef);
            TreeSet<Long> currentWindows = new TreeSet<Long>(Collections.singleton(this.currentWindowIndex.windowIndex()));
            vae.setWindows(WindowCalculationHelper.toWindows(currentWindows, this.baseTimeMs, this.windowMs));
            result.put(entity, vae);
        });
        return result;
    }

    public synchronized MetricSampleCompleteness<E> completeness(long from, long to, AggregationOptions<E> options, Set<Integer> failedBrokerIds) {
        long fromWindowIndex = Math.max(WindowCalculationHelper.windowIndex(from, this.baseTimeMs, this.windowMs), this.startWindowIndex.windowIndex());
        long toWindowIndex = Math.min(WindowCalculationHelper.windowIndex(to, this.baseTimeMs, this.windowMs), this.currentWindowIndex.windowIndex() - 1L);
        if (fromWindowIndex > this.currentWindowIndex.windowIndex() || toWindowIndex < this.startWindowIndex.windowIndex()) {
            LOG.debug("Returning an empty metric sample completeness result because the indices don't align (fromWindow: {}, toWindow: {}, currentWindow: {} startWindow: {})", new Object[]{fromWindowIndex, toWindowIndex, this.currentWindowIndex.windowIndex(), this.startWindowIndex.windowIndex()});
            return new MetricSampleCompleteness(this.generation(), this.windowMs);
        }
        this.maybeUpdateAggregatorState();
        return this.aggregatorState.completeness(fromWindowIndex, toWindowIndex, this.interpretAggregationOptions(options), this.generation(), failedBrokerIds);
    }

    public MetricSampleCompleteness<E> completeness(long from, long to, AggregationOptions<E> options) {
        return this.completeness(from, to, options, Collections.emptySet());
    }

    public List<Long> availableWindows() {
        return this.getWindowList(this.startWindowIndex.windowIndex(), this.currentWindowIndex.windowIndex() - 1L);
    }

    public int numAvailableWindows() {
        return this.numAvailableWindows(-1L, Long.MAX_VALUE);
    }

    public int numAvailableWindows(long from, long to) {
        long fromWindowIndex = Math.max(WindowCalculationHelper.windowIndex(from, this.baseTimeMs, this.windowMs), this.startWindowIndex.windowIndex());
        long toWindowIndex = Math.min(WindowCalculationHelper.windowIndex(to, this.baseTimeMs, this.windowMs), this.currentWindowIndex.windowIndex() - 1L);
        return Math.max(0, (int)(toWindowIndex - fromWindowIndex + 1L));
    }

    public List<Long> allWindows() {
        return this.getWindowList(this.startWindowIndex.windowIndex(), this.currentWindowIndex.windowIndex());
    }

    Long earliestWindowTimestamp() {
        return this.rawMetrics.isEmpty() ? null : Long.valueOf(WindowCalculationHelper.findWindowEndTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs));
    }

    Long latestWindowTimestamp() {
        return this.rawMetrics.isEmpty() ? null : Long.valueOf(WindowCalculationHelper.findWindowEndTimestamp(this.currentWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs));
    }

    public int numSamples() {
        return this.rawMetrics.values().stream().mapToInt(RawMetricValues::numSamples).sum();
    }

    public void retainEntityGroup(Set<String> entityGroups) {
        boolean anyElementsRemoved = this.rawMetrics.entrySet().removeIf(entry -> !entityGroups.contains(((Entity)entry.getKey()).group()));
        if (anyElementsRemoved) {
            this.generation.incrementAndGet();
        }
    }

    MetricSampleAggregatorState<E> aggregatorState() {
        this.maybeUpdateAggregatorState();
        return this.aggregatorState;
    }

    private synchronized List<Long> getWindowList(long fromWindowIndex, long toWindowIndex) {
        if (this.rawMetrics.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> windows = new ArrayList<Long>((int)(toWindowIndex - fromWindowIndex + 1L));
        WindowCalculationHelper.populateTimestamps(windows, fromWindowIndex, toWindowIndex, this.baseTimeMs, this.windowMs);
        return windows;
    }

    private void maybeUpdateAggregatorState() {
        long currentGeneration = this.generation();
        for (long windowIndex : this.aggregatorState.windowIndicesToUpdate(new WindowRange(this.startWindowIndex, this.currentWindowIndex))) {
            this.aggregatorState.updateWindowState(windowIndex, this.getWindowState(windowIndex, currentGeneration));
        }
    }

    private WindowState<E> getWindowState(long windowIndex, long currentGeneration) {
        WindowState<Entity> windowState = new WindowState<Entity>(currentGeneration);
        for (Map.Entry entry : this.rawMetrics.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            RawMetricValues rawValues = (RawMetricValues)entry.getValue();
            rawValues.sanityCheckWindowIndex(windowIndex);
            if (rawValues.isExtrapolatedAtWindowIndex(windowIndex)) {
                windowState.addExtrapolatedEntities(entity);
            }
            if (rawValues.isValidAtWindowIndex(windowIndex)) {
                windowState.addValidEntities(entity);
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            String entityInfo = "";
            if (entity instanceof PartitionEntity) {
                TopicPartition tp = ((PartitionEntity)entity).tp();
                entityInfo = tp.toString();
            } else if (entity instanceof ReplicaEntity) {
                entityInfo = entity.toString();
            }
            ValuesAndExtrapolations vae = rawValues.peekCurrentWindow(windowIndex, this.metricDef);
            StringBuilder rawMetricInfo = new StringBuilder();
            for (Short metricId : vae.metricValues().metricIds()) {
                rawMetricInfo.append(String.format("metric info: %s , value: %s", this.metricDef.metricInfo(metricId).toString(), Float.valueOf(vae.metricValues().valuesFor(metricId).avg())));
            }
            LOG.trace("entity:{} is invalid at window index:{}, rawValues: countsOfSamplesAtWindow: {} \n\t\t rawMetric Info: {}", new Object[]{entityInfo, windowIndex, rawValues.sampleCountsAtWindowIndex(windowIndex), rawMetricInfo});
        }
        return windowState;
    }

    public synchronized void onSamplingFinish(long windowEndMs) {
        long currentWindow = WindowCalculationHelper.windowIndex(windowEndMs, this.baseTimeMs, this.windowMs);
        this.maybeRollOutNewWindow(currentWindow + 1L);
    }

    synchronized void maybeRollOutNewWindow(long mayBeNewWindowIndex) {
        if (this.currentWindowIndex.windowIndex() >= mayBeNewWindowIndex) {
            LOG.trace("window index is already available no need to roll new window.");
            return;
        }
        WindowIndex newWindowIndex = new WindowIndex(this.baseTimeMs, mayBeNewWindowIndex);
        int numWindowsToRollOut = !this.currentWindowIndex.isUsableWindow() ? 1 : (int)new WindowRange(this.currentWindowIndex, newWindowIndex).numWindows();
        WindowIndex previousWindowRangeStartIndex = this.startWindowIndex;
        long newStartWindowIndex = Math.max(1L, mayBeNewWindowIndex - (long)this.numWindows);
        this.startWindowIndex = new WindowIndex(this.baseTimeMs, newStartWindowIndex);
        WindowResetStatistics resetStatistics = null;
        resetStatistics = this.currentWindowIndex.isUsableWindow() ? this.rollingWindowInvalidation(new WindowRange(previousWindowRangeStartIndex, this.startWindowIndex)) : this.discardingInvalidation(newStartWindowIndex);
        long oldGeneration = this.generation();
        this.aggregatorState.updateWindowGeneration(this.currentWindowIndex.windowIndex(), oldGeneration);
        this.currentWindowIndex = new WindowIndex(this.baseTimeMs, mayBeNewWindowIndex);
        long newGeneration = this.generation.incrementAndGet();
        this.aggregatorState.updateWindowGeneration(mayBeNewWindowIndex, newGeneration);
        this.logWindowRolloutSummary(numWindowsToRollOut, resetStatistics, oldGeneration, newGeneration);
    }

    private void logWindowRolloutSummary(int numWindowsToRollOut, WindowResetStatistics windowResetStatistics, long oldGeneration, long newGeneration) {
        String rolloutLog = String.format("%s Aggregator rolled out %s, reset %s windows and bumped generation from %s->%s,", new Object[]{this.sampleType, numWindowsToRollOut == 1 ? "a new window" : String.format("%d new windows", numWindowsToRollOut), windowResetStatistics.numOldWindowIndicesReset, oldGeneration, newGeneration});
        String windowRangeLog = String.format("current window range [%s, %s, %s to %s],", WindowCalculationHelper.findWindowStartTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs), WindowCalculationHelper.findWindowStartTimestamp(this.currentWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(WindowCalculationHelper.findWindowStartTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs)), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(WindowCalculationHelper.findWindowStartTimestamp(this.currentWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs)));
        String abandonLog = String.format("abandon %s samples.", windowResetStatistics.numAbandonedSamples);
        LOG.info(rolloutLog + windowRangeLog + abandonLog, (Object)windowResetStatistics.numAbandonedSamples);
    }

    WindowResetStatistics discardingInvalidation(long latestStartWindowIndex) {
        return this.resetWindowStatistics(new WindowRange(this.preInvalidationWindowRangeStartIndex, this.preInvalidationWindowRangeEndIndex), latestStartWindowIndex);
    }

    WindowResetStatistics rollingWindowInvalidation(WindowRange windowRange) {
        return this.resetWindowStatistics(windowRange, windowRange.endWindow().windowIndex());
    }

    private WindowResetStatistics resetWindowStatistics(WindowRange windowRange, long latestStartWindowIndex) {
        int numOldWindowIndicesToReset = (int)Math.min((long)this.numWindowsToKeep, windowRange.numWindows());
        if (numOldWindowIndicesToReset == 0) {
            return new WindowResetStatistics(0, 0);
        }
        return new WindowResetStatistics(numOldWindowIndicesToReset, this.resetIndices(windowRange, latestStartWindowIndex));
    }

    public synchronized boolean maybeInvalidateWindowsBefore(long invalidWindowMs) {
        LOG.info("Invalidating metric windows up to timestamp: {}({}}) (current window ID {}, start window ID {})", new Object[]{invalidWindowMs, KafkaCruiseControlUtils.toTimeString(invalidWindowMs), this.currentWindowIndex.windowIndex(), this.startWindowIndex.windowIndex()});
        if (invalidWindowMs <= this.baseTimeMs) {
            LOG.warn("Trying to invalidate a window for timestamp:{}({}) that has already been invalidated, because latest invalidated window timestamp is {}({})", new Object[]{KafkaCruiseControlUtils.toTimeString(invalidWindowMs), invalidWindowMs, KafkaCruiseControlUtils.toTimeString(this.baseTimeMs), this.baseTimeMs});
            return false;
        }
        if (WindowCalculationHelper.findWindowStartTimestamp(this.startWindowIndex.windowIndex(), this.baseTimeMs, this.windowMs) <= invalidWindowMs) {
            this.preInvalidationWindowRangeStartIndex = this.startWindowIndex;
            this.startWindowIndex = new WindowIndex(invalidWindowMs, WindowIndex.initialWindowIndex());
            this.currentWindowIndex = new WindowIndex(invalidWindowMs, WindowIndex.initialWindowIndex());
            this.preInvalidationWindowRangeEndIndex = new WindowIndex(this.baseTimeMs, WindowCalculationHelper.windowIndex(invalidWindowMs, this.baseTimeMs, this.windowMs));
            this.baseTimeMs = invalidWindowMs;
            return true;
        }
        LOG.info("No metric windows currently invalidated -- no windows at validation index {}({}) (current window ID {}, start window ID {}) latestInvalidationTime: {}({})", new Object[]{KafkaCruiseControlUtils.toTimeString(invalidWindowMs), invalidWindowMs, this.currentWindowIndex.windowIndex(), this.startWindowIndex.windowIndex(), KafkaCruiseControlUtils.toTimeString(this.baseTimeMs), this.baseTimeMs});
        return false;
    }

    private int resetIndices(WindowRange windowRangeToReset, long currentStartWindowIndex) {
        int numAbandonedSamples = this.rawMetrics.values().stream().mapToInt(rawMetricValues -> {
            rawMetricValues.updateStartWindowIndex(currentStartWindowIndex);
            return rawMetricValues.resetWindowIndices(windowRangeToReset);
        }).sum();
        this.aggregatorState.updateStartWindowIndex(currentStartWindowIndex);
        this.aggregatorState.resetWindowIndices(windowRangeToReset);
        return numAbandonedSamples;
    }

    private void validateCompleteness(long from, long to, MetricSampleCompleteness completeness, AggregationOptions<E> options) throws NotEnoughValidWindowsException {
        if (completeness.validWindowIndices().size() < options.minValidWindows()) {
            throw new NotEnoughValidWindowsException(String.format("There are only %d valid windows when aggregating in range [%d, %d] for aggregation options %s", completeness.validWindowIndices().size(), from, to, options));
        }
        if ((double)completeness.validEntityRatio() < options.minValidEntityRatio()) {
            throw new IllegalStateException(String.format("The entity coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityRatio()), from, to, options));
        }
        if ((double)completeness.validEntityGroupRatio() < options.minValidEntityGroupRatio()) {
            throw new IllegalStateException(String.format("The entity group coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityGroupRatio()), from, to, options));
        }
    }

    private AggregationOptions<E> interpretAggregationOptions(AggregationOptions<E> options) {
        HashSet<Object> entitiesToInclude = new HashSet<Object>();
        if (options.interestedEntities().isEmpty()) {
            entitiesToInclude.addAll(this.rawMetrics.keySet());
        } else {
            for (Entity entity : options.interestedEntities()) {
                entitiesToInclude.add(this.identity(entity));
            }
        }
        return new AggregationOptions(options.minValidEntityRatio(), options.minValidEntityGroupRatio(), options.minValidWindows(), options.maxAllowedExtrapolationsPerEntity(), entitiesToInclude, options.granularity(), options.includeInvalidEntities());
    }

    protected E identity(E entity) {
        if (this.numWindows <= 1) {
            return entity;
        }
        return (E)this.identityEntityMap.computeIfAbsent(entity, e -> entity);
    }

    static class WindowRange {
        private final WindowIndex startWindow;
        private final WindowIndex endWindow;

        WindowRange(WindowIndex startWindow, WindowIndex endWindow) {
            if (startWindow.baseTimestampMs() != endWindow.baseTimestampMs()) {
                throw new IllegalArgumentException(String.format("Base timestamp of start window:{%s} and end window:{%s} don't match.", startWindow, endWindow));
            }
            this.startWindow = startWindow;
            this.endWindow = endWindow;
        }

        public long numWindows() {
            return this.endWindow.windowIndex - this.startWindow.windowIndex;
        }

        public WindowIndex startWindow() {
            return this.startWindow;
        }

        public WindowIndex endWindow() {
            return this.endWindow;
        }
    }

    static class WindowIndex {
        private static final long INITIAL_WINDOW_ID = 0L;
        private final long baseTimestampMs;
        private final long windowIndex;

        public WindowIndex(long baseTimestampMs, long windowIndex) {
            this.baseTimestampMs = baseTimestampMs;
            this.windowIndex = windowIndex;
        }

        public long windowIndex() {
            return this.windowIndex;
        }

        public long baseTimestampMs() {
            return this.baseTimestampMs;
        }

        public long offsetFromWindow(WindowIndex otherWindow) {
            if (otherWindow.baseTimestampMs() != this.baseTimestampMs()) {
                throw new IllegalArgumentException(String.format("Comparing windows with different base timestamps. window 1: %s window 2: %s", this, otherWindow));
            }
            return this.windowIndex - otherWindow.windowIndex;
        }

        public String toString() {
            return "WindowIndex{baseTimestampMs=" + this.baseTimestampMs + ", windowIndex=" + this.windowIndex + '}';
        }

        private boolean isUsableWindow() {
            return this.windowIndex() > 0L;
        }

        public static long initialWindowIndex() {
            return 0L;
        }
    }

    protected static enum SampleType {
        BROKER,
        PARTITION,
        REPLICA;

    }

    static class WindowResetStatistics {
        int numOldWindowIndicesReset;
        int numAbandonedSamples;

        public WindowResetStatistics(int numOldWindowIndicesToReset, int numAbandonedSamples) {
            this.numOldWindowIndicesReset = numOldWindowIndicesToReset;
            this.numAbandonedSamples = numAbandonedSamples;
        }
    }
}

