/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.Extrapolation;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValuesAndExtrapolations {
    private final AggregatedMetricValues metricValues;
    private final Map<Integer, Extrapolation> extrapolations;
    private List<Long> windows;

    public ValuesAndExtrapolations(AggregatedMetricValues metricValues, Map<Integer, Extrapolation> extrapolations) {
        this.metricValues = metricValues;
        this.extrapolations = extrapolations;
    }

    public AggregatedMetricValues metricValues() {
        return this.metricValues;
    }

    public Map<Integer, Extrapolation> extrapolations() {
        return this.extrapolations;
    }

    public List<Long> windows() {
        return Collections.unmodifiableList(this.windows);
    }

    public long window(int index) {
        return this.windows.get(index);
    }

    public void setWindows(List<Long> windows) {
        this.windows = windows;
    }

    static ValuesAndExtrapolations empty(int numWindows, MetricDef metricDef) {
        HashMap<Short, MetricValues> values = new HashMap<Short, MetricValues>(metricDef.all().size());
        for (short i = 0; i < metricDef.all().size(); i = (short)(i + 1)) {
            values.put(i, new MetricValues(numWindows));
        }
        HashMap<Integer, Extrapolation> extrapolations = new HashMap<Integer, Extrapolation>(numWindows);
        for (int i = 0; i < numWindows; ++i) {
            extrapolations.put(i, Extrapolation.NO_VALID_EXTRAPOLATION);
        }
        return new ValuesAndExtrapolations(new AggregatedMetricValues(values), extrapolations);
    }
}

