/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaRelocationContext;
import java.util.Optional;
import java.util.Stack;
import org.apache.kafka.common.TopicPartition;

public class BalancingActionsLog {
    private final Stack<ReplicaBalancingAction> balancingActions = new Stack();
    private int numProposalsAccepted = 0;
    private int numMovesAccepted = 0;

    public void recordBalancingAction(ReplicaBalancingAction action) {
        this.balancingActions.push(action);
        ++this.numProposalsAccepted;
        if (action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
            ++this.numMovesAccepted;
        }
    }

    public int revertActions(ClusterModel model) {
        int reverted = this.balancingActions.size();
        while (!this.balancingActions.empty()) {
            ReplicaBalancingAction action = this.balancingActions.pop();
            TopicPartition tp = action.topicPartition();
            int sourceBroker = action.sourceBrokerId();
            int destinationBroker = action.destinationBrokerId();
            Replica destinationReplica = model.broker(destinationBroker).replica(tp);
            ActionType actionType = action.balancingAction();
            if (actionType == ActionType.LEADERSHIP_MOVEMENT) {
                model.relocateLeadership(tp, destinationBroker, sourceBroker);
                continue;
            }
            if (actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                model.relocateReplica(tp, destinationBroker, sourceBroker, ReplicaRelocationContext.forReplicaMovementAction(destinationReplica, sourceBroker));
                continue;
            }
            throw new UnsupportedOperationException(String.format("Reverting balancing action of type %s is not supported.", new Object[]{actionType}));
        }
        return reverted;
    }

    public void revertAcceptedProposals(ProposalStats.Builder proposalStatsBuilder, Integer brokerId, Optional<String> revertingGoal) {
        proposalStatsBuilder.revertAcceptedProposals(brokerId, this.numProposalsAccepted, this.numMovesAccepted, revertingGoal);
        this.numProposalsAccepted = 0;
        this.numMovesAccepted = 0;
    }

    Stack<ReplicaBalancingAction> balancingActions() {
        return this.balancingActions;
    }

    int numProposalsAccepted() {
        return this.numProposalsAccepted;
    }

    int numMovesAccepted() {
        return this.numMovesAccepted;
    }
}

