/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.analyzer.result.OptimizationPlaintextSummary;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.monitor.SingleBrokerStats;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.common.EvenClusterLoadPlanBrokerStats;
import kafka.common.EvenClusterLoadPlanDetailedClusterBalanceStats;
import kafka.common.EvenClusterLoadPlanGoalOverview;
import kafka.common.EvenClusterLoadPlanGoalStats;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadPlanInternalBrokerRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalClusterRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalGoalRelatedStats;
import kafka.common.EvenClusterLoadPlanInternalReplicaMovementStats;
import kafka.common.EvenClusterLoadPlanRejectingGoal;
import kafka.common.EvenClusterLoadPlanResources;

public class OptimizationResult {
    protected static final String GOAL = "goal";
    protected static final String VIOLATED = "VIOLATED";
    protected static final String FIXED = "FIXED";
    protected static final String NO_ACTION = "NO-ACTION";
    protected OptimizerResult optimizerResult;
    private OptimizationPlaintextSummary cachedPlaintext;

    public OptimizationResult(OptimizerResult optimizerResult) {
        this.optimizerResult = optimizerResult;
        this.cachedPlaintext = null;
    }

    public OptimizerResult optimizerResult() {
        return this.optimizerResult;
    }

    public OptimizationPlaintextSummary cachedPlaintextSelfHealingSummary() {
        return this.cachedPlaintext;
    }

    public OptimizationPlaintextSummary proposalSummary(String operation) {
        if (this.cachedPlaintext == null) {
            String lineSep = System.lineSeparator();
            String pretext = String.format("%s%sCluster load after %s:%s", lineSep, lineSep, operation, lineSep);
            this.cachedPlaintext = new OptimizationPlaintextSummary(this.generatePlaintext(false, pretext), this.generatePlaintext(true, pretext));
        }
        return this.cachedPlaintext;
    }

    protected String generatePlaintext(boolean isVerbose, String pretext) {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.lineSeparator();
        this.writeProposalSummary(sb, isVerbose);
        sb.append(String.format("%s%sCurrent load:%s%s", lineSep, lineSep, lineSep, this.optimizerResult.brokerStatsBeforeOptimization().toString()));
        sb.append(String.format("%s%s%s%s", pretext, this.optimizerResult.brokerStatsAfterOptimization().toString(), lineSep, lineSep));
        sb.append(String.format("Proposals: %s%s%s", lineSep, lineSep, this.optimizerResult.goalProposals().toString()));
        return sb.toString();
    }

    public void cacheText() {
        if (this.optimizerResult != null) {
            String pretext = String.format("%n%nCluster load after self-healing:%n", new Object[0]);
            this.cachedPlaintext = new OptimizationPlaintextSummary(this.generatePlaintext(false, pretext), this.generatePlaintext(false, pretext));
        }
    }

    private void writeProposalSummary(StringBuilder sb, boolean isVerbose) {
        String lineSep = System.lineSeparator();
        sb.append(this.optimizerResult.getProposalSummary());
        for (Map.Entry<String, ClusterModelStats> entry : this.optimizerResult.clusterStatsByGoalName().entrySet()) {
            String goalName = entry.getKey();
            if (this.goalResultDescription(goalName).equals(NO_ACTION)) {
                sb.append(String.format("%s%s(%s)%s", lineSep, goalName, this.goalResultDescription(goalName), lineSep));
                continue;
            }
            sb.append(String.format("%s%sStats for %s(%s):%s", lineSep, lineSep, goalName, this.goalResultDescription(goalName), lineSep));
            sb.append(entry.getValue().toString());
            ProposalStats proposalStats = this.optimizerResult.proposalStatsByGoalName().get(goalName);
            if (proposalStats == null) continue;
            sb.append(String.format("%s%s%s", lineSep, proposalStats.generateString(isVerbose), lineSep));
        }
    }

    private String goalResultDescription(String goalName) {
        return this.optimizerResult.violatedGoalsBeforeOptimization().contains(goalName) ? (this.optimizerResult.violatedGoalsAfterOptimization().contains(goalName) ? VIOLATED : FIXED) : NO_ACTION;
    }

    public EvenClusterLoadPlanInternal toEvenClusterLoadPlan() {
        return new EvenClusterLoadPlanInternal(this.getReplicaMovementStats(this.optimizerResult), this.getBrokerRelatedStats(this.optimizerResult), this.getClusterRelatedStats(this.optimizerResult), this.getDetailedClusterBalanceStats(this.optimizerResult), this.getGoalRelatedStats(this.optimizerResult));
    }

    private EvenClusterLoadPlanInternalReplicaMovementStats getReplicaMovementStats(OptimizerResult optimizerResult) {
        return new EvenClusterLoadPlanInternalReplicaMovementStats(optimizerResult.replicaMovements().numInterBrokerReplicaMovements(), (double)optimizerResult.replicaMovements().interBrokerDataToMove(), optimizerResult.replicaMovements().numLeadershipMovements());
    }

    private EvenClusterLoadPlanInternalBrokerRelatedStats getBrokerRelatedStats(OptimizerResult optimizerResult) {
        return new EvenClusterLoadPlanInternalBrokerRelatedStats(new ArrayList<Integer>(optimizerResult.excludedBrokersForLeadership()), new ArrayList<Integer>(optimizerResult.excludedBrokersForReplicaMove()), new ArrayList<Integer>(optimizerResult.brokersWithState(Broker.Strategy.NEW)), new ArrayList<Integer>(optimizerResult.brokersWithState(Broker.Strategy.DEAD)));
    }

    private EvenClusterLoadPlanInternalClusterRelatedStats getClusterRelatedStats(OptimizerResult optimizerResult) {
        return new EvenClusterLoadPlanInternalClusterRelatedStats(optimizerResult.clusterModelStats().numSnapshotWindows(), optimizerResult.clusterModelStats().monitoredPartitionsPercentage(), new ArrayList<String>(optimizerResult.excludedTopics()), optimizerResult.clusterModelStats().numBrokers(), optimizerResult.clusterModelStats().numReplicasInCluster(), optimizerResult.clusterModelStats().numTopics());
    }

    private EvenClusterLoadPlanDetailedClusterBalanceStats getDetailedClusterBalanceStats(OptimizerResult optimizerResult) {
        return new EvenClusterLoadPlanDetailedClusterBalanceStats(optimizerResult.onDemandBalancednessScoreBefore(), optimizerResult.onDemandBalancednessScoreAfter(), optimizerResult.brokerStatsBeforeOptimization().stats().stream().map(this::convertToPlanBrokerStats).collect(Collectors.toList()), optimizerResult.brokerStatsAfterOptimization().stats().stream().map(this::convertToPlanBrokerStats).collect(Collectors.toList()));
    }

    private EvenClusterLoadPlanInternalGoalRelatedStats getGoalRelatedStats(OptimizerResult optimizerResult) {
        return new EvenClusterLoadPlanInternalGoalRelatedStats(new ArrayList<String>(optimizerResult.goalNamesWithProposals()), optimizerResult.clusterStatsByGoalName().keySet().stream().map(goalName -> new EvenClusterLoadPlanGoalStats(goalName, this.convertToPlanResources((String)goalName, Statistic.AVG), this.convertToPlanResources((String)goalName, Statistic.MAX), this.convertToPlanResources((String)goalName, Statistic.MIN), this.convertToPlanResources((String)goalName, Statistic.ST_DEV), new EvenClusterLoadPlanGoalOverview(this.goalResultDescription((String)goalName), optimizerResult.proposalStatsByGoalName().get(goalName).rejectingGoalCount().keySet().stream().map(rejectingGoalName -> new EvenClusterLoadPlanRejectingGoal(rejectingGoalName, optimizerResult.proposalStatsByGoalName().get(goalName).rejectingGoalCount().get(rejectingGoalName).intValue())).collect(Collectors.toList()), optimizerResult.proposalStatsByGoalName().get(goalName).proposalsGenerated(), optimizerResult.proposalStatsByGoalName().get(goalName).proposalsRejected(), optimizerResult.proposalStatsByGoalName().get(goalName).proposalsRejectedPercent(), optimizerResult.proposalStatsByGoalName().get(goalName).proposalsAccepted(), optimizerResult.proposalStatsByGoalName().get(goalName).proposalsAcceptedPercent(), optimizerResult.proposalStatsByGoalName().get(goalName).movesAccepted(), optimizerResult.proposalStatsByGoalName().get(goalName).swapsAccepted()))).collect(Collectors.toList()), new ArrayList<String>(optimizerResult.violatedGoalsBeforeOptimization()), new ArrayList<String>(optimizerResult.violatedGoalsAfterOptimization()));
    }

    private EvenClusterLoadPlanResources convertToPlanResources(String goalName, Statistic statistic) {
        return new EvenClusterLoadPlanResources((double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.CPU).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.NW_IN).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.PRODUCE_IN).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.NW_OUT).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.CONSUME_OUT).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).resourceUtilizationStats().get((Object)statistic).get((Object)Resource.DISK).floatValue(), (double)this.optimizerResult.clusterStatsByGoalName().get(goalName).potentialNwOutUtilizationStats().get((Object)statistic).floatValue(), this.optimizerResult.clusterStatsByGoalName().get(goalName).numReplicasInCluster(), this.optimizerResult.clusterStatsByGoalName().get(goalName).leaderReplicaStats().get((Object)statistic).intValue(), this.optimizerResult.clusterStatsByGoalName().get(goalName).topicReplicaStats().get((Object)statistic).intValue());
    }

    private EvenClusterLoadPlanBrokerStats convertToPlanBrokerStats(SingleBrokerStats singleBrokerStats) {
        return new EvenClusterLoadPlanBrokerStats(singleBrokerStats.id(), singleBrokerStats.host(), singleBrokerStats.basicStats().diskUtil(), singleBrokerStats.basicStats().diskUtilPct(), singleBrokerStats.basicStats().cpuUtil(), singleBrokerStats.basicStats().leaderBytesInRate(), singleBrokerStats.basicStats().followerBytesInRate(), singleBrokerStats.basicStats().bytesOutRate(), singleBrokerStats.basicStats().potentialBytesOutRate(), singleBrokerStats.basicStats().numLeaders(), singleBrokerStats.basicStats().numReplicas());
    }
}

