/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;

public class DiskCapacityGoal
extends CapacityGoal {
    public DiskCapacityGoal() {
    }

    DiskCapacityGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    protected Resource.CompositeResource resource() {
        return Resource.CompositeResource.ofResource(Resource.DISK);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        return action.balancingAction() == ActionType.LEADERSHIP_MOVEMENT ? ActionAcceptance.ACCEPT : super.replicaActionAcceptance(action, clusterModel);
    }

    @Override
    public String name() {
        return DiskCapacityGoal.class.getSimpleName();
    }
}

