/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurableGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalBalancingActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.model.util.NoopClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public interface Goal
extends CruiseControlConfigurableGoal,
GoalBalancingActionAcceptance {
    default public GoalOptimizationResult optimize(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        return this.optimize(clusterModel, optimizedGoals, optimizationOptions, Optional.empty());
    }

    public GoalOptimizationResult optimize(ClusterModel var1, Set<Goal> var2, OptimizationOptions var3, Optional<OptimizationMetrics> var4) throws OptimizationFailureException;

    default public ActionAcceptance actionAcceptance(BalancingAction action, ClusterModel clusterModel) {
        return action.actionAcceptance(this, clusterModel);
    }

    default public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new NoopClusterModelStatsComparator(this.name());
    }

    public ModelCompletenessRequirements clusterModelCompletenessRequirements();

    public String name();

    public void finish();

    public boolean isHardGoal();

    default public boolean canChangeReplicationFactor() {
        return false;
    }
}

