/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingActionsLog;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ResourceDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.IncrementalResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.internal.AbstractEntity;
import com.linkedin.kafka.cruisecontrol.model.util.BrokerByResourceUtilizationComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IncrementalResourceDistributionGoal
extends ResourceDistributionAbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalResourceDistributionGoal.class);
    private double incrementalStepRatio;
    private double incrementalLowerBound;
    private int minNumValidWindows;
    private Map<Integer, IncrementalResourceDistributionStatsSnapshot> brokersStatsByCellSnapshot;
    private boolean goalHasPersistedMovements;
    private boolean clusterHasOfflineReplicas;

    public IncrementalResourceDistributionGoal() {
    }

    IncrementalResourceDistributionGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    double incrementalStepRatio() {
        return this.incrementalStepRatio;
    }

    double incrementalLowerBound() {
        return this.incrementalLowerBound;
    }

    ResourceUtilizationRatioThresholdsProvider thresholds() {
        return this.thresholds;
    }

    private boolean isSuspended(Replica replica, ActionType actionType, OptimizationOptions optimizationOptions) {
        return !replica.isCurrentOffline() && optimizationOptions.oscillatingTopicPartitionMovements().contains(new TopicPartitionMovement(replica.topicPartition(), actionType));
    }

    @Override
    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, DetailedProposal.DetailedReasonBuilder detailedReasonBuilder, Optional<DetailedProposal.Builder> detailedProposalOptional, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        if (this.isSuspended(replica, action, optimizationOptions)) {
            LOG.trace("Did not apply action {} to Replica {} since it is suspended from movement", (Object)action, (Object)replica);
            this.proposalStatsBuilder.trackProposalSuspended();
            return null;
        }
        return super.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, action, optimizedGoals, optimizationOptions, detailedReasonBuilder, detailedProposalOptional, balancingActionsLogOpt);
    }

    @Override
    public void configure(KafkaCruiseControlConfig kccConfig) {
        super.configure(kccConfig);
        this.incrementalStepRatio = kccConfig.getDouble("incremental.balancing.step.ratio");
        this.incrementalLowerBound = kccConfig.getDouble("incremental.balancing.lower.bound");
        this.minNumValidWindows = kccConfig.getInt("incremental.balancing.min.valid.windows");
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(this.minNumValidWindows, this.minMonitoredPartitionPercentage, false);
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        super.initGoalState(clusterModel, optimizationOptions, optimizationMetricsOpt);
        this.brokersStatsByCellSnapshot = clusterModel.cells().stream().map(cell -> new IncrementalResourceDistributionStatsSnapshot(clusterModel.isCellEnabled(), cell.id(), cell.brokers().stream().collect(Collectors.toMap(Broker::id, broker -> String.format("%.02f%s", broker.load().expectedUtilizationFor(this.resource()), this.resource().unit()))), this.eligibleBrokersBalancingPercentageThreshold((Cell)cell), this.incrementalLowerBound, this.incrementalStepRatio, this.thresholds.clusterThresholds().meanUtilizationRatio(), this.thresholds.meanUtilizationRatio(cell.id()))).collect(Collectors.toMap(IncrementalResourceDistributionStatsSnapshot::cellId, Function.identity()));
        if (optimizationMetricsOpt.isPresent()) {
            OptimizationMetrics metrics = optimizationMetricsOpt.get();
            metrics.recordIncrementalDistributionBalanceStats(this, this.brokersStatsByCellSnapshot.values());
        }
        this.goalHasPersistedMovements = false;
        this.clusterHasOfflineReplicas = !clusterModel.selfHealingEligibleReplicas().isEmpty();
        LOG.info("The incremental balancing stats for the goal {} are {}", (Object)this.name(), this.brokersStatsByCellSnapshot);
    }

    private Map<Integer, Double> eligibleBrokersBalancingPercentageThreshold(Cell cell) {
        return cell.eligibleSourceOrDestinationBrokers().stream().collect(Collectors.toMap(Broker::id, broker -> this.calculateIncrementalBalancingPercentageThreshold((Broker)broker, this.incrementalStepRatio)));
    }

    private double calculateIncrementalBalancingPercentageThreshold(Broker broker, double incrementalStepRatio) {
        double initialResourceUtilizationRatio = Optional.ofNullable(this.initialResourceDistribution.get(broker.id())).map(BrokerResourceStats::utilizationRatio).orElse(1.0);
        if (initialResourceUtilizationRatio < this.thresholds.balanceLowerThreshold(broker)) {
            return Math.abs(this.thresholds.balanceLowerThreshold(broker) - initialResourceUtilizationRatio) * incrementalStepRatio;
        }
        if (initialResourceUtilizationRatio > this.thresholds.balanceUpperThreshold(broker)) {
            return Math.abs(this.thresholds.balanceUpperThreshold(broker) - initialResourceUtilizationRatio) * incrementalStepRatio;
        }
        return 0.0;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Replica replica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        if (replica.isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
        }
        if (this.checkBalanceDeviation(clusterModel, action, AnalyzerUtils::isSmaller) || this.checkBrokersAreStillBelowLowUtilizationAfterAction(clusterModel, action)) {
            return ActionAcceptance.ACCEPT;
        }
        return ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        SortedSet<Broker> brokersToBalance = clusterModel.newBrokers().isEmpty() ? clusterModel.eligibleSourceOrDestinationBrokers() : clusterModel.newBrokers();
        TreeSet<Broker> brokersToBalanceByResourceUtilizationInReverse = new TreeSet<Broker>(BrokerByResourceUtilizationComparator.of(this.resource(), true));
        brokersToBalanceByResourceUtilizationInReverse.addAll(brokersToBalance);
        return brokersToBalanceByResourceUtilizationInReverse;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Replica replica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        if (replica.isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT;
        }
        return this.checkBalanceDeviation(clusterModel, action, AnalyzerUtils::isSmaller);
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
        clusterModel.untrackSortedReplicas(this.sortName());
    }

    @Override
    protected boolean isRebalanceByMovingLoadOutCompleted(Broker broker) {
        return this.isIncrementalBalancingThresholdReached(broker);
    }

    @Override
    protected boolean isRebalanceByMovingLoadInCompleted(Broker broker) {
        return this.isIncrementalBalancingThresholdReached(broker);
    }

    @Override
    protected void doRebalance(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        Optional<Object> balancingActionsLogOpt = this.clusterHasOfflineReplicas ? Optional.empty() : Optional.of(new BalancingActionsLog());
        this.doRebalance(broker, clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
    }

    protected void doRebalance(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        this.performReplicaMovement(broker, clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
        this.performLeadershipMovement(broker, clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
        balancingActionsLogOpt.ifPresent(balancingActionsLog -> {
            if (!this.isIncrementalBalancingThresholdReached(broker)) {
                int revertedActions = balancingActionsLog.revertActions(clusterModel);
                balancingActionsLog.revertAcceptedProposals(this.proposalStatsBuilder, broker.id(), Optional.of(this.name()));
                LOG.info("{} reverted {} balancing actions for broker id={} as sufficient load could not be moved.", new Object[]{this.name(), revertedActions, broker.id()});
            } else {
                this.goalHasPersistedMovements = true;
            }
            if (!this.goalHasPersistedMovements) {
                this.optimizationResultBuilder.removeReplicaChange(this.name());
            }
        });
        this.optimizationResultBuilder.addBrokerResultState(broker.id(), this.brokerResultState(broker));
    }

    private GoalOptimizationResult.BrokerResultState brokerResultState(Broker broker) {
        double currentResourceUtilizationRatio = GoalUtils.utilizationPercentage(broker, this.resource());
        double balanceUpperThreshold = this.thresholds.balanceUpperThreshold(broker);
        double balanceLowerThreshold = this.thresholds.balanceLowerThreshold(broker);
        double lowUtilizationRatio = this.thresholds.lowUtilizationRatio(broker);
        if (!AnalyzerUtils.isLarger(currentResourceUtilizationRatio, lowUtilizationRatio)) {
            return GoalOptimizationResult.BrokerResultState.BALANCED;
        }
        if (!AnalyzerUtils.isLarger(balanceLowerThreshold, currentResourceUtilizationRatio) && !AnalyzerUtils.isLarger(currentResourceUtilizationRatio, balanceUpperThreshold)) {
            return GoalOptimizationResult.BrokerResultState.BALANCED;
        }
        return GoalOptimizationResult.BrokerResultState.BALANCING;
    }

    private boolean checkBrokersAreStillBelowLowUtilizationAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        TopicPartition tp = action.topicPartition();
        ActionType actionType = action.balancingAction();
        if (actionType != ActionType.INTER_BROKER_REPLICA_MOVEMENT && actionType != ActionType.LEADERSHIP_MOVEMENT) {
            throw new UnsupportedOperationException(String.format("Balancing action type %s is not supported by %s", new Object[]{actionType, this.getClass().getSimpleName()}));
        }
        double lowUtilizationThreshold = this.thresholds().lowUtilizationRatio(sourceBroker) * 100.0;
        Load destinationLoadBefore = destinationBroker.load();
        double destinationUtilizationBefore = destinationLoadBefore.expectedUtilizationFor(this.resource());
        if (destinationUtilizationBefore > lowUtilizationThreshold) {
            LOG.trace("For resource {}, destination broker {} is with utilization {}, is above the low utilization threshold so the action is rejected.", new Object[]{this.resource().toString(), destinationBroker, destinationUtilizationBefore});
            return false;
        }
        Load sourceReplicaLoad = sourceBroker.replica(tp).load();
        Load destinationReplicaLoad = Optional.ofNullable(destinationBroker.replica(tp)).map(AbstractEntity::load).orElse(null);
        Load destinationLoadAfter = Load.builder().base(destinationLoadBefore).addLoad(sourceReplicaLoad).subtractLoad(destinationReplicaLoad).build();
        double destinationUtilization = destinationLoadAfter.expectedUtilizationFor(this.resource());
        return destinationUtilization <= lowUtilizationThreshold;
    }

    private boolean isIncrementalBalancingThresholdReached(Broker broker) {
        double initialResourceUtilizationRatio = Optional.ofNullable(this.initialResourceDistribution.get(broker.id())).map(BrokerResourceStats::utilizationRatio).orElse(1.0);
        double currentResourceUtilizationRatio = GoalUtils.utilizationPercentage(broker, this.resource());
        double incrementalBalancingThreshold = this.brokersStatsByCellSnapshot.get(broker.cell().id()).desiredIncrementalImprovementPercent(broker.id());
        double currentBalancingRoundUtilizationDelta = Math.abs(currentResourceUtilizationRatio - initialResourceUtilizationRatio);
        LOG.trace("Broker {}, currentResourceUtilizationDelta: {}, incrementalBalancingThreshold: {}", new Object[]{broker.id(), currentBalancingRoundUtilizationDelta, incrementalBalancingThreshold});
        boolean deltaReached = AnalyzerUtils.isLarger(currentBalancingRoundUtilizationDelta, incrementalBalancingThreshold) || AnalyzerUtils.isEqual(currentBalancingRoundUtilizationDelta, incrementalBalancingThreshold);
        return deltaReached;
    }

    private boolean checkBalanceDeviation(ClusterModel clusterModel, ReplicaBalancingAction action, BiPredicate<Double, Double> comparator) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        TopicPartition tp = action.topicPartition();
        ActionType actionType = action.balancingAction();
        if (actionType != ActionType.INTER_BROKER_REPLICA_MOVEMENT && actionType != ActionType.LEADERSHIP_MOVEMENT) {
            throw new UnsupportedOperationException(String.format("Balancing action type %s is not supported by %s", new Object[]{actionType, this.getClass().getSimpleName()}));
        }
        LOG.trace("Check whether replica balancing action {}, produces a more balanced ClusterModel.", (Object)action);
        Capacity sourceCapacity = sourceBroker.capacity(this.resource());
        Capacity destinationCapacity = destinationBroker.capacity(this.resource());
        Load sourceLoadBefore = sourceBroker.load(this.resource());
        Load destinationLoadBefore = destinationBroker.load(this.resource());
        Load sourceReplicaLoad = sourceBroker.replica(tp).load();
        Load destinationReplicaLoad = Optional.ofNullable(destinationBroker.replica(tp)).map(AbstractEntity::load).orElse(null);
        LOG.trace("Calculate the utilization deviation sum before applying the balancing action...");
        double sourceCellMeanUtilizationRatio = this.thresholds.meanUtilizationRatio(sourceBroker);
        double destinationCellMeanUtilizationRatio = this.thresholds.meanUtilizationRatio(destinationBroker);
        double utilizationDeviationSumBefore = this.calculateUtilizationDeviationSum(sourceCellMeanUtilizationRatio, destinationCellMeanUtilizationRatio, sourceLoadBefore, sourceCapacity, destinationLoadBefore, destinationCapacity);
        Load sourceLoadAfter = Load.builder().base(sourceLoadBefore).subtractLoad(sourceReplicaLoad).addLoad(destinationReplicaLoad).build();
        Load destinationLoadAfter = Load.builder().base(destinationLoadBefore).addLoad(sourceReplicaLoad).subtractLoad(destinationReplicaLoad).build();
        LOG.trace("Calculate the utilization deviation sum after applying the balancing action...");
        double utilizationDeviationSumAfter = this.calculateUtilizationDeviationSum(sourceCellMeanUtilizationRatio, destinationCellMeanUtilizationRatio, sourceLoadAfter, sourceCapacity, destinationLoadAfter, destinationCapacity);
        return comparator.test(utilizationDeviationSumAfter, utilizationDeviationSumBefore);
    }

    private double calculateUtilizationDeviationSum(double sourceCellMeanUtilizationRatio, double destinationCellMeanUtilizationRatio, Load sourceLoad, Capacity sourceCapacity, Load destinationLoad, Capacity destinationCapacity) {
        double sourceUtilization = sourceLoad.expectedUtilizationFor(this.resource());
        double destinationUtilization = destinationLoad.expectedUtilizationFor(this.resource());
        double sourceResourceCapacity = sourceCapacity.totalCapacityFor(this.resource());
        double destinationResourceCapacity = destinationCapacity.totalCapacityFor(this.resource());
        double sourceMeanUtilization = sourceCellMeanUtilizationRatio * sourceResourceCapacity;
        double destinationMeanUtilization = destinationCellMeanUtilizationRatio * destinationResourceCapacity;
        double utilizationDeviationSum = Math.abs(sourceUtilization - sourceMeanUtilization) + Math.abs(destinationUtilization - destinationMeanUtilization);
        LOG.trace("Source util: {}, source capacity: {}, source mean utilization: {}, destination util: {}, destination capacity: {}, destination mean utilization: {}, utilization deviation sum: {}", new Object[]{sourceUtilization, sourceResourceCapacity, sourceMeanUtilization, destinationUtilization, destinationResourceCapacity, destinationMeanUtilization, utilizationDeviationSum});
        return utilizationDeviationSum;
    }

    protected boolean clusterHasOfflineReplicas() {
        return this.clusterHasOfflineReplicas;
    }
}

