/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingActionsLog;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractTopicGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTopicReplicaDistributionGoal
extends AbstractTopicGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalTopicReplicaDistributionGoal.class);
    private final Map<String, Double> averageLeadersPerBrokerForTopic = new HashMap<String, Double>();
    private final Map<String, Double> averageFollowersPerBrokerForTopic = new HashMap<String, Double>();
    private Map<String, Integer> currentTopicLeadersPerRack;
    private Map<String, Integer> expectedTopicLeadersLowerLimitPerRack;
    private Map<String, Integer> expectedTopicLeadersUpperLimitPerRack;
    private List<String> eligibleTopicsForRebalance = new ArrayList<String>();
    Map<String, Integer> brokersPerRack;
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
    private Boolean shouldTrigger = false;
    private int numProposedReassignments = 0;

    public IncrementalTopicReplicaDistributionGoal() {
        this.brokersPerRack = new HashMap<String, Integer>();
        this.currentTopicLeadersPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersLowerLimitPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersUpperLimitPerRack = new HashMap<String, Integer>();
    }

    public IncrementalTopicReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    private boolean isSuspended(Replica replica, ActionType actionType, OptimizationOptions optimizationOptions) {
        return !replica.isCurrentOffline() && optimizationOptions.oscillatingTopicPartitionMovements().contains(new TopicPartitionMovement(replica.topicPartition(), actionType));
    }

    @Override
    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, DetailedProposal.DetailedReasonBuilder detailedReasonBuilder, Optional<DetailedProposal.Builder> detailedProposalOptional, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        if (this.isSuspended(replica, action, optimizationOptions)) {
            LOG.trace("Did not apply action {} to Replica {} since it is suspended from movement", (Object)action, (Object)replica);
            this.proposalStatsBuilder.trackProposalSuspended();
            return null;
        }
        return super.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, action, optimizedGoals, optimizationOptions, detailedReasonBuilder, detailedProposalOptional, balancingActionsLogOpt);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        if (sourceReplica == null) {
            throw new IllegalStateException("Failed to find the replica that's being moved.");
        }
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, sourceReplica, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceReplica, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_SWAP: {
                return ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private boolean isReplicaCountUnderBalanceUpperLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceUpperLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceUpperLimit = broker.isAlive() ? this.leadersPerBrokerForTopicUpperLimit(topic) : 0;
        int n = brokerFollowerBalanceUpperLimit = broker.isAlive() ? this.followersPerBrokerForTopicUpperLimit(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD) {
            if (replica.isLeader()) {
                return numTopicLeaders + 1 <= brokerLeaderBalanceUpperLimit;
            }
            return numTopicFollowers + 1 <= brokerFollowerBalanceUpperLimit;
        }
        return true;
    }

    private boolean isReplicaCountAboveBalanceLowerLimitAfterChange(String topic, Replica replica, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerFollowerBalanceLowerLimit;
        int numTopicLeaders = broker.numLeaderReplicasOfTopicInBroker(topic);
        int numTopicFollowers = broker.numFollowerReplicasOfTopicInBroker(topic);
        int brokerLeaderBalanceLowerLimit = broker.isAlive() ? this.leadersPerBrokerForTopicLowerLimit(topic) : 0;
        int n = brokerFollowerBalanceLowerLimit = broker.isAlive() ? this.followersPerBrokerForTopicLowerLimit(topic) : 0;
        if (changeType == ReplicaDistributionAbstractGoal.ChangeType.REMOVE) {
            if (replica.isLeader()) {
                return numTopicLeaders - 1 >= brokerLeaderBalanceLowerLimit;
            }
            return numTopicFollowers - 1 >= brokerFollowerBalanceLowerLimit;
        }
        return true;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new TopicReplicaDistributionGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return IncrementalTopicReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    private SortedSet<Broker> brokersToBalanceForAllTopics(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceOrDestinationBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        this.initializeShouldTrigger(clusterModel, optimizationOptions);
        this.initializeTopicsToRebalanceInitialScores(clusterModel);
        this.initializeAverageLeaderAndFollowerReplica(clusterModel);
        this.initializeBrokersCountPerRack(clusterModel);
        if (LOG.isDebugEnabled()) {
            this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "PRE-BALANCING");
        }
        this.numProposedReassignments = 0;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String destinationRackId;
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceRackId = sourceBroker.rack().id();
        if (!Objects.equals(sourceRackId, destinationRackId = destinationBroker.rack().id()) && sourceBroker.replica(action.topicPartition()).isLeader()) {
            return this.interRackActionSelfSatisfy(clusterModel, action);
        }
        if (sourceBroker.replica(action.topicPartition()).isLeader()) {
            return this.leaderActionSelfSatisfy(clusterModel, action);
        }
        return this.followerActionSelfSatisfy(clusterModel, action);
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (this.shouldTrigger.booleanValue()) {
            if (LOG.isDebugEnabled()) {
                this.logTopicDistributions(arg_0 -> ((Logger)LOG).debug(arg_0), clusterModel, "POST-BALANCING");
            }
            Set balancedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> this.getTopicImbalanceScore((String)topic, clusterModel) == 0.0).collect(Collectors.toSet());
            Set improvedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> this.getTopicImbalanceScore((String)topic, clusterModel) < this.eligibleTopicsForRebalanceInitialScores.get(topic)).collect(Collectors.toSet());
            Set unimprovedTopics = this.eligibleTopicsForRebalance.stream().filter(topic -> !improvedTopics.contains(topic) && !balancedTopics.contains(topic)).collect(Collectors.toSet());
            LOG.info("The topic distribution goal managed to improve the following topics {} (out of which the following are even considered completely balanced {}), but it couldn't improve {}", new Object[]{improvedTopics, balancedTopics, unimprovedTopics});
            this.optimizationResultBuilder.markSuccessfulOptimization();
            OptimizationOptions options = new OptimizationOptions.Builder().triggeredByGoalViolation(true).build();
            boolean stopsBeingTriggering = !this.initializeShouldTrigger(clusterModel, options);
            LOG.info("Topic distribution goal will stop triggering from the next round: {}", (Object)stopsBeingTriggering);
            boolean hasMoreToRebalance = this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration();
            LOG.info("Topic distribution goal can do {} more reassignments which means it has more work for the next round: {}", (Object)this.numProposedReassignments, (Object)hasMoreToRebalance);
            if (stopsBeingTriggering && hasMoreToRebalance) {
                LOG.info("The topic distribution goal will not be triggering in the next self-healing round, marking the goal as 'in progress'");
                this.optimizationResultBuilder.markInProgressOptimization();
            }
        }
        this.finish();
    }

    private void logTopicDistributions(Consumer<String> logConsumer, ClusterModel clusterModel, String logPrefix) {
        this.eligibleTopicsForRebalance.forEach(topic -> {
            Set brokersToBalanceIds = this.brokersToBalanceForAllTopics(clusterModel).stream().map(Broker::id).collect(Collectors.toSet());
            LinkedHashMap leaderReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> leaderReplicas.put(broker.id(), broker.leaderReplicasOfTopicInBroker((String)topic).size()));
            Set validLeadersCount = leaderReplicas.entrySet().stream().filter(leadersEntry -> brokersToBalanceIds.contains(leadersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxLeaders = (Integer)validLeadersCount.stream().max(Integer::compareTo).get();
            int minLeaders = (Integer)validLeadersCount.stream().min(Integer::compareTo).get();
            LinkedHashMap followerReplicas = new LinkedHashMap();
            clusterModel.aliveBrokers().forEach(broker -> followerReplicas.put(broker.id(), broker.followerReplicasOfTopicInBroker((String)topic).size()));
            Set validFollowersCount = followerReplicas.entrySet().stream().filter(followersEntry -> brokersToBalanceIds.contains(followersEntry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            int maxFollowers = (Integer)validFollowersCount.stream().max(Integer::compareTo).get();
            int minFollowers = (Integer)validFollowersCount.stream().min(Integer::compareTo).get();
            logConsumer.accept(String.format("%s> Distributions for topic '%s': \nLeader difference: %d; \nFollower difference: %d; \nLeader: \n(%s); \nFollower: \n(%s)", logPrefix, topic, maxLeaders - minLeaders, maxFollowers - minFollowers, leaderReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n")), followerReplicas.entrySet().stream().map(e -> String.format("{\"%d\": %d}", e.getKey(), e.getValue())).collect(Collectors.joining(", \n"))));
            if (minLeaders < this.leadersPerBrokerForTopicLowerLimit((String)topic) || maxLeaders > this.leadersPerBrokerForTopicUpperLimit((String)topic) || minFollowers < this.followersPerBrokerForTopicLowerLimit((String)topic) || maxFollowers > this.followersPerBrokerForTopicUpperLimit((String)topic)) {
                logConsumer.accept(String.format("Topic %s is imbalanced, it has leaders count [%d, %d] for leader bounds [%d, %d], and followers count [%d, %d] for follower bounds [%d, %d]", topic, minLeaders, maxLeaders, this.leadersPerBrokerForTopicLowerLimit((String)topic), this.leadersPerBrokerForTopicUpperLimit((String)topic), minFollowers, maxFollowers, this.followersPerBrokerForTopicLowerLimit((String)topic), this.followersPerBrokerForTopicUpperLimit((String)topic)));
            }
        });
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    protected double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
    }

    @Override
    public void rebalanceForTopic(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        LOG.debug("Rebalancing topic {}.", (Object)topic);
        if (!this.shouldTrigger.booleanValue() || this.numProposedReassignments >= this.balancingConstraint.topicBalancingMaxReassignmentsPerIteration()) {
            LOG.debug("Skipping rebalance for topic {} because the goal is not triggering or the maximum number of reassignments is reached.", (Object)topic);
            return;
        }
        double initialTopicImbalanceScore = this.getTopicImbalanceScore(topic, clusterModel);
        int initialNumProposedReassignments = this.numProposedReassignments;
        Optional<BalancingActionsLog> balancingActionsLogOpt = Optional.of(new BalancingActionsLog());
        this.rebalanceRackLeaderReplicaDistribution(clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt, topic);
        this.rebalanceTopicReplicaDistribution(topic, clusterModel, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
        double finalTopicImbalanceScore = this.getTopicImbalanceScore(topic, clusterModel);
        this.revertMovementsIfImbalanceScoreIncreases(balancingActionsLogOpt, clusterModel, initialTopicImbalanceScore, finalTopicImbalanceScore, initialNumProposedReassignments, topic, optimizedGoals, optimizationOptions);
    }

    private void revertMovementsIfImbalanceScoreIncreases(Optional<BalancingActionsLog> balancingActionsLogOpt, ClusterModel clusterModel, double initialTopicImbalanceScore, double finalTopicImbalanceScore, int initialNumProposedReassignments, String topic, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts) {
        balancingActionsLogOpt.ifPresent(balancingActionsLog -> {
            if (finalTopicImbalanceScore > initialTopicImbalanceScore) {
                LOG.warn("Topic {} imbalance score increased from {} to {} after the rebalance.", new Object[]{topic, initialTopicImbalanceScore, finalTopicImbalanceScore});
                balancingActionsLog.revertActions(clusterModel);
                balancingActionsLog.revertAcceptedProposals(this.proposalStatsBuilder, null, Optional.of(this.name()));
                this.numProposedReassignments = initialNumProposedReassignments;
                this.rebalanceTopicReplicaDistribution(topic, clusterModel, optimizedGoals, optimizationOpts, Optional.empty());
            }
            if (this.numProposedReassignments == 0) {
                this.optimizationResultBuilder.removeReplicaChange(this.name());
            }
        });
    }

    private void initializeRackRelatedTopicLeaderDistribution(ClusterModel clusterModel, String topic) {
        this.currentTopicLeadersPerRack.clear();
        this.expectedTopicLeadersLowerLimitPerRack.clear();
        this.expectedTopicLeadersUpperLimitPerRack.clear();
        this.currentTopicLeadersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        int leadersForTopicOnEligibleBrokers = (int)clusterModel.eligibleDestinationBrokers().stream().mapToLong(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
        int eligibleBrokersCount = clusterModel.eligibleDestinationBrokers().size();
        for (Broker broker2 : clusterModel.eligibleDestinationBrokers()) {
            int replicaCount = broker2.numLeaderReplicasOfTopicInBroker(topic);
            this.currentTopicLeadersPerRack.compute(broker2.rack().id(), (k, v) -> v == null ? replicaCount : v + replicaCount);
        }
        for (String rack2 : clusterModel.aliveRackIds()) {
            int numBrokersInRack = this.brokersPerRack.get(rack2);
            double avgLeaderReplicasForRack = (double)(numBrokersInRack * leadersForTopicOnEligibleBrokers) / (double)eligibleBrokersCount;
            this.expectedTopicLeadersLowerLimitPerRack.put(rack2, (int)Math.floor(avgLeaderReplicasForRack));
            this.expectedTopicLeadersUpperLimitPerRack.put(rack2, (int)Math.ceil(avgLeaderReplicasForRack));
        }
        LOG.debug("Leaders per rack for topic {}: {}, expected lower limit per rack: {}, expected upper limit per rack: {}", new Object[]{topic, this.currentTopicLeadersPerRack, this.expectedTopicLeadersLowerLimitPerRack, this.expectedTopicLeadersUpperLimitPerRack});
    }

    private void rebalanceRackLeaderReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        int eligibleBrokersCount = clusterModel.eligibleDestinationBrokers().size();
        if (eligibleBrokersCount == 0) {
            LOG.debug("No eligible brokers to move leaders for topic '{}'", (Object)topic);
            return;
        }
        this.initializeRackRelatedTopicLeaderDistribution(clusterModel, topic);
        List rackIds = clusterModel.aliveRackIds().stream().sorted(Comparator.comparingInt(r -> clusterModel.rack((String)r).numLeaderReplicas()).reversed()).collect(Collectors.toList());
        for (String rack : rackIds) {
            boolean hasLessLeadersForTopic;
            LOG.debug("Rebalancing leader replica distribution for rack {} for topic '{}'", (Object)rack, (Object)topic);
            boolean hasMoreLeadersForTopic = this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && this.expectedTopicLeadersUpperLimitPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
            boolean bl = hasLessLeadersForTopic = this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersLowerLimitPerRack.get(rack);
            if (hasMoreLeadersForTopic) {
                this.rebalanceByMovingRackLeaderReplicasOut(rack, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!hasLessLeadersForTopic) continue;
            this.rebalanceByMovingRackLeaderReplicasIn(rack, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    private void rebalanceByMovingRackLeaderReplicasOut(String rack, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue candidateRacks = clusterModel.aliveRackIds().stream().filter(r -> !r.equals(rack)).filter(r -> this.currentTopicLeadersPerRack.get(r) < this.expectedTopicLeadersUpperLimitPerRack.get(r)).collect(Collectors.toCollection(() -> new PriorityQueue<Object>(Comparator.comparingInt(r -> this.currentTopicLeadersPerRack.get(r) - this.expectedTopicLeadersUpperLimitPerRack.get(r)).thenComparingInt(r -> clusterModel.rack((String)r).numLeaderReplicas()).thenComparingInt(r -> clusterModel.rack((String)r).numReplicas()))));
        while (!candidateRacks.isEmpty()) {
            boolean metRackTopicLeadersUpperBound;
            String destinationRack = (String)candidateRacks.poll();
            boolean hasMovementHappened = this.doInterRackLeaderMovement(clusterModel, topic, rack, destinationRack, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
            if (!hasMovementHappened) continue;
            ++this.numProposedReassignments;
            this.currentTopicLeadersPerRack.put(destinationRack, this.currentTopicLeadersPerRack.get(destinationRack) + 1);
            this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) - 1);
            boolean bl = metRackTopicLeadersUpperBound = this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && Objects.equals(this.expectedTopicLeadersUpperLimitPerRack.get(rack), this.expectedTopicLeadersLowerLimitPerRack.get(rack));
            if (metRackTopicLeadersUpperBound) {
                LOG.debug("Rack {} successfully met the leaders upper bound for topic {} by moving out extra replicas.", (Object)rack, (Object)topic);
                return;
            }
            boolean candidateCanTakeMoreTopicLeaderReplicas = this.currentTopicLeadersPerRack.get(destinationRack) < this.expectedTopicLeadersUpperLimitPerRack.get(destinationRack);
            if (!candidateCanTakeMoreTopicLeaderReplicas) continue;
            candidateRacks.add(destinationRack);
        }
    }

    private void rebalanceByMovingRackLeaderReplicasIn(String rack, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue candidateRacks = clusterModel.aliveRackIds().stream().filter(r -> !r.equals(rack)).filter(r -> this.currentTopicLeadersPerRack.get(r) > this.expectedTopicLeadersLowerLimitPerRack.get(r)).collect(Collectors.toCollection(() -> new PriorityQueue<Object>(Comparator.comparingInt(r -> this.currentTopicLeadersPerRack.get(r) - this.expectedTopicLeadersLowerLimitPerRack.get(r)).reversed())));
        while (!candidateRacks.isEmpty()) {
            boolean metRackTopicLeadersLowerBound;
            String sourceRack = (String)candidateRacks.poll();
            boolean hasMovementHappened = this.doInterRackLeaderMovement(clusterModel, topic, sourceRack, rack, optimizedGoals, optimizationOptions, balancingActionsLogOpt);
            if (!hasMovementHappened) continue;
            ++this.numProposedReassignments;
            this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) + 1);
            this.currentTopicLeadersPerRack.put(sourceRack, this.currentTopicLeadersPerRack.get(sourceRack) - 1);
            boolean bl = metRackTopicLeadersLowerBound = this.currentTopicLeadersPerRack.get(rack) >= this.expectedTopicLeadersLowerLimitPerRack.get(rack);
            if (metRackTopicLeadersLowerBound) {
                LOG.debug("Rack {} successfully met the leaders lower bound for topic {} by moving out extra replicas.", (Object)rack, (Object)topic);
                return;
            }
            boolean requeueSourceRack = this.currentTopicLeadersPerRack.get(sourceRack) > this.expectedTopicLeadersLowerLimitPerRack.get(sourceRack);
            if (!requeueSourceRack) continue;
            candidateRacks.add(sourceRack);
        }
    }

    private boolean doInterRackLeaderMovement(ClusterModel clusterModel, String topic, String sourceRack, String destinationRack, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        List candidateSourceBrokers = clusterModel.eligibleSourceBrokers().stream().filter(b -> b.rack().id().equals(sourceRack)).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > 0).sorted(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).reversed()).collect(Collectors.toList());
        LOG.debug("Doing inter-rack leadership movement for sourceRack {} and destination rack {} and source brokers are: {}", new Object[]{sourceRack, destinationRack, candidateSourceBrokers});
        for (Broker sourceBroker : candidateSourceBrokers) {
            Collection<Replica> replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic);
            for (Replica replica : replicasToMove) {
                boolean movementSuccessful;
                Collection destinationBrokers = clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.rack().id().equals(destinationRack)).collect(Collectors.toList());
                LOG.debug("Trying moving replica {} from  source broker {} to destination brokers {}", new Object[]{replica, sourceBroker, destinationBrokers});
                Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.LEADERSHIP_MOVEMENT, ActionType.INTER_BROKER_REPLICA_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                boolean bl = movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully did inter-rack leadership movement for leader replica {} from rack {} to rack {} with source broker {} and destination broker {}", new Object[]{replica, sourceRack, destinationRack, sourceBroker, newHostBroker});
                return true;
            }
        }
        return false;
    }

    private void rebalanceTopicReplicaDistribution(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        this.rebalanceLeaderReplicaDistribution(clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt, topic);
        this.rebalanceFollowerReplicaDistribution(clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt, topic);
    }

    private void rebalanceFollowerReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        SortedSet<Broker> brokersToBalance = this.brokersToBalanceForAllTopics(clusterModel);
        for (Broker broker : brokersToBalance) {
            boolean requireMoreFollowers;
            LOG.debug("Rebalancing follower replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
            Collection<Replica> replicas = broker.followerReplicasOfTopicInBroker(topic);
            int numFollowerReplicas = replicas.size();
            boolean hasMoreFollowersForTopic = numFollowerReplicas > this.followersPerBrokerForTopicUpperLimit(topic) || numFollowerReplicas == this.followersPerBrokerForTopicUpperLimit(topic) && this.followersPerBrokerForTopicUpperLimit(topic) > this.followersPerBrokerForTopicLowerLimit(topic);
            boolean hasLessFollowersForTopic = numFollowerReplicas < this.followersPerBrokerForTopicLowerLimit(topic);
            boolean requireLessFollowers = broker.isEligibleSource() && hasMoreFollowersForTopic;
            boolean bl = requireMoreFollowers = broker.isEligibleDestination() && hasLessFollowersForTopic;
            if (requireLessFollowers) {
                this.rebalanceByMovingFollowerReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!requireMoreFollowers) continue;
            this.rebalanceByMovingFollowerReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    private void rebalanceLeaderReplicaDistribution(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOpts, Optional<BalancingActionsLog> balancingActionsLogOpt, String topic) {
        SortedSet<Broker> brokersToBalance = this.brokersToBalanceForAllTopics(clusterModel);
        for (Broker broker : brokersToBalance) {
            boolean requireMoreLeaders;
            LOG.debug("Rebalancing leader replica distribution for broker {} for topic '{}'", (Object)broker, (Object)topic);
            Collection<Replica> topicLeaderReplicas = broker.leaderReplicasOfTopicInBroker(topic);
            boolean hasMoreLeadersForTopic = topicLeaderReplicas.size() > this.leadersPerBrokerForTopicUpperLimit(topic) || topicLeaderReplicas.size() == this.leadersPerBrokerForTopicUpperLimit(topic) && this.leadersPerBrokerForTopicUpperLimit(topic) > this.leadersPerBrokerForTopicLowerLimit(topic);
            boolean hasLessLeadersForTopic = topicLeaderReplicas.size() < this.leadersPerBrokerForTopicLowerLimit(topic);
            boolean requireLessLeaders = broker.isEligibleSource() && hasMoreLeadersForTopic;
            boolean bl = requireMoreLeaders = broker.isEligibleDestination() && hasLessLeadersForTopic;
            if (requireLessLeaders) {
                this.rebalanceByMovingLeaderReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
            }
            if (!requireMoreLeaders) continue;
            this.rebalanceByMovingLeaderReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOpts, balancingActionsLogOpt);
        }
    }

    void rebalanceByMovingFollowerReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int followerReplicasOfTopicInBrokerCount = followerReplicasOfTopicInBroker.size();
        for (Replica replica : followerReplicasOfTopicInBroker) {
            boolean metTopicUpperBound;
            LOG.debug("Trying to move follower replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, destinationBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
            boolean movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved follower replica out {} from broker {} to broker {}", new Object[]{replica, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl = metTopicUpperBound = --followerReplicasOfTopicInBrokerCount < this.followersPerBrokerForTopicUpperLimit(topic) || followerReplicasOfTopicInBrokerCount == this.followersPerBrokerForTopicUpperLimit(topic) && this.followersPerBrokerForTopicUpperLimit(topic) == this.followersPerBrokerForTopicLowerLimit(topic);
            if (metTopicUpperBound) {
                LOG.debug("Broker {} successfully met the followers upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicReplicas = newHostBroker.numFollowerReplicasOfTopicInBroker(topic) < this.followersPerBrokerForTopicUpperLimit(topic);
            if (!candidateCanTakeMoreTopicReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingFollowerReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numFollowerReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.numFollowerReplicasOfTopicInBroker(topic) > this.followersPerBrokerForTopicLowerLimit(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        Collection<Replica> followerReplicasOfTopicInBroker = broker.followerReplicasOfTopicInBroker(topic);
        int numFollowerReplicasOfTopicInBroker = followerReplicasOfTopicInBroker.size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> sourceBrokerReplicasForTopic = sourceBroker.followerReplicasOfTopicInBroker(topic);
            for (Replica replica : sourceBrokerReplicasForTopic) {
                boolean metTopicLowerBound;
                LOG.debug("Trying to move follower replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                boolean movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved follower replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl = metTopicLowerBound = ++numFollowerReplicasOfTopicInBroker >= this.followersPerBrokerForTopicLowerLimit(topic);
                if (metTopicLowerBound) {
                    LOG.debug("Broker {} successfully met the followers lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) <= this.followersPerBrokerForTopicLowerLimit(topic)) continue block0;
                boolean sourceShouldBeReplaced = !sourceBrokers.isEmpty() && sourceBroker.numFollowerReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numFollowerReplicasOfTopicInBroker(topic);
                if (!sourceShouldBeReplaced) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    void rebalanceByMovingLeaderReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        TreeSet<Broker> destinationBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id));
        clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.rack() == broker.rack()).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit(topic)).collect(Collectors.toCollection(() -> destinationBrokers));
        Collection<Replica> replicasToMove = broker.leaderReplicasOfTopicInBroker(topic);
        int numLeaderReplicasInBroker = replicasToMove.size();
        for (Replica replica : replicasToMove) {
            boolean metTopicLeadersUpperBound;
            boolean movementSuccessful;
            LOG.debug("Trying to move leader replica out {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, broker, destinationBrokers});
            Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, destinationBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
            boolean bl = movementSuccessful = newHostBroker != null;
            if (!movementSuccessful) continue;
            LOG.debug("Successfully moved leader replica out {} for topic {} from broker {} to broker {}", new Object[]{replica, topic, broker, newHostBroker});
            ++this.numProposedReassignments;
            boolean bl2 = metTopicLeadersUpperBound = --numLeaderReplicasInBroker < this.leadersPerBrokerForTopicUpperLimit(topic) || numLeaderReplicasInBroker == this.leadersPerBrokerForTopicUpperLimit(topic) && this.leadersPerBrokerForTopicUpperLimit(topic) == this.leadersPerBrokerForTopicLowerLimit(topic);
            if (metTopicLeadersUpperBound) {
                LOG.debug("Broker {} successfully met the leaders upper bound for topic {} by moving out extra replicas.", (Object)broker, (Object)topic);
                return;
            }
            destinationBrokers.removeIf(b -> b.equals(newHostBroker));
            boolean candidateCanTakeMoreTopicLeaderReplicas = newHostBroker.numLeaderReplicasOfTopicInBroker(topic) < this.leadersPerBrokerForTopicUpperLimit(topic);
            if (!candidateCanTakeMoreTopicLeaderReplicas) continue;
            destinationBrokers.add(newHostBroker);
        }
    }

    void rebalanceByMovingLeaderReplicasIn(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, Optional<BalancingActionsLog> balancingActionsLogOpt) {
        PriorityQueue<Broker> sourceBrokers = new PriorityQueue<Broker>(Comparator.comparingInt(b -> b.numLeaderReplicasOfTopicInBroker(topic)).thenComparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::numLeaderReplicas).thenComparingInt(Broker::numReplicas).thenComparingInt(Broker::id).reversed());
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.rack() == broker.rack()).filter(b -> b.numLeaderReplicasOfTopicInBroker(topic) > this.leadersPerBrokerForTopicLowerLimit(topic)).collect(Collectors.toCollection(() -> sourceBrokers));
        int numLeaderReplicasOfTopicInBroker = broker.numLeaderReplicasOfTopicInBroker(topic);
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        block0: while (!sourceBrokers.isEmpty()) {
            Broker sourceBroker = sourceBrokers.poll();
            Collection<Replica> replicasToMove = sourceBroker.leaderReplicasOfTopicInBroker(topic);
            for (Replica replica : replicasToMove) {
                boolean metTopicLeaderLowerBound;
                boolean movementSuccessful;
                LOG.debug("Trying to move leader replica in {} for topic '{}' from broker {} to one of brokers {}", new Object[]{replica, topic, sourceBroker, candidateBrokers});
                Broker newHostBroker = this.maybeApplyBalancingActions(clusterModel, replica, candidateBrokers, Arrays.asList(ActionType.INTER_BROKER_REPLICA_MOVEMENT, ActionType.LEADERSHIP_MOVEMENT), optimizedGoals, optimizationOptions, Optional.empty(), balancingActionsLogOpt);
                boolean bl = movementSuccessful = newHostBroker != null;
                if (!movementSuccessful) continue;
                LOG.debug("Successfully moved leader replica in {} from broker {} to broker {}", new Object[]{replica, sourceBroker, newHostBroker});
                ++this.numProposedReassignments;
                boolean bl2 = metTopicLeaderLowerBound = ++numLeaderReplicasOfTopicInBroker >= this.leadersPerBrokerForTopicLowerLimit(topic);
                if (metTopicLeaderLowerBound) {
                    LOG.debug("Broker {} successfully met the leaders lower bound for topic {} by accepting additional replicas.", (Object)broker, (Object)topic);
                    return;
                }
                if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) <= this.leadersPerBrokerForTopicLowerLimit(topic)) continue block0;
                boolean requeueSourceBroker = !sourceBrokers.isEmpty() && sourceBroker.numLeaderReplicasOfTopicInBroker(topic) < sourceBrokers.peek().numLeaderReplicasOfTopicInBroker(topic);
                if (!requeueSourceBroker) continue;
                sourceBrokers.add(sourceBroker);
                continue block0;
            }
        }
    }

    private void initializeTopicsToRebalanceInitialScores(ClusterModel clusterModel) {
        this.eligibleTopicsForRebalanceInitialScores = this.eligibleTopicsForRebalance.stream().distinct().collect(Collectors.toMap(topic -> topic, topic -> this.getTopicImbalanceScore((String)topic, clusterModel)));
    }

    private void initializeBrokersCountPerRack(ClusterModel clusterModel) {
        this.brokersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        clusterModel.eligibleDestinationBrokers().forEach(broker -> this.brokersPerRack.compute(broker.rack().id(), (k, v) -> v + 1));
    }

    private void initializeAverageLeaderAndFollowerReplica(ClusterModel clusterModel) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers().size();
        for (String topic : this.eligibleTopicsForRebalance) {
            int allLeadersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
            double avgLeaderReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allLeadersForTopic / (double)numEligibleDestinationBrokers : 0.0;
            this.averageLeadersPerBrokerForTopic.put(topic, avgLeaderReplicasPerBrokerForTopic);
            int allFollowersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.followerReplicasOfTopicInBroker(topic).size()).sum();
            double avgFollowerReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allFollowersForTopic / (double)numEligibleDestinationBrokers : 0.0;
            this.averageFollowersPerBrokerForTopic.put(topic, avgFollowerReplicasPerBrokerForTopic);
        }
        LOG.debug("Average Leader replicas per broker for topics: {}", this.averageLeadersPerBrokerForTopic);
        LOG.debug("Average Follower replicas per broker for topics: {}", this.averageFollowersPerBrokerForTopic);
    }

    boolean initializeShouldTrigger(ClusterModel clusterModel, OptimizationOptions options) {
        boolean manyTopicsImbalanced;
        boolean anyTopicBadlyImbalanced;
        this.eligibleTopicsForRebalance = this.topicsToRebalance(clusterModel, options.excludedTopics());
        if (this.eligibleTopicsForRebalance.isEmpty()) {
            LOG.warn("No topics to rebalance for {} so it won't trigger", (Object)this.name());
            this.shouldTrigger = false;
            return false;
        }
        Double maxTopicImbalancedScore = this.getTopicImbalanceScore(this.eligibleTopicsForRebalance.get(0), clusterModel);
        boolean bl = anyTopicBadlyImbalanced = maxTopicImbalancedScore > this.balancingConstraint.topicBalancingBadlyImbalancedTopicImbalanceScoreThreshold();
        if (anyTopicBadlyImbalanced) {
            LOG.info("{} will trigger, one of the topics is badly imbalanced with a replica distribution based imbalance score: {}", (Object)this.name(), (Object)maxTopicImbalancedScore);
        }
        int numTotalTopics = clusterModel.topics().size();
        double slightlyImbalancedTopicsNum = Math.round((double)numTotalTopics * this.balancingConstraint.topicBalancingSlightlyImbalancedTopicsPercentageGoalTrigger());
        boolean bl2 = manyTopicsImbalanced = (double)this.eligibleTopicsForRebalance.size() > slightlyImbalancedTopicsNum && this.getTopicImbalanceScore(this.eligibleTopicsForRebalance.get((int)slightlyImbalancedTopicsNum), clusterModel) > this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold();
        if (manyTopicsImbalanced) {
            LOG.info("{} will trigger, more than {} topics have an imbalance score greater than: {}", new Object[]{this.name(), slightlyImbalancedTopicsNum, this.balancingConstraint.topicBalancingSlightlyImbalancedTopicImbalanceScoreThreshold()});
        }
        this.shouldTrigger = anyTopicBadlyImbalanced || manyTopicsImbalanced;
        LOG.info("{}'s trigger check is invoked by a goal violation detection: {}", (Object)this.name(), (Object)options.isTriggeredByGoalViolation());
        this.shouldTrigger = this.shouldTrigger != false || !options.isTriggeredByGoalViolation();
        return this.shouldTrigger;
    }

    private boolean interRackActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String sourceRackId = clusterModel.broker(action.sourceBrokerId()).rack().id();
        String destinationRackId = clusterModel.broker(action.destinationBrokerId()).rack().id();
        if (Objects.equals(this.currentTopicLeadersPerRack.get(sourceRackId), this.expectedTopicLeadersUpperLimitPerRack.get(sourceRackId)) && Objects.equals(this.currentTopicLeadersPerRack.get(destinationRackId), this.expectedTopicLeadersLowerLimitPerRack.get(destinationRackId))) {
            return clusterModel.rack(sourceRackId).numLeaderReplicas() - 2 >= clusterModel.rack(destinationRackId).numLeaderReplicas();
        }
        return true;
    }

    private boolean leaderActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String topic = action.topic();
        if (sourceBroker.numLeaderReplicasOfTopicInBroker(topic) == this.leadersPerBrokerForTopicUpperLimit(topic) && destinationBroker.numLeaderReplicasOfTopicInBroker(topic) == this.leadersPerBrokerForTopicLowerLimit(topic)) {
            return sourceBroker.numLeaderReplicas() - 2 >= destinationBroker.numLeaderReplicas();
        }
        return this.checkLeadershipImbalanceScore(clusterModel, action);
    }

    private boolean followerActionSelfSatisfy(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String topic = action.topic();
        if (sourceBroker.numFollowerReplicasOfTopicInBroker(topic) == this.followersPerBrokerForTopicUpperLimit(topic) && destinationBroker.numFollowerReplicasOfTopicInBroker(topic) == this.followersPerBrokerForTopicLowerLimit(topic)) {
            return sourceBroker.numReplicas() - 2 >= destinationBroker.numReplicas();
        }
        return this.checkTopicReplicaDistributionBasedImbalanceScore(clusterModel, action);
    }

    private boolean checkLeadershipImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        List<Integer> leadershipDistributionBefore = clusterModel.replicaDistributionForTopic(topic, true);
        Double leadershipImbalanceScoreBefore = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionBefore);
        List<Integer> leadershipDistributionAfter = this.replicaDistributionAfterAction(clusterModel, action, true);
        Double leadershipImbalanceScoreAfter = clusterModel.replicaDistributionImbalanceScore(leadershipDistributionAfter);
        return leadershipImbalanceScoreBefore > leadershipImbalanceScoreAfter;
    }

    private boolean checkTopicReplicaDistributionBasedImbalanceScore(ClusterModel clusterModel, ReplicaBalancingAction action) {
        String topic = action.topic();
        Double topicImbalanceScoreBefore = this.getTopicImbalanceScore(topic, clusterModel);
        List<Integer> leadershipDistributionAfter = clusterModel.replicaDistributionForTopic(topic, true);
        List<Integer> followerDistributionAfter = this.replicaDistributionAfterAction(clusterModel, action, false);
        Double topicImbalanceScoreAfter = clusterModel.calculateTopicReplicaDistributionBasedImbalanceScore(leadershipDistributionAfter, followerDistributionAfter);
        return topicImbalanceScoreBefore > topicImbalanceScoreAfter;
    }

    private List<Integer> replicaDistributionAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action, Boolean isLeader) {
        String topic = action.topic();
        int limitNumberOfBrokers = isLeader != false ? clusterModel.numLeaderReplicasForTopicOnEligibleDestinationBrokers(topic) : clusterModel.numFollowerReplicasForTopicOnEligibleDestinationBrokers(topic);
        return clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> {
            int numOfReplica;
            int n = numOfReplica = isLeader != false ? broker.numLeaderReplicasOfTopicInBroker(topic) : broker.numFollowerReplicasOfTopicInBroker(topic);
            if (broker.id() == action.sourceBrokerId().intValue()) {
                return numOfReplica - 1;
            }
            if (broker.id() == action.destinationBrokerId().intValue()) {
                return numOfReplica + 1;
            }
            return numOfReplica;
        }).boxed().sorted(Comparator.reverseOrder()).limit(limitNumberOfBrokers).collect(Collectors.toList());
    }

    int leadersPerBrokerForTopicUpperLimit(String topic) {
        return (int)Math.ceil(this.averageLeadersPerBrokerForTopic.getOrDefault(topic, (Double)Double.MAX_VALUE));
    }

    int leadersPerBrokerForTopicLowerLimit(String topic) {
        return (int)Math.floor(this.averageLeadersPerBrokerForTopic.getOrDefault(topic, 0.0));
    }

    int followersPerBrokerForTopicUpperLimit(String topic) {
        return (int)Math.ceil(this.averageFollowersPerBrokerForTopic.getOrDefault(topic, (Double)Double.MAX_VALUE));
    }

    int followersPerBrokerForTopicLowerLimit(String topic) {
        return (int)Math.floor(this.averageFollowersPerBrokerForTopic.getOrDefault(topic, 0.0));
    }

    private class TopicReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private TopicReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double postLeaderStdDev = stats1.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double preLeaderStdDev = stats2.topicLeaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int leaderResult = AnalyzerUtils.compare(preLeaderStdDev, postLeaderStdDev, 1.0E-5);
            if (leaderResult < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Leader Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postLeaderStdDev, preLeaderStdDev);
                return leaderResult;
            }
            if (leaderResult == 0) {
                double postFollowerStdDev = stats1.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                double preFollowerStdDev = stats2.topicFollowerReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
                int followerResult = AnalyzerUtils.compare(preFollowerStdDev, postFollowerStdDev, 1.0E-5);
                if (followerResult < 0) {
                    this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Follower Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", IncrementalTopicReplicaDistributionGoal.this.name(), postFollowerStdDev, preFollowerStdDev);
                    return followerResult;
                }
            }
            return leaderResult;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

