/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ReplicaDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderReplicaDistributionGoal
extends ReplicaDistributionAbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderReplicaDistributionGoal.class);

    public LeaderReplicaDistributionGoal() {
    }

    @Override
    ReplicaDistributionStatsSnapshot.ReplicaResource resource() {
        return ReplicaDistributionStatsSnapshot.ReplicaResource.LEADER;
    }

    public LeaderReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    @Override
    int numInterestedReplicas(ClusterModel clusterModel) {
        return clusterModel.numLeaderReplicasOnEligibleSourceBrokers();
    }

    @Override
    int numInterestedReplicas(Broker broker) {
        return broker.leaderReplicas().size();
    }

    @Override
    double balancePercentage() {
        return this.balancingConstraint.leaderReplicaBalancePercentage();
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                if (sourceReplica.isLeader() && !destinationReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
                }
                if (!sourceReplica.isLeader() && destinationReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(destinationBroker, sourceBroker);
                }
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: {
                if (sourceReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
                }
                return ActionAcceptance.ACCEPT;
            }
            case LEADERSHIP_MOVEMENT: {
                return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private ActionAcceptance isLeaderMovementSatisfiable(Broker sourceBroker, Broker destinationBroker) {
        return this.isReplicaCountUnderBalanceUpperLimitAfterChange(destinationBroker, destinationBroker.leaderReplicas().size(), ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceBroker, sourceBroker.leaderReplicas().size(), ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new LeaderReplicaDistributionGoalStatsComparator();
    }

    @Override
    public String name() {
        return LeaderReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        boolean requireLessReplicas;
        LOG.debug("Rebalancing broker {} [limits] lower: {} upper: {}.", new Object[]{broker.id(), this.replicaThresholds.numReplicasLowerLimit, this.replicaThresholds.numReplicasUpperLimit});
        int numLeaderReplicas = broker.leaderReplicas().size();
        boolean requireLessLeaderReplicas = broker.isAlive() && numLeaderReplicas > this.replicaThresholds.numReplicasUpperLimit;
        boolean requireMoreLeaderReplicas = broker.isAlive() && numLeaderReplicas < this.replicaThresholds.numReplicasLowerLimit;
        boolean bl = requireLessReplicas = this.fixOfflineReplicasOnly && broker.currentOfflineReplicas().size() > 0;
        if ((requireLessLeaderReplicas && this.rebalanceByMovingLeadershipOut(broker, clusterModel, optimizedGoals, optimizationOptions) || requireLessReplicas) && this.rebalanceByMovingReplicasOut(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            if (!requireLessReplicas) {
                this.brokerIdsAboveBalanceUpperLimit.add(broker.id());
                LOG.debug("Failed to sufficiently decrease leader replica count in broker {}. Leader replicas: {}.", (Object)broker.id(), (Object)broker.leaderReplicas().size());
            }
        } else if (requireMoreLeaderReplicas && this.rebalanceByMovingLeadershipIn(broker, clusterModel, optimizedGoals, optimizationOptions) && this.rebalanceByMovingLeaderReplicasIn(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            this.brokerIdsUnderBalanceLowerLimit.add(broker.id());
            LOG.debug("Failed to sufficiently increase leader replica count in broker {}. Leader replicas: {}.", (Object)broker.id(), (Object)broker.leaderReplicas().size());
        }
    }

    boolean rebalanceByMovingLeadershipOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (!clusterModel.deadBrokers().isEmpty()) {
            return true;
        }
        int numLeaderReplicas = broker.leaderReplicas().size();
        for (Replica replica : new HashSet<Replica>(broker.leaderReplicas())) {
            Set<Broker> candidateBrokers;
            Broker b2;
            if (LeaderReplicaDistributionGoal.shouldExclude(replica, optimizationOptions.excludedTopics()) || (b2 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers = clusterModel.partition(replica.topicPartition()).partitionBrokers().stream().filter(b -> b.isEligibleDestination() && b != broker && !b.replica(replica.topicPartition()).isCurrentOffline()).collect(Collectors.toSet()), ActionType.LEADERSHIP_MOVEMENT, optimizedGoals, optimizationOptions)) == null || --numLeaderReplicas > this.replicaThresholds.numReplicasUpperLimit) continue;
            return false;
        }
        return true;
    }

    boolean rebalanceByMovingLeadershipIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (!clusterModel.deadBrokers().isEmpty() || optimizationOptions.excludedBrokersForLeadership().contains(broker.id())) {
            return true;
        }
        int numLeaderReplicas = broker.leaderReplicas().size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        for (Replica replica : broker.replicas()) {
            Broker b;
            if (replica.isLeader() || replica.isCurrentOffline() || LeaderReplicaDistributionGoal.shouldExclude(replica, optimizationOptions.excludedTopics()) || !clusterModel.partition(replica.topicPartition()).leader().broker().isEligibleSource() || (b = this.maybeApplyBalancingAction(clusterModel, clusterModel.partition(replica.topicPartition()).leader(), candidateBrokers, ActionType.LEADERSHIP_MOVEMENT, optimizedGoals, optimizationOptions)) == null || ++numLeaderReplicas < this.replicaThresholds.numReplicasLowerLimit) continue;
            return false;
        }
        return true;
    }

    boolean rebalanceByMovingReplicasOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        TreeSet<Broker> candidateBrokers;
        if (this.fixOfflineReplicasOnly) {
            candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.replicas().size()).thenComparingInt(Broker::id));
            candidateBrokers.addAll(clusterModel.eligibleDestinationBrokers());
        } else {
            candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.leaderReplicas().size()).thenComparingInt(Broker::id));
            candidateBrokers.addAll(clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.leaderReplicas().size() < this.replicaThresholds.numReplicasUpperLimit).collect(Collectors.toSet()));
        }
        int balanceUpperLimit = this.fixOfflineReplicasOnly ? 0 : this.replicaThresholds.numReplicasUpperLimit;
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        HashSet<Replica> candidateReplicas = new HashSet<Replica>(this.fixOfflineReplicasOnly ? broker.currentOfflineReplicas() : broker.leaderReplicas());
        if (!this.fixOfflineReplicasOnly && !clusterModel.selfHealingEligibleReplicas().isEmpty()) {
            candidateReplicas.retainAll(broker.immigrantReplicas());
        }
        int numReplicas = candidateReplicas.size();
        for (Replica replica : candidateReplicas) {
            Broker b2;
            if (LeaderReplicaDistributionGoal.shouldExclude(replica, excludedTopics) || (b2 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions)) == null) continue;
            if (--numReplicas <= balanceUpperLimit) {
                return false;
            }
            candidateBrokers.remove(b2);
            if (b2.leaderReplicas().size() >= this.replicaThresholds.numReplicasUpperLimit && !this.fixOfflineReplicasOnly) continue;
            candidateBrokers.add(b2);
        }
        return true;
    }

    boolean rebalanceByMovingLeaderReplicasIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (optimizationOptions.excludedBrokersForLeadership().contains(broker.id())) {
            return true;
        }
        PriorityQueue<Broker> eligibleBrokers = new PriorityQueue<Broker>((b1, b2) -> {
            int result = Integer.compare(b2.leaderReplicas().size(), b1.leaderReplicas().size());
            return result == 0 ? Integer.compare(b1.id(), b2.id()) : result;
        });
        clusterModel.eligibleSourceBrokers().stream().filter(b -> b.leaderReplicas().size() > this.replicaThresholds.numReplicasLowerLimit).forEach(eligibleBrokers::add);
        List<Broker> candidateBrokers = Collections.singletonList(broker);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        int numLeaderReplicas = broker.leaderReplicas().size();
        block0: while (!eligibleBrokers.isEmpty()) {
            Broker sourceBroker = (Broker)eligibleBrokers.poll();
            for (Replica replica : new HashSet<Replica>(sourceBroker.leaderReplicas())) {
                Broker b3;
                if (LeaderReplicaDistributionGoal.shouldExclude(replica, excludedTopics) || broker.hasReplicaOfPartition(replica.topicPartition()) || !clusterModel.brokenBrokers().isEmpty() && !replica.isImmigrant() || (b3 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions)) == null) continue;
                if (++numLeaderReplicas >= this.replicaThresholds.numReplicasLowerLimit) {
                    return false;
                }
                if (eligibleBrokers.isEmpty() || sourceBroker.leaderReplicas().size() >= ((Broker)eligibleBrokers.peek()).leaderReplicas().size()) continue;
                eligibleBrokers.add(sourceBroker);
                continue block0;
            }
        }
        return true;
    }

    private class LeaderReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private LeaderReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double stDev1 = stats1.leaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double stDev2 = stats2.leaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int result = AnalyzerUtils.compare(stDev2, stDev1, 1.0E-5);
            if (result < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Leader Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", LeaderReplicaDistributionGoal.this.name(), stDev1, stDev2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

