/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractBrokerGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityCombinator;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.RebalanceStep;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelHelper;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaRelocationContext;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import io.confluent.databalancer.DatabalancerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaCapacityGoal
extends AbstractBrokerGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaCapacityGoal.class);
    private boolean isSelfHealingMode;
    private final Random rand;

    public ReplicaCapacityGoal() {
        this(new Random());
    }

    public ReplicaCapacityGoal(Random rand) {
        this.isSelfHealingMode = false;
        this.rand = rand;
    }

    public ReplicaCapacityGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
        this.isSelfHealingMode = false;
        this.rand = new Random();
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_MOVEMENT: {
                Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
                return (long)destinationBroker.replicas().size() < this.balancingConstraint.maxReplicasPerBroker() ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case INTER_BROKER_REPLICA_SWAP: 
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        for (Broker destinationBroker : action.replicaMoves().values()) {
            if ((long)destinationBroker.replicas().size() < this.balancingConstraint.maxReplicasPerBroker()) continue;
            return ActionAcceptance.BROKER_REJECT;
        }
        return ActionAcceptance.ACCEPT;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return ReplicaCapacityGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.allBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        ArrayList<String> topicsToRebalance = new ArrayList<String>(clusterModel.topics());
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        topicsToRebalance.removeAll(excludedTopics);
        if (topicsToRebalance.isEmpty()) {
            LOG.warn("All topics are excluded from {}.", (Object)this.name());
        }
        long maxReplicasPerBroker = this.balancingConstraint.maxReplicasPerBroker();
        int totalReplicasInCluster = 0;
        int totalEligibleReplicasInCluster = 0;
        for (Broker broker : this.brokersToBalance(clusterModel)) {
            totalReplicasInCluster += broker.replicas().size();
            if (broker.isEligible()) {
                totalEligibleReplicasInCluster += broker.replicas().size();
            }
            if (!broker.isEligible() && (long)broker.replicas().size() > maxReplicasPerBroker) {
                throw new OptimizationFailureException(String.format("[%s] Ignored broker: %d exceeds the maximum allowed number of replicas per broker: %d.", this.name(), broker.id(), maxReplicasPerBroker));
            }
            if (!broker.isAlive()) {
                this.isSelfHealingMode = true;
                continue;
            }
            HashSet<Replica> excludedReplicasInBroker = new HashSet<Replica>();
            for (String topic : excludedTopics) {
                excludedReplicasInBroker.addAll(broker.replicasOfTopicInBroker(topic));
            }
            if (broker.strategy() == Broker.Strategy.BAD_DISKS) {
                this.isSelfHealingMode = true;
                excludedReplicasInBroker.removeAll(broker.currentOfflineReplicas());
            }
            if ((long)excludedReplicasInBroker.size() <= maxReplicasPerBroker) continue;
            throw new OptimizationFailureException(String.format("[%s] Replicas of excluded topics in broker: %d exceeds the maximum allowed number of replicas per broker: %d.", this.name(), excludedReplicasInBroker.size(), maxReplicasPerBroker));
        }
        long maxReplicasInCluster = maxReplicasPerBroker * (long)clusterModel.aliveBrokers().size();
        if ((long)totalReplicasInCluster > maxReplicasInCluster) {
            throw new OptimizationFailureException(String.format("[%s] Total replicas in cluster: %d exceeds the maximum allowed replicas in cluster: %d (Alive brokers: %d, Allowed number of replicas per broker: %d).", this.name(), totalReplicasInCluster, maxReplicasInCluster, clusterModel.aliveBrokers().size(), maxReplicasPerBroker));
        }
        long maxEligibleReplicasInCluster = maxReplicasPerBroker * (long)clusterModel.eligibleDestinationBrokers().size();
        if ((long)totalEligibleReplicasInCluster > maxEligibleReplicasInCluster) {
            throw new OptimizationFailureException(String.format("[%s] Total eligible replicas in cluster: %d exceeds the maximum allowed replicas in cluster: %d (Eligible destination brokers: %d, Allowed number of replicas per broker: %d).", this.name(), totalEligibleReplicasInCluster, maxEligibleReplicasInCluster, clusterModel.eligibleDestinationBrokers().size(), maxReplicasPerBroker));
        }
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        return (long)destinationBroker.replicas().size() < this.balancingConstraint.maxReplicasPerBroker();
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return true;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        if (!this.isSelfHealingMode) {
            this.ensureReplicaCapacitySatisfied(clusterModel);
            this.finish();
        } else {
            this.isSelfHealingMode = false;
        }
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    private void ensureReplicaCapacitySatisfied(ClusterModel clusterModel) throws OptimizationFailureException {
        for (Broker broker : this.brokersToBalance(clusterModel)) {
            int numBrokerReplicas = broker.replicas().size();
            if ((long)numBrokerReplicas <= this.balancingConstraint.maxReplicasPerBroker()) continue;
            throw new OptimizationFailureException(String.format("[%s] Broker %d has %d replicas, which exceeds the maximum allowed number of replicas per broker, %d.", this.name(), broker.id(), numBrokerReplicas, this.balancingConstraint.maxReplicasPerBroker()));
        }
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        if (!broker.isEligible()) {
            return;
        }
        LOG.debug("balancing broker {}, optimized goals = {}", (Object)broker, optimizedGoals);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        for (Replica replica : new TreeSet<Replica>(broker.replicas())) {
            boolean isReplicaOffline = replica.isCurrentOffline();
            if ((long)broker.replicas().size() <= this.balancingConstraint.maxReplicasPerBroker() && !isReplicaOffline) break;
            RebalanceContext context = new RebalanceContext(clusterModel, replica, excludedTopics, optimizedGoals, optimizationOptions);
            RebalanceStep rebalanceStep = new CheckShouldRebalance(context).onFailureThen(new ReplicaMovementRebalance(context)).onFailureThen(new PartitionMovementRebalance(context));
            boolean success = rebalanceStep.balance();
            if (success) continue;
            if (!broker.isAlive()) {
                throw new OptimizationFailureException(String.format("[%s] Failed to move dead broker replica %s of partition %s. Per broker limit: %d for brokers: %s", this.name(), replica, clusterModel.partition(replica.topicPartition()), this.balancingConstraint.maxReplicasPerBroker(), clusterModel.allBrokers()));
            }
            if (isReplicaOffline) {
                throw new OptimizationFailureException(String.format("[%s] Failed to move offline replica %s of partition %s. Per broker limit: %d for brokers: %s", this.name(), replica, clusterModel.partition(replica.topicPartition()), this.balancingConstraint.maxReplicasPerBroker(), clusterModel.allBrokers()));
            }
            LOG.debug("Failed to move replica {} to any other broker.", (Object)replica);
        }
    }

    private List<Broker> eligibleBrokersPartitionMove(ClusterModel clusterModel, TopicPartition topicPartition, Cell destinationCell) {
        ArrayList<Broker> eligibleBrokers = new ArrayList<Broker>();
        destinationCell.aliveBrokers().stream().filter(broker -> (this.isSelfHealingMode || (long)broker.replicas().size() < this.balancingConstraint.maxReplicasPerBroker()) && !broker.hasReplicaOfPartition(topicPartition) && clusterModel.partition(topicPartition).canAssignReplicaToBroker((Broker)broker) && broker.isEligibleDestination()).forEach(eligibleBrokers::add);
        return eligibleBrokers;
    }

    private SortedSet<BrokerReplicaCount> eligibleBrokersReplicaMove(ClusterModel clusterModel, Replica replica) {
        TreeSet<BrokerReplicaCount> eligibleBrokers = new TreeSet<BrokerReplicaCount>();
        int numPartitionCells = (int)clusterModel.partition(replica.topicPartition()).partitionBrokers().stream().map(Broker::cell).distinct().count();
        clusterModel.aliveBrokers().stream().filter(broker -> !(!this.isSelfHealingMode && (long)broker.replicas().size() >= this.balancingConstraint.maxReplicasPerBroker() || broker.hasReplicaOfPartition(replica.topicPartition()) || numPartitionCells <= 1 && !broker.cell().equals(replica.broker().cell()) || !broker.isEligibleDestination())).forEach(broker -> eligibleBrokers.add(new BrokerReplicaCount((Broker)broker)));
        return eligibleBrokers;
    }

    private static class BrokerReplicaCount
    implements Comparable<BrokerReplicaCount> {
        private final Broker broker;
        private final int replicaCount;

        BrokerReplicaCount(Broker broker) {
            this.broker = broker;
            this.replicaCount = broker.replicas().size();
        }

        public Broker broker() {
            return this.broker;
        }

        int replicaCount() {
            return this.replicaCount;
        }

        @Override
        public int compareTo(BrokerReplicaCount o) {
            if (this.replicaCount > o.replicaCount()) {
                return 1;
            }
            if (this.replicaCount < o.replicaCount()) {
                return -1;
            }
            return Integer.compare(this.broker.id(), o.broker().id());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrokerReplicaCount that = (BrokerReplicaCount)o;
            return this.replicaCount == that.replicaCount && this.broker.id() == that.broker.id();
        }

        public int hashCode() {
            return Objects.hash(this.broker.id(), this.replicaCount);
        }
    }

    private class PartitionMovementRebalance
    implements RebalanceStep {
        private final RebalanceContext context;

        public PartitionMovementRebalance(RebalanceContext context) {
            this.context = context;
        }

        @Override
        public boolean doBalance() {
            if (this.context.clusterModel.skipCellBalancing()) {
                return false;
            }
            TopicPartition topicPartition = this.context.replica.topicPartition();
            Cell sourceCell = this.context.replica.broker().cell();
            String topic = topicPartition.topic();
            if (DatabalancerUtils.isTenantSpanningAcrossMultipleCells(this.context.clusterModel, topic).booleanValue()) {
                LOG.debug("Unable to move partition {} because it may violate inter-cell isolation constraints.", (Object)topicPartition);
                return false;
            }
            List cells = this.context.clusterModel.cellsById().values().stream().filter(cell -> !cell.equals(sourceCell)).collect(Collectors.toList());
            Collections.shuffle(cells, ReplicaCapacityGoal.this.rand);
            for (Cell cell2 : cells) {
                List<Replica> replicasToMove = ClusterModelHelper.replicasNotInExpectedCell(this.context.clusterModel.partition(topicPartition), cell2);
                boolean replicasOnExcludedBroker = replicasToMove.stream().anyMatch(r -> !r.broker().isEligible());
                if (replicasOnExcludedBroker) break;
                List eligibleBrokers = ReplicaCapacityGoal.this.eligibleBrokersPartitionMove(this.context.clusterModel, this.context.replica.topicPartition(), cell2);
                if (eligibleBrokers.size() < replicasToMove.size() || !this.movePartition(eligibleBrokers, replicasToMove)) continue;
                return true;
            }
            return false;
        }

        private boolean movePartition(List<Broker> eligibleBrokers, List<Replica> replicas) {
            ClusterModel clusterModel = this.context.clusterModel;
            Iterable<List<Broker>> brokersIt = EntityCombinator.singleEntityListIterable(eligibleBrokers, replicas.size());
            Map<Replica, Broker> replicaMoves = GoalUtils.getPartitionMoves(clusterModel, this.context.optimizedGoals, replicas, brokersIt);
            if (!replicaMoves.isEmpty()) {
                ReplicaRelocationContext replicaRelocationContext = ReplicaRelocationContext.forPartitionMovementAction(replicaMoves);
                replicaMoves.forEach((replica, broker) -> ReplicaCapacityGoal.this.relocateReplica(clusterModel, replica.topicPartition(), replica.broker().id(), broker.id(), replicaRelocationContext));
                return true;
            }
            return false;
        }
    }

    private class ReplicaMovementRebalance
    implements RebalanceStep {
        private final RebalanceContext context;

        ReplicaMovementRebalance(RebalanceContext context) {
            this.context = context;
        }

        @Override
        public boolean doBalance() {
            SortedSet eligibleBrokersWithCount = ReplicaCapacityGoal.this.eligibleBrokersReplicaMove(this.context.clusterModel, this.context.replica);
            List<Broker> eligibleBrokers = eligibleBrokersWithCount.stream().map(BrokerReplicaCount::broker).collect(Collectors.toList());
            Broker b = ReplicaCapacityGoal.this.maybeApplyBalancingAction(this.context.clusterModel, this.context.replica, eligibleBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, this.context.optimizedGoals, this.context.optimizationOptions);
            return b != null;
        }
    }

    private static class CheckShouldRebalance
    implements RebalanceStep {
        private final RebalanceContext context;

        CheckShouldRebalance(RebalanceContext context) {
            this.context = context;
        }

        @Override
        public boolean doBalance() {
            return AbstractGoal.shouldExclude(this.context.replica, this.context.excludedTopics);
        }
    }

    static class RebalanceContext {
        private final Replica replica;
        private final ClusterModel clusterModel;
        private final Set<String> excludedTopics;
        private final Set<Goal> optimizedGoals;
        private final OptimizationOptions optimizationOptions;

        RebalanceContext(ClusterModel clusterModel, Replica replica, Set<String> excludedTopics, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
            this.replica = replica;
            this.clusterModel = clusterModel;
            this.excludedTopics = excludedTopics;
            this.optimizedGoals = optimizedGoals;
            this.optimizationOptions = optimizationOptions;
        }
    }
}

