/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractBrokerGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.internals.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTopicEvenDistributionGoal
extends AbstractBrokerGoal {
    private static final Logger LOG = LoggerFactory.getLogger(SystemTopicEvenDistributionGoal.class);
    private BalanceMaps topicBalanceMaps;

    public SystemTopicEvenDistributionGoal() {
    }

    SystemTopicEvenDistributionGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        if (Topic.isInternal((String)action.topic())) {
            return ActionAcceptance.BROKER_REJECT;
        }
        if (action.destinationTopic() != null && Topic.isInternal((String)action.destinationTopic())) {
            return ActionAcceptance.REPLICA_REJECT;
        }
        return ActionAcceptance.ACCEPT;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return true;
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return SystemTopicEvenDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.newBrokers().isEmpty() ? clusterModel.eligibleSourceBrokers() : clusterModel.newBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        Set excludedSystemTopics = excludedTopics.stream().filter(Topic::isInternal).collect(Collectors.toSet());
        if (!excludedSystemTopics.isEmpty()) {
            LOG.info("Excluded system topics: {}", excludedSystemTopics);
        }
        this.topicBalanceMaps = BalanceMaps.fromClusterModel(clusterModel, excludedTopics);
        LOG.info("Allowed replica balance for system topics: {}", (Object)this.topicBalanceMaps.toRangeInfoString());
        LOG.debug("Current system topic leader/follower distribution: {}", (Object)this.topicBalanceMaps);
    }

    private void validateSystemTopicBalanceFromModel(ClusterModel clusterModel, Set<String> excludedTopics) {
        BalanceMaps currentBalance = BalanceMaps.fromClusterModel(clusterModel, excludedTopics);
        this.validateSystemTopicBalanceFromMaps(currentBalance);
    }

    private void validateSystemTopicBalanceFromMaps(BalanceMaps replicaBalanceMaps) {
        replicaBalanceMaps.trackedTopics().forEach(topicName -> Stream.of(BalanceMaps.ReplicaType.values()).forEach(replicaType -> this.validateTopicBalanceFromMap(replicaBalanceMaps, (String)topicName, (BalanceMaps.ReplicaType)((Object)((Object)replicaType)))));
    }

    private void validateTopicBalanceFromMap(BalanceMaps replicaBalanceMaps, String topic, BalanceMaps.ReplicaType replicaType) {
        Optional<TopicBalanceData> replicasByBrokerOpt = replicaBalanceMaps.maybeGetTopicBalanceDataForTopicAndReplicaType(topic, replicaType);
        if (!replicasByBrokerOpt.isPresent()) {
            return;
        }
        TopicBalanceData replicasByBroker = replicasByBrokerOpt.get();
        for (int brokerId : replicasByBroker.destinationBrokers()) {
            int brokerReplicaCount = replicasByBroker.brokerReplicaCount(brokerId);
            if (brokerReplicaCount >= replicasByBroker.minAllowedReplicas() && brokerReplicaCount <= replicasByBroker.maxAllowedReplicas()) continue;
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
            LOG.warn("Broker {} was not properly optimized: has {} {} replicas of {}, should be in the range [{}, {}]", new Object[]{brokerId, brokerReplicaCount, replicaType, topic, replicasByBroker.minAllowedReplicas(), replicasByBroker.maxAllowedReplicas()});
        }
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        this.validateSystemTopicBalanceFromModel(clusterModel, excludedTopics);
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.topicBalanceMaps = null;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        for (String topic : this.topicBalanceMaps.trackedTopics()) {
            if (optimizationOptions.excludedTopics().contains(topic) && broker.isAlive()) continue;
            Stream.of(BalanceMaps.ReplicaType.values()).forEach(replicaType -> this.rebalanceBrokerForTopicReplicaType(broker, clusterModel, optimizedGoals, optimizationOptions, topic, (BalanceMaps.ReplicaType)((Object)replicaType)));
        }
    }

    private void rebalanceBrokerForTopicReplicaType(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, String topic, BalanceMaps.ReplicaType replicaType) {
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("rebalanceBrokerForTopicReplicaType doesn't accept ignored broker as input.");
        }
        Optional<TopicBalanceData> currentBalanceOpt = this.topicBalanceMaps.maybeGetTopicBalanceDataForTopicAndReplicaType(topic, replicaType);
        if (!currentBalanceOpt.isPresent()) {
            return;
        }
        TopicBalanceData currentBalance = currentBalanceOpt.get();
        int currentReplicaCount = currentBalance.brokerReplicaCount(broker.id());
        int amountNeededForBalance = 0;
        if (!broker.isAlive()) {
            LOG.debug("Broker {} is DEAD. Moving {} {} replicas of topic {} away", new Object[]{broker.id(), currentReplicaCount, replicaType, topic});
            amountNeededForBalance = currentReplicaCount;
            this.removeReplicasFromBroker(broker, clusterModel, optimizedGoals, optimizationOptions, amountNeededForBalance, currentBalance);
        } else if (currentReplicaCount < currentBalance.minAllowedReplicas()) {
            LOG.info("Broker {} is underloaded for topic {} {} replicas: want in range [{}, {}] have {}", new Object[]{broker.id(), topic, replicaType, currentBalance.minAllowedReplicas(), currentBalance.maxAllowedReplicas(), currentReplicaCount});
            amountNeededForBalance = currentBalance.minAllowedReplicas() - currentReplicaCount;
            this.addReplicasToBroker(broker, clusterModel, optimizedGoals, optimizationOptions, amountNeededForBalance, currentBalance);
        } else if (currentReplicaCount > currentBalance.maxAllowedReplicas()) {
            LOG.info("Broker {} is overloaded for topic {} {} replicas: want in range [{}, {}] have {}", new Object[]{broker.id(), topic, replicaType, currentBalance.minAllowedReplicas(), currentBalance.maxAllowedReplicas(), currentReplicaCount});
            amountNeededForBalance = currentReplicaCount - currentBalance.maxAllowedReplicas();
            this.removeReplicasFromBroker(broker, clusterModel, optimizedGoals, optimizationOptions, amountNeededForBalance, currentBalance);
        }
    }

    private void removeReplicasFromBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, int numberNeededForBalance, TopicBalanceData currentBalance) {
        LOG.debug("Removing {} replicas from broker {}", (Object)numberNeededForBalance, (Object)broker.id());
        ArrayList currentBrokerReplicas = new ArrayList((Collection)currentBalance.brokerReplicas.get(broker.id()));
        for (Replica r : currentBrokerReplicas) {
            if (numberNeededForBalance == 0) {
                return;
            }
            Set eligibleRecipients = currentBalance.eligibleRecipients().stream().map(clusterModel::broker).collect(Collectors.toCollection(LinkedHashSet::new));
            List<Broker> candidateBrokers = GoalUtils.eligibleBrokers(clusterModel, r, eligibleRecipients, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizationOptions);
            Broker destBroker = this.maybeApplyBalancingAction(clusterModel, r, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions);
            if (destBroker == null) continue;
            --numberNeededForBalance;
            currentBalance.moveReplica(r, broker.id(), destBroker.id());
        }
        if (numberNeededForBalance > 0) {
            LOG.info("Unable to balance overloaded broker {}: {} still need to move", (Object)broker.id(), (Object)numberNeededForBalance);
        }
    }

    private void addReplicasToBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, int numberNeededForBalance, TopicBalanceData currentBalance) {
        List<Broker> candidateBroker = Collections.singletonList(broker);
        LOG.debug("Trying to move {} replicas into broker {} -- current count {}, allowed range [{}, {}]", new Object[]{numberNeededForBalance, broker.id(), currentBalance.brokerReplicaCount(broker.id()), currentBalance.minAllowedReplicas(), currentBalance.maxAllowedReplicas()});
        HashSet<Integer> donorsToExclude = new HashSet<Integer>();
        while (numberNeededForBalance > 0) {
            Optional<Integer> donorBrokerOpt = currentBalance.mostLikelyDonor(donorsToExclude);
            if (!donorBrokerOpt.isPresent()) {
                return;
            }
            HashSet<Replica> currentDonorReplicas = new HashSet<Replica>(currentBalance.replicasForBroker(donorBrokerOpt.get()));
            boolean movedReplica = false;
            for (Replica candidateReplica : currentDonorReplicas) {
                Broker b = this.maybeApplyBalancingAction(clusterModel, candidateReplica, candidateBroker, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions);
                if (b == null) continue;
                --numberNeededForBalance;
                currentBalance.moveReplica(candidateReplica, donorBrokerOpt.get(), broker.id());
                movedReplica = true;
                break;
            }
            if (movedReplica) continue;
            donorsToExclude.add(donorBrokerOpt.get());
        }
    }

    TopicBalanceData leaderCounts(String topic) {
        return this.topicBalanceMaps.leaderMaps(topic);
    }

    TopicBalanceData followerCounts(String topic) {
        return this.topicBalanceMaps.followerMaps(topic);
    }

    Set<String> trackedTopics() {
        return this.topicBalanceMaps.trackedTopics();
    }

    static class BalanceMaps {
        private final Map<String, Map<ReplicaType, TopicBalanceData>> balanceMaps;

        static BalanceMaps fromClusterModel(ClusterModel clusterModel, Set<String> excludedTopics) {
            Set eligibleDestinationBrokerIds = clusterModel.eligibleDestinationBrokers().stream().map(Broker::id).collect(Collectors.toSet());
            Set clusterEligibleBrokerIds = clusterModel.eligibleSourceBrokers().stream().map(Broker::id).collect(Collectors.toSet());
            Map<String, Map<ReplicaType, TopicBalanceData>> balanceMap = clusterModel.getPartitionsByTopic().entrySet().stream().filter(e -> Topic.isInternal((String)((String)e.getKey()))).flatMap(e -> ((List)e.getValue()).stream()).flatMap(e -> e.replicas().stream()).filter(replica -> replica.broker().isEligible()).collect(Collectors.groupingBy(replica -> replica.topicPartition().topic(), Collectors.groupingBy(replica -> replica.isLeader() ? ReplicaType.LEADER : ReplicaType.FOLLOWER, Collectors.collectingAndThen(Collectors.groupingBy(replica -> replica.broker().id(), Collectors.toSet()), brokerToReplicas -> new TopicBalanceData((Map<Integer, Set<Replica>>)brokerToReplicas, clusterEligibleBrokerIds, eligibleDestinationBrokerIds)))));
            return new BalanceMaps(balanceMap);
        }

        private BalanceMaps(Map<String, Map<ReplicaType, TopicBalanceData>> balanceMaps) {
            this.balanceMaps = balanceMaps;
        }

        public Optional<TopicBalanceData> maybeGetTopicBalanceDataForTopicAndReplicaType(String topic, ReplicaType replicaType) {
            return Optional.ofNullable(this.balanceMaps.getOrDefault(topic, Collections.emptyMap()).get((Object)replicaType));
        }

        public TopicBalanceData leaderMaps(String topic) {
            return (TopicBalanceData)this.balanceMaps.getOrDefault(topic, Collections.emptyMap()).get((Object)ReplicaType.LEADER);
        }

        public TopicBalanceData followerMaps(String topic) {
            return (TopicBalanceData)this.balanceMaps.getOrDefault(topic, Collections.emptyMap()).get((Object)ReplicaType.FOLLOWER);
        }

        public Set<String> trackedTopics() {
            return this.balanceMaps.keySet();
        }

        public String toRangeInfoString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, Map<ReplicaType, TopicBalanceData>> topicEntry : this.balanceMaps.entrySet()) {
                for (Map.Entry<ReplicaType, TopicBalanceData> typeEntry : topicEntry.getValue().entrySet()) {
                    sb.append(String.format("{topic=%s replicaType=%s minAllowedReplicas=%d maxAllowedReplicas=%d}", new Object[]{topicEntry.getKey(), typeEntry.getKey(), typeEntry.getValue().minAllowedReplicas(), typeEntry.getValue().maxAllowedReplicas()}));
                }
            }
            sb.append("}");
            return sb.toString();
        }

        private static enum ReplicaType {
            LEADER,
            FOLLOWER;

        }
    }

    static class TopicBalanceData {
        private final Set<Integer> eligibleDestinationBrokerIds;
        private final Map<Integer, Set<Replica>> brokerReplicas;
        private final int minAllowedReplicas;
        private final int maxAllowedReplicas;

        public TopicBalanceData(Map<Integer, Set<Replica>> brokerReplicaMap, Collection<Integer> clusterBrokers, Collection<Integer> eligibleDestinationBrokers) {
            this.eligibleDestinationBrokerIds = new HashSet<Integer>(eligibleDestinationBrokers);
            this.brokerReplicas = brokerReplicaMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue())));
            clusterBrokers.stream().forEach(b -> this.brokerReplicas.computeIfAbsent((Integer)b, HashSet::new));
            int totalReplicaCount = this.brokerReplicas.values().stream().mapToInt(Set::size).sum();
            double mean = eligibleDestinationBrokers.isEmpty() ? 0.0 : (double)totalReplicaCount / (double)this.eligibleDestinationBrokerIds.size();
            this.minAllowedReplicas = (int)Math.floor(mean);
            this.maxAllowedReplicas = (int)Math.ceil(mean);
        }

        public int brokerReplicaCount(int brokerId) {
            if (this.brokerReplicas.containsKey(brokerId)) {
                return this.brokerReplicas.get(brokerId).size();
            }
            throw new IllegalArgumentException(String.format("Checking replicas counts for unknown broker %d", brokerId));
        }

        public LinkedHashSet<Integer> eligibleRecipients() {
            Comparator<Map.Entry> brokerReplicaCountValueComparatorIncreasing = Comparator.comparingInt(e -> ((Set)e.getValue()).size());
            return this.brokerReplicas.entrySet().stream().filter(this::canReceiveReplicas).sorted(brokerReplicaCountValueComparatorIncreasing).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        private boolean canReceiveReplicas(Map.Entry<Integer, Set<Replica>> brokerDataEntry) {
            return this.eligibleDestinationBrokerIds.contains(brokerDataEntry.getKey()) && brokerDataEntry.getValue().size() < this.maxAllowedReplicas();
        }

        public Optional<Integer> mostLikelyDonor(Set<Integer> donorsToExclude) {
            Comparator<Map.Entry> donorLivenessComparator = Comparator.comparing(e -> this.eligibleDestinationBrokerIds.contains(e.getKey()), Boolean::compareTo);
            Comparator<Map.Entry> donorBrokerValueComparator = Comparator.comparingInt(e -> ((Set)e.getValue()).size()).reversed();
            return this.brokerReplicas.entrySet().stream().filter(this::canDonateReplicas).filter(e -> !donorsToExclude.contains(e.getKey())).sorted(donorLivenessComparator.thenComparing(donorBrokerValueComparator)).map(Map.Entry::getKey).findFirst();
        }

        private boolean canDonateReplicas(Map.Entry<Integer, Set<Replica>> brokerDataEntry) {
            return !this.eligibleDestinationBrokerIds.contains(brokerDataEntry.getKey()) && !brokerDataEntry.getValue().isEmpty() || brokerDataEntry.getValue().size() > this.minAllowedReplicas();
        }

        public void moveReplica(Replica replica, int sourceBrokerId, int destBrokerId) {
            this.verifyKnownBroker(sourceBrokerId);
            this.verifyKnownBroker(destBrokerId);
            if (!this.brokerReplicas.get(sourceBrokerId).contains(replica)) {
                throw new IllegalArgumentException(String.format("Replica %s not present in broker %d while moving to broker %d", replica, sourceBrokerId, destBrokerId));
            }
            if (this.brokerReplicas.get(destBrokerId).contains(replica)) {
                throw new IllegalArgumentException(String.format("Replica %s already present in broker %d while moving from broker %d", replica, destBrokerId, sourceBrokerId));
            }
            if (!this.eligibleDestinationBrokerIds.contains(destBrokerId)) {
                throw new IllegalArgumentException(String.format("Attempting to move replica to dead broker %d", destBrokerId));
            }
            this.brokerReplicas.get(sourceBrokerId).remove(replica);
            this.brokerReplicas.get(destBrokerId).add(replica);
        }

        Set<Integer> trackedBrokers() {
            return this.brokerReplicas.keySet();
        }

        public Set<Integer> destinationBrokers() {
            return Collections.unmodifiableSet(this.eligibleDestinationBrokerIds);
        }

        public int minAllowedReplicas() {
            return this.minAllowedReplicas;
        }

        public int maxAllowedReplicas() {
            return this.maxAllowedReplicas;
        }

        Set<Replica> replicasForBroker(int brokerId) {
            return Collections.unmodifiableSet(this.brokerReplicas.get(brokerId));
        }

        private void verifyKnownBroker(int brokerId) {
            if (!this.brokerReplicas.containsKey(brokerId)) {
                throw new IllegalArgumentException(String.format("Adjusting replica count on unknown broker %d", brokerId));
            }
        }

        public String toString() {
            return "TopicBalanceData{eligibleDestinationBrokerIds=" + this.eligibleDestinationBrokerIds + ", brokerReplicas=" + this.brokerReplicas + ", minAllowedReplicas=" + this.minAllowedReplicas + ", maxAllowedReplicas=" + this.maxAllowedReplicas + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicBalanceData that = (TopicBalanceData)o;
            return this.minAllowedReplicas == that.minAllowedReplicas && this.maxAllowedReplicas == that.maxAllowedReplicas && Objects.equals(this.eligibleDestinationBrokerIds, that.eligibleDestinationBrokerIds) && Objects.equals(this.brokerReplicas, that.brokerReplicas);
        }

        public int hashCode() {
            return Objects.hash(this.eligibleDestinationBrokerIds, this.brokerReplicas, this.minAllowedReplicas, this.maxAllowedReplicas);
        }
    }
}

