/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class BrokerAndSortedReplicas {
    private final Broker broker;
    private final NavigableSet<Replica> sortedReplicas;

    public BrokerAndSortedReplicas(Broker broker, Comparator<Replica> comparator) {
        this.broker = broker;
        this.sortedReplicas = new TreeSet<Replica>((r1, r2) -> {
            int result = comparator.compare((Replica)r1, (Replica)r2);
            return result == 0 ? r1.compareTo((Replica)r2) : result;
        });
        this.sortedReplicas.addAll(broker.replicas());
    }

    public Broker broker() {
        return this.broker;
    }

    public NavigableSet<Replica> sortedReplicas() {
        return this.sortedReplicas;
    }

    public int hashCode() {
        return this.broker.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BrokerAndSortedReplicas && this.broker.equals(((BrokerAndSortedReplicas)obj).broker());
    }
}

