/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.util;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDistributionLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDistributionLogger.class);
    private final String goalName;
    private final ResourceUtilizationRatioThresholdsProvider thresholds;
    private final Collection<Cell> cells;
    private final OptimizationOptions optimizationOptions;
    private final List<ResourceDistributionStatsSnapshot> statsSnapshot;

    private ResourceDistributionLogger(Builder builder) {
        this.goalName = Objects.requireNonNull(builder.goalName, "Cannot create ResourceDistributionLogger with null goalName");
        this.thresholds = Objects.requireNonNull(builder.thresholds, "Cannot create ResourceDistributionLogger with null ResourceDistributionThresholdsProvider");
        this.optimizationOptions = Objects.requireNonNull(builder.optimizationOptions, "Cannot create ResourceDistributionLogger with null OptimizationOptions");
        this.cells = Collections.unmodifiableCollection(builder.cells);
        this.statsSnapshot = Collections.unmodifiableList(builder.statsSnapshot);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void logResourceDistribution() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Initiated ");
        messageBuilder.append(this.goalName);
        messageBuilder.append(" with cluster percentage thresholds (");
        messageBuilder.append(this.thresholds.clusterThresholds());
        messageBuilder.append(")");
        if (!this.thresholds.cellsThresholds().isEmpty()) {
            messageBuilder.append(" and cell percentage thresholds [");
            this.thresholds.cellsThresholds().forEach((key, value) -> {
                messageBuilder.append("Cell ");
                messageBuilder.append(key);
                messageBuilder.append("(");
                messageBuilder.append(value);
                messageBuilder.append("), ");
            });
            messageBuilder.append("]");
        }
        if (!this.cells.isEmpty()) {
            messageBuilder.append(" where the brokers spread across cells is [");
            for (Cell cell : this.cells) {
                messageBuilder.append("Cell(id=");
                messageBuilder.append(cell.id());
                messageBuilder.append(", brokers=");
                messageBuilder.append(cell.brokers().stream().map(Broker::id).collect(Collectors.toList()));
                messageBuilder.append("), ");
            }
            messageBuilder.append("]");
        }
        if (!this.statsSnapshot.isEmpty()) {
            messageBuilder.append(" and absolute thresholds per cell are [");
            this.statsSnapshot.forEach(statSnapshot -> {
                messageBuilder.append("Cell ");
                messageBuilder.append(statSnapshot.cellId());
                messageBuilder.append('(');
                messageBuilder.append(statSnapshot.resourceValueThresholds());
                messageBuilder.append("), ");
            });
            messageBuilder.append("]");
        }
        if (this.optimizationOptions.isTriggeredByGoalViolation()) {
            messageBuilder.append(" as part of evaluating whether to trigger the even-cluster load task");
        }
        if (!this.statsSnapshot.isEmpty()) {
            messageBuilder.append(" (all distribution statistics per cell are [");
            for (ResourceDistributionStatsSnapshot snapshot : this.statsSnapshot) {
                messageBuilder.append(snapshot);
                messageBuilder.append(", ");
            }
            messageBuilder.append("])");
        }
        String message = messageBuilder.toString();
        LOG.info(message);
    }

    public static class Builder {
        private String goalName = null;
        private ResourceUtilizationRatioThresholdsProvider thresholds = null;
        private OptimizationOptions optimizationOptions = null;
        private List<ResourceDistributionStatsSnapshot> statsSnapshot = Collections.emptyList();
        private Collection<Cell> cells = Collections.emptyList();

        public Builder goalName(@Nonnull String goalName) {
            this.goalName = goalName;
            return this;
        }

        public Builder cells(@Nonnull Collection<Cell> cells) {
            this.cells = Objects.requireNonNull(cells, "cells cannot be null");
            return this;
        }

        public Builder thresholds(@Nonnull ResourceUtilizationRatioThresholdsProvider thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder optimizationOptions(OptimizationOptions optimizationOptions) {
            this.optimizationOptions = optimizationOptions;
            return this;
        }

        public Builder statsSnapshot(@Nonnull List<ResourceDistributionStatsSnapshot> statsSnapshot) {
            this.statsSnapshot = Objects.requireNonNull(statsSnapshot, "statsSnapshot cannot be null");
            return this;
        }

        public ResourceDistributionLogger build() {
            return new ResourceDistributionLogger(this);
        }
    }
}

