/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.Arrays;
import java.util.Objects;
import java.util.OptionalDouble;

public class CircularBuffer<T extends Number> {
    private final Number[] buffer;
    private int bufferIdx;

    public CircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0.");
        }
        this.buffer = new Number[size];
    }

    public void add(T value) {
        this.buffer[this.bufferIdx++ % this.buffer.length] = value;
    }

    public OptionalDouble average() {
        return Arrays.stream(this.buffer).filter(Objects::nonNull).mapToDouble(Number::doubleValue).average();
    }
}

