/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyFixStatus;
import com.linkedin.kafka.cruisecontrol.analyzer.result.OptimizationPlaintextSummary;
import com.linkedin.kafka.cruisecontrol.detector.CellOverloadPlan;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import com.linkedin.kafka.cruisecontrol.detector.utils.CellOverloadOccurrenceRecorder;
import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import com.linkedin.kafka.cruisecontrol.model.OverloadedCell;
import com.linkedin.kafka.cruisecontrol.model.view.ClusterModelCellView;
import io.confluent.kafka.clients.AssignTenantsToCellResult;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellOverload
extends KafkaAnomaly {
    private static final Logger LOG = LoggerFactory.getLogger(CellOverload.class);
    private static final String ID_PREFIX = AnomalyType.CELL_OVERLOAD.toString();
    private final String anomalyId = String.format("%s-%s", ID_PREFIX, UUID.randomUUID().toString().substring(ID_PREFIX.length() + 1));
    private final CloudAdmin cloudAdmin;
    private final CellOverloadOccurrenceRecorder cellOverloadOccurrenceRecorder;
    private final Collection<CellOverloadPlan> cellOverloadPlans;
    private final ClusterModelCellView postOptimizationCellView;
    private final double cellLoadUpperBound;
    private final long maxReplicasPerBroker;
    private OptimizationPlaintextSummary plaintextSummary;

    public CellOverload(CloudAdmin cloudAdmin, CellOverloadOccurrenceRecorder cellOverloadOccurrenceRecorder, Collection<CellOverloadPlan> cellOverloadPlans, ClusterModelCellView postOptimizationCellView, double cellLoadUpperBound, long maxReplicasPerBroker) {
        this.cloudAdmin = cloudAdmin;
        this.cellOverloadOccurrenceRecorder = cellOverloadOccurrenceRecorder;
        this.cellOverloadPlans = cellOverloadPlans;
        this.postOptimizationCellView = postOptimizationCellView;
        this.cellLoadUpperBound = cellLoadUpperBound;
        this.maxReplicasPerBroker = maxReplicasPerBroker;
    }

    @Override
    public String anomalyId() {
        return this.anomalyId;
    }

    public Collection<CellOverloadPlan> cellOverloadPlans() {
        return this.cellOverloadPlans;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public AnomalyFixStatus fix() throws Exception {
        AnomalyFixStatus fixStatus = AnomalyFixStatus.START_SUCCESSFULLY;
        StringBuilder optimizationSummaryBuilder = new StringBuilder();
        LOG.info("Alleviating cell overload for {} cells - {}", (Object)this.cellOverloadPlans.size(), this.cellOverloadPlans.stream().map(CellOverloadPlan::overloadedCellId));
        for (CellOverloadPlan cellOverloadPlan : this.cellOverloadPlans) {
            this.populateCellOverloadPlanOverview(optimizationSummaryBuilder, cellOverloadPlan);
            List assignments = cellOverloadPlan.tenantProposals().stream().map(this::createTenantToCellAssignment).collect(Collectors.toList());
            AssignTenantsToCellResult result = this.cloudAdmin.assignTenantsToCells(assignments);
            List tenantAssignmentErrors = (List)result.value().get();
            if (!tenantAssignmentErrors.isEmpty()) {
                fixStatus = AnomalyFixStatus.START_FAILED;
                this.populateTenantAssignmentErrors(optimizationSummaryBuilder, tenantAssignmentErrors);
                tenantAssignmentErrors.forEach(tenantAssignmentError -> cellOverloadPlan.tenantProposal(tenantAssignmentError.tenantId()).ifPresent(this.postOptimizationCellView::unapply));
            } else {
                optimizationSummaryBuilder.append("All tenant assignments completed successfully.").append(System.lineSeparator());
            }
            OverloadedCell overloadedCell = this.postOptimizationCellView.cell(cellOverloadPlan.overloadedCellId()).detectOverload(this.cellLoadUpperBound, this.maxReplicasPerBroker);
            this.populateCellBalanceResult(optimizationSummaryBuilder, overloadedCell);
            if (overloadedCell.isOverloaded()) continue;
            this.cellOverloadOccurrenceRecorder.clearOccurrence(cellOverloadPlan.overloadedCellId());
        }
        this.plaintextSummary = new OptimizationPlaintextSummary(optimizationSummaryBuilder.toString());
        return fixStatus;
    }

    private AssignTenantsToCellRequestData.TenantToCellAssignment createTenantToCellAssignment(TenantProposal proposal) {
        HashSet<Integer> tenantAssignedCellIds = new HashSet<Integer>(proposal.tenant().cellIds());
        tenantAssignedCellIds.remove(proposal.oldCellId());
        tenantAssignedCellIds.add(proposal.newCellId());
        return new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(proposal.tenant().tenantId()).setCellIds(new ArrayList<Integer>(tenantAssignedCellIds));
    }

    private void populateCellOverloadPlanOverview(StringBuilder optimizationSummaryBuilder, CellOverloadPlan cellOverloadPlan) {
        optimizationSummaryBuilder.append(System.lineSeparator());
        optimizationSummaryBuilder.append("Overloaded Cell: ").append(cellOverloadPlan.overloadedCellId());
        optimizationSummaryBuilder.append(System.lineSeparator());
        optimizationSummaryBuilder.append("Tenant Proposals:").append(System.lineSeparator());
        for (TenantProposal tenantProposal : cellOverloadPlan.tenantProposals()) {
            optimizationSummaryBuilder.append(tenantProposal).append(System.lineSeparator());
        }
        optimizationSummaryBuilder.append("Moving Tenant Load:").append(System.lineSeparator()).append(cellOverloadPlan.movingUtilization().totalUtilization());
        optimizationSummaryBuilder.append(System.lineSeparator());
        optimizationSummaryBuilder.append("Moving Replicas: ").append(cellOverloadPlan.movingReplicas());
        optimizationSummaryBuilder.append(System.lineSeparator());
        optimizationSummaryBuilder.append("Enough to Fix Cell Overload: ").append(cellOverloadPlan.willFixCellOverload());
        optimizationSummaryBuilder.append(System.lineSeparator());
    }

    private void populateTenantAssignmentErrors(StringBuilder optimizationSummaryBuilder, List<AssignTenantsToCellResponseData.TenantAssignmentErrors> tenantAssignmentErrors) {
        optimizationSummaryBuilder.append("Tenant Assignment Errors:").append(System.lineSeparator());
        tenantAssignmentErrors.forEach(tenantAssignmentError -> optimizationSummaryBuilder.append(tenantAssignmentError.toString()).append(System.lineSeparator()));
    }

    private void populateCellBalanceResult(StringBuilder optimizationSummaryBuilder, OverloadedCell overloadedCell) {
        optimizationSummaryBuilder.append("Cell ").append(overloadedCell.cell().id()).append(" is ");
        if (overloadedCell.isOverloaded()) {
            optimizationSummaryBuilder.append("still ");
        } else {
            optimizationSummaryBuilder.append("not ");
        }
        optimizationSummaryBuilder.append("overloaded after executing tenant proposals.").append(System.lineSeparator());
    }

    @Override
    public AnomalyNotificationResult notifyAnomalyInProgress(SelfHealingNotifier selfHealingNotifier) {
        return selfHealingNotifier.onCellOverload(this);
    }

    @Override
    OptimizationPlaintextSummary optimizationResultSummary() {
        return this.plaintextSummary;
    }
}

