/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CellOverloadPlan {
    private final int overloadedCellId;
    private final Utilization movingUtilization;
    private final int movingReplicas;
    private final Map<String, TenantProposal> tenantProposalByTenantId;
    private final boolean willFixCellOverload;

    private CellOverloadPlan(Builder builder) {
        this.overloadedCellId = builder.overloadedCellId;
        this.movingUtilization = builder.movingUtilization;
        this.movingReplicas = builder.movingReplicas;
        this.tenantProposalByTenantId = builder.tenantProposalByTenantId;
        this.willFixCellOverload = builder.willFixCellOverload;
    }

    public static Builder builder(int overloadedCellId) {
        return new Builder(overloadedCellId);
    }

    public boolean isEmpty() {
        return this.tenantProposalByTenantId.isEmpty();
    }

    public int overloadedCellId() {
        return this.overloadedCellId;
    }

    public Utilization movingUtilization() {
        return this.movingUtilization;
    }

    public int movingReplicas() {
        return this.movingReplicas;
    }

    public Collection<TenantProposal> tenantProposals() {
        return this.tenantProposalByTenantId.values();
    }

    public Optional<TenantProposal> tenantProposal(String tenantId) {
        return Optional.ofNullable(this.tenantProposalByTenantId.get(tenantId));
    }

    public boolean willFixCellOverload() {
        return this.willFixCellOverload;
    }

    public String toString() {
        return "CellOverloadPlan{overloadedCellId=" + this.overloadedCellId + ", movingUtilization=" + this.movingUtilization.totalUtilization() + ", movingReplicas=" + this.movingReplicas + ", tenantProposals=" + this.tenantProposals() + ", willFixCellOverload=" + this.willFixCellOverload + '}';
    }

    public static final class Builder {
        private final int overloadedCellId;
        private final Utilization movingUtilization;
        private int movingReplicas;
        private final Map<String, TenantProposal> tenantProposalByTenantId;
        private boolean willFixCellOverload;

        private Builder(int overloadedCellId) {
            this.overloadedCellId = overloadedCellId;
            this.movingUtilization = Utilization.from(new Load());
            this.movingReplicas = 0;
            this.tenantProposalByTenantId = new HashMap<String, TenantProposal>();
            this.willFixCellOverload = false;
        }

        public Builder addTenantProposal(Tenant tenant, TenantProposal tenantProposal) {
            this.tenantProposalByTenantId.put(tenant.tenantId(), tenantProposal);
            this.movingUtilization.addUtilization(tenant.utilization(tenantProposal.oldCellId()));
            this.movingReplicas += tenant.replicaCount(tenantProposal.oldCellId());
            return this;
        }

        public Builder willFixCellOverload(boolean willFixCellOverload) {
            this.willFixCellOverload = willFixCellOverload;
            return this;
        }

        public CellOverloadPlan build() {
            return new CellOverloadPlan(this);
        }
    }
}

