/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import java.util.List;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationHandler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationHandler.class);
    private final LoadMonitor loadMonitor;
    private final Time time;
    private final List<ResourceUtilizationDetector> detectors;
    private final ModelCompletenessRequirements modelCompletenessRequirements;
    private ModelGeneration lastCheckModelGeneration;

    public ResourceUtilizationHandler(KafkaCruiseControlConfig kccConfig, LoadMonitor loadMonitor, Time time, List<ResourceUtilizationDetector> detectors) {
        this.loadMonitor = loadMonitor;
        this.time = time;
        this.lastCheckModelGeneration = null;
        double minMonitoredPartitionPercentage = kccConfig.getDouble("min.valid.partition.ratio");
        this.modelCompletenessRequirements = new ModelCompletenessRequirements(1, minMonitoredPartitionPercentage, true);
        this.detectors = detectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long now = this.time.milliseconds();
            LOG.info("Running resource utilization detector.");
            if (!this.loadMonitor.clusterModelGeneration().equals(this.lastCheckModelGeneration)) {
                ClusterModel clusterModel = this.loadMonitor.createClusterModelToleratingPartitionReassignments(now, this.modelCompletenessRequirements, new OperationProgress());
                this.lastCheckModelGeneration = clusterModel.generation();
                this.detectors.forEach(detector -> detector.detectResourceUtilization(clusterModel));
            }
        }
        catch (NotEnoughValidWindowsException ne) {
            LOG.debug("Resetting all resource detectors because of not having enough windows", (Throwable)ne);
            this.detectors.forEach(ResourceUtilizationDetector::resetDetectorState);
        }
        catch (Exception e) {
            LOG.error("Resetting all resource detectors because of an unexpected exception", (Throwable)e);
            this.detectors.forEach(ResourceUtilizationDetector::resetDetectorState);
        }
        finally {
            LOG.info("Resource utilization detection finished.");
        }
    }

    public void close() {
        this.detectors.forEach(detector -> KafkaCruiseControlUtils.executeSilently(detector, ResourceUtilizationDetector::close, () -> String.format("Failed to shutdown %s during the shutdown of ResourceUtilizationHandler.", detector.name())));
    }
}

