/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BrokerExecutionTaskTracker {
    private final Map<Integer, Integer> inProgressMovements;
    private final Map<Integer, Integer> inProgressMovementsAsSource;
    private final Map<Integer, Integer> inProgressMovementsAsDestination;
    private final int maxInProgressMovements;
    private final int maxInProgressMovementsAsSource;
    private final int maxInProgressMovementsAsDestination;

    public BrokerExecutionTaskTracker(int maxInProgressMovements, int maxInProgressMovementsAsSource, int maxInProgressMovementsAsDestination) {
        this.inProgressMovements = new HashMap<Integer, Integer>();
        this.maxInProgressMovements = maxInProgressMovements;
        this.maxInProgressMovementsAsSource = maxInProgressMovementsAsSource;
        this.maxInProgressMovementsAsDestination = maxInProgressMovementsAsDestination;
        this.inProgressMovementsAsSource = new HashMap<Integer, Integer>();
        this.inProgressMovementsAsDestination = new HashMap<Integer, Integer>();
    }

    private BrokerExecutionTaskTracker(BrokerExecutionTaskTracker that) {
        this.inProgressMovements = new HashMap<Integer, Integer>(that.inProgressMovements);
        this.maxInProgressMovements = that.maxInProgressMovements;
        this.inProgressMovementsAsSource = new HashMap<Integer, Integer>(that.inProgressMovementsAsSource);
        this.inProgressMovementsAsDestination = new HashMap<Integer, Integer>(that.inProgressMovementsAsDestination);
        this.maxInProgressMovementsAsSource = that.maxInProgressMovementsAsSource;
        this.maxInProgressMovementsAsDestination = that.maxInProgressMovementsAsDestination;
    }

    public static BrokerExecutionTaskTracker duplicate(BrokerExecutionTaskTracker that) {
        return new BrokerExecutionTaskTracker(that);
    }

    public void maybeAddBroker(int brokerId) {
        this.inProgressMovements.putIfAbsent(brokerId, 0);
    }

    public Set<Integer> knownBrokers() {
        return Collections.unmodifiableSet(this.inProgressMovements.keySet());
    }

    public void addTaskForBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        if (!this.inProgressMovements.containsKey(brokerId)) {
            throw new IllegalArgumentException(String.format("Unknown broker ID %d", brokerId));
        }
        if (numMovements <= 0) {
            throw new IllegalArgumentException(String.format("Number of replica movements to track must be positive (%d requested)", numMovements));
        }
        if (!this.brokerHasCapacity(brokerId, numMovements = this.adjustMovementCount(numMovements))) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have space for %d movements (currently at %d)", brokerId, numMovements, this.brokerTaskCount(brokerId)));
        }
        this.inProgressMovements.put(brokerId, this.brokerTaskCount(brokerId) + numMovements);
    }

    public void removeTaskForBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        if (numMovements <= 0) {
            throw new IllegalArgumentException(String.format("Number of replica movements to remove must be positive (%d requested)", numMovements));
        }
        if (this.brokerHasCapacity(brokerId, -(numMovements = this.adjustMovementCount(numMovements)))) {
            this.inProgressMovements.put(brokerId, this.brokerTaskCount(brokerId) - numMovements);
        }
    }

    public void addTaskForBrokerAsSource(int brokerId) throws IllegalArgumentException {
        Integer currentMovements = this.inProgressMovementsAsSource.getOrDefault(brokerId, 0);
        if (currentMovements + 1 > this.maxInProgressMovementsAsSource) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have space for more movements (already has %d)", brokerId, currentMovements));
        }
        this.inProgressMovementsAsSource.put(brokerId, currentMovements + 1);
    }

    public void addTaskForBrokerAsDestination(int brokerId) throws IllegalArgumentException {
        int currentMovements = this.inProgressMovementsAsDestination.getOrDefault(brokerId, 0);
        if (currentMovements + 1 > this.maxInProgressMovementsAsDestination) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have space for more movements (already has %d)", brokerId, currentMovements));
        }
        this.inProgressMovementsAsDestination.put(brokerId, currentMovements + 1);
    }

    public void removeTaskForBrokerAsSource(int brokerId) throws IllegalArgumentException {
        int currentMovements = this.inProgressMovementsAsSource.getOrDefault(brokerId, 0);
        if (currentMovements <= 0) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have any tasks to remove as a source.", brokerId));
        }
        this.inProgressMovementsAsSource.put(brokerId, currentMovements - 1);
    }

    public void removeTaskForBrokerAsDestination(int brokerId) throws IllegalArgumentException {
        int currentMovements = this.inProgressMovementsAsDestination.getOrDefault(brokerId, 0);
        if (currentMovements <= 0) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have any tasks to remove as a destination.", brokerId));
        }
        this.inProgressMovementsAsDestination.put(brokerId, currentMovements - 1);
    }

    public boolean wouldOverloadBrokerAsSource(int brokerId) throws IllegalArgumentException {
        int currentMovements = this.inProgressMovementsAsSource.getOrDefault(brokerId, 0);
        return currentMovements + 1 > this.maxInProgressMovementsAsSource;
    }

    public boolean wouldOverloadBrokerAsDestination(int brokerId) throws IllegalArgumentException {
        int currentMovements = this.inProgressMovementsAsDestination.getOrDefault(brokerId, 0);
        return currentMovements + 1 > this.maxInProgressMovementsAsDestination;
    }

    public int brokerTaskCount(int brokerId) {
        return this.inProgressMovements.get(brokerId);
    }

    public boolean wouldOverloadBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        return !this.brokerHasCapacity(brokerId, numMovements = this.adjustMovementCount(numMovements));
    }

    public void clear() {
        this.inProgressMovements.clear();
    }

    Map<Integer, Integer> readonlyView() {
        return Collections.unmodifiableMap(this.inProgressMovements);
    }

    public String toString() {
        return "BrokerExecutionTaskTracker{maxInProgressMovements=" + this.maxInProgressMovements + ", maxInProgressMovementsAsSource=" + this.maxInProgressMovementsAsSource + ", maxInProgressMovementsAsDestination=" + this.maxInProgressMovementsAsDestination + ", inProgressMovements=" + this.inProgressMovements + ", inProgressMovementsAsSource=" + this.inProgressMovementsAsSource + ", inProgressMovementsAsDestination=" + this.inProgressMovementsAsDestination + '}';
    }

    private boolean brokerHasCapacity(int brokerId, int numMovements) {
        int movementsAfter = this.brokerTaskCount(brokerId) + numMovements;
        if (movementsAfter < 0) {
            throw new IllegalArgumentException(String.format("Request of %d  brings broker %d active executions (currently %d) below 0", numMovements, brokerId, this.brokerTaskCount(brokerId)));
        }
        return movementsAfter <= this.maxInProgressMovements;
    }

    private int adjustMovementCount(int providedMovements) {
        if (providedMovements < 0) {
            throw new IllegalArgumentException("Can't have a negative movement count!");
        }
        return Math.min(providedMovements, this.maxInProgressMovements);
    }
}

