/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.BrokerExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskGenerator;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import com.linkedin.kafka.cruisecontrol.executor.strategy.PrioritizePartitionsWithMoreReplicaAdditionsStrategy;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTaskPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionTaskPlanner.class);
    private final ExecutionTaskGenerator taskGenerator;
    private Map<Integer, SortedSet<ExecutionTask>> interPartMoveTaskByBrokerId;
    private final Map<Long, ExecutionTask> remainingLeadershipMovements;
    private final Map<Long, ExecutionTask> remainingTenantMovements;
    private final ReplicaMovementStrategy defaultReplicaMovementTaskStrategy;
    private final boolean isV2ExecutorEnabled;

    public ExecutionTaskPlanner(List<String> defaultReplicaMovementStrategies, KafkaCruiseControlConfig config) {
        this(new ExecutionTaskGenerator(config), defaultReplicaMovementStrategies, config.getBoolean("v2.executor.enabled"));
    }

    ExecutionTaskPlanner(ExecutionTaskGenerator taskGenerator, List<String> defaultReplicaMovementStrategies, boolean isV2ExecutorEnabled) {
        this.taskGenerator = taskGenerator;
        this.isV2ExecutorEnabled = isV2ExecutorEnabled;
        this.interPartMoveTaskByBrokerId = new HashMap<Integer, SortedSet<ExecutionTask>>();
        if (isV2ExecutorEnabled) {
            ArrayList<String> v2Strategies = new ArrayList<String>();
            if (defaultReplicaMovementStrategies != null) {
                v2Strategies.addAll(defaultReplicaMovementStrategies);
            }
            if (!v2Strategies.contains(PrioritizePartitionsWithMoreReplicaAdditionsStrategy.class.getName())) {
                v2Strategies.add(0, PrioritizePartitionsWithMoreReplicaAdditionsStrategy.class.getName());
            }
            this.defaultReplicaMovementTaskStrategy = ReplicaMovementStrategy.generateChainedReplicaMovementStrategies(v2Strategies);
        } else {
            this.defaultReplicaMovementTaskStrategy = ReplicaMovementStrategy.generateChainedReplicaMovementStrategies(defaultReplicaMovementStrategies);
        }
        this.remainingLeadershipMovements = new HashMap<Long, ExecutionTask>();
        this.remainingTenantMovements = new HashMap<Long, ExecutionTask>();
    }

    public void addPartitionProposals(Collection<PartitionProposal> proposals, Cluster cluster) {
        LOG.trace("Cluster state before adding proposals: {}.", (Object)cluster);
        this.maybeAddInterBrokerReplicaMovementTasks(proposals, cluster);
        this.maybeAddLeaderChangeTasks(proposals, cluster);
    }

    public void addTenantProposals(Collection<TenantProposal> proposals) {
        Set<ExecutionTask> tenantTasks = this.taskGenerator.generateTenantTasks(proposals);
        tenantTasks.forEach(t -> this.remainingTenantMovements.put(t.executionId(), (ExecutionTask)t));
    }

    private void maybeAddInterBrokerReplicaMovementTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Set<ExecutionTask> generatedTasks = this.taskGenerator.generateInterBrokerReplicaMovementTasks(proposals, cluster);
        this.interPartMoveTaskByBrokerId = this.orderInterBrokerReplicaMovementTasks(generatedTasks, cluster);
    }

    public void overrideInterBrokerTasksWithOrdering(Collection<ExecutionTask> tasks, Cluster cluster) {
        if (this.anyRemainingInterBrokerTasks()) {
            throw new IllegalStateException("Cannot re-plan ordering of inter-broker execution tasks while existing inter-broker tasks remain unexecuted as they would be overridden.");
        }
        this.interPartMoveTaskByBrokerId = this.orderInterBrokerReplicaMovementTasks(new HashSet<ExecutionTask>(tasks), cluster);
    }

    private void maybeAddLeaderChangeTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Set<ExecutionTask> leaderTasks = this.taskGenerator.generateLeaderChangeTasks(proposals, cluster);
        leaderTasks.forEach(t -> this.remainingLeadershipMovements.put(t.executionId(), (ExecutionTask)t));
    }

    public Set<ExecutionTask> remainingInterBrokerReplicaMovements() {
        HashSet<ExecutionTask> pendingExecutionTasks = new HashSet<ExecutionTask>();
        this.interPartMoveTaskByBrokerId.values().forEach(pendingExecutionTasks::addAll);
        return pendingExecutionTasks;
    }

    boolean anyRemainingInterBrokerTasks() {
        return this.interPartMoveTaskByBrokerId.values().stream().anyMatch(s -> !s.isEmpty());
    }

    public Collection<ExecutionTask> remainingLeadershipMovements() {
        return this.remainingLeadershipMovements.values();
    }

    public Collection<ExecutionTask> remainingTenantMovements() {
        return this.remainingTenantMovements.values();
    }

    public List<ExecutionTask> removeLeadershipMovementTasks(int numTasks) {
        return this.removeMovementTasks(numTasks, this.remainingLeadershipMovements);
    }

    private List<ExecutionTask> removeMovementTasks(int numTasks, Map<Long, ExecutionTask> executionTaskMap) {
        ArrayList<ExecutionTask> movementsList = new ArrayList<ExecutionTask>();
        Iterator<ExecutionTask> movementsIterator = executionTaskMap.values().iterator();
        for (int i = 0; i < numTasks && movementsIterator.hasNext(); ++i) {
            movementsList.add(movementsIterator.next());
            movementsIterator.remove();
        }
        return movementsList;
    }

    public List<ExecutionTask> removeTenantMovementTasks(int numTasks) {
        return this.removeMovementTasks(numTasks, this.remainingTenantMovements);
    }

    public List<ExecutionTask> drainInterBrokerTasks(BrokerExecutionTaskTracker brokerExecutionTracker, Set<TopicPartition> inProgressPartitions) {
        LOG.trace("Generating inter-broker replica movement tasks for brokers with concurrency {}", (Object)brokerExecutionTracker);
        ArrayList<ExecutionTask> executableReplicaMovements = new ArrayList<ExecutionTask>();
        if (this.isV2ExecutorEnabled) {
            boolean newTaskAdded = true;
            HashSet<TopicPartition> involvedPartitions = new HashSet<TopicPartition>();
            HashSet<Integer> involvedBrokers = new HashSet<Integer>();
            while (newTaskAdded) {
                newTaskAdded = false;
                involvedBrokers.clear();
                ArrayList<Integer> sourceBrokers = new ArrayList<Integer>(this.interPartMoveTaskByBrokerId.keySet());
                Collections.shuffle(sourceBrokers);
                for (Integer sourceBroker : sourceBrokers) {
                    SortedSet<ExecutionTask> proposalsForBroker = this.interPartMoveTaskByBrokerId.get(sourceBroker);
                    if (proposalsForBroker == null) continue;
                    HashSet<ExecutionTask> completedTasks = new HashSet<ExecutionTask>();
                    block2: for (ExecutionTask task : proposalsForBroker) {
                        if (task.partitionProposal().isLeadershipShuffle()) {
                            executableReplicaMovements.add(task);
                            completedTasks.add(task);
                            LOG.debug("Found ready task leadership-shuffle {} for broker {}. Broker concurrency state: {}", new Object[]{task, sourceBroker, brokerExecutionTracker});
                            continue;
                        }
                        if (task.partitionProposal().completed()) {
                            completedTasks.add(task);
                            continue;
                        }
                        for (ReplicaId destination : task.partitionProposal().replicasToAdd()) {
                            if (task.partitionProposal().replicasAdded().contains(destination) || involvedPartitions.contains(task.partitionProposal().topicPartition()) || inProgressPartitions.contains(task.partitionProposal().topicPartition()) || involvedBrokers.contains(sourceBroker) || involvedBrokers.contains(destination.brokerId()) || brokerExecutionTracker.wouldOverloadBrokerAsSource(sourceBroker) || brokerExecutionTracker.wouldOverloadBrokerAsDestination(destination.brokerId())) continue;
                            newTaskAdded = true;
                            task.partitionProposal().proposeReplicaToAdd(destination);
                            ArrayList<ReplicaId> replicasToRemove = new ArrayList<ReplicaId>(task.partitionProposal().replicasToRemove());
                            Collections.reverse(replicasToRemove);
                            for (ReplicaId replicaToRemove : replicasToRemove) {
                                if (task.partitionProposal().replicasRemoved().contains(replicaToRemove)) continue;
                                task.partitionProposal().proposeReplicaToRemove(replicaToRemove);
                            }
                            executableReplicaMovements.add(task);
                            involvedBrokers.add(sourceBroker);
                            involvedBrokers.add(destination.brokerId());
                            involvedPartitions.add(task.partitionProposal().topicPartition());
                            brokerExecutionTracker.addTaskForBrokerAsSource(sourceBroker);
                            brokerExecutionTracker.addTaskForBrokerAsDestination(destination.brokerId());
                            LOG.info("Found ready task new-replica {} for broker {}. Broker concurrency state: {}", new Object[]{task, sourceBroker, brokerExecutionTracker});
                            continue block2;
                        }
                    }
                    for (ExecutionTask completedTask : completedTasks) {
                        proposalsForBroker.remove(completedTask);
                    }
                }
            }
            return executableReplicaMovements;
        }
        boolean newTaskAdded = true;
        HashSet<Integer> brokerInvolved = new HashSet<Integer>();
        HashSet<TopicPartition> partitionsInvolved = new HashSet<TopicPartition>();
        while (newTaskAdded) {
            newTaskAdded = false;
            brokerInvolved.clear();
            block7: for (Integer sourceBroker : brokerExecutionTracker.knownBrokers()) {
                if (brokerInvolved.contains(sourceBroker)) continue;
                SortedSet<ExecutionTask> proposalsForBroker = this.interPartMoveTaskByBrokerId.get(sourceBroker);
                LOG.trace("Execution task for broker {} are {}", (Object)sourceBroker, proposalsForBroker);
                if (proposalsForBroker == null) continue;
                for (ExecutionTask task : proposalsForBroker) {
                    LOG.trace("Considering execution task {} for broker {}", (Object)task, (Object)sourceBroker);
                    Set<Integer> destinationBrokers = task.partitionProposal().replicasToAdd().stream().mapToInt(ReplicaId::brokerId).boxed().collect(Collectors.toSet());
                    if (brokerInvolved.contains(sourceBroker) || KafkaCruiseControlUtils.containsAny(brokerInvolved, destinationBrokers)) {
                        LOG.trace("Skipping execution task {} because either the source or the destination brokers were already involved in the generated proposals", (Object)task);
                        continue;
                    }
                    TopicPartition tp = task.partitionProposal().topicPartition();
                    boolean isExecutable = this.isExecutableTask(task, brokerExecutionTracker);
                    boolean isPartitionInProgress = inProgressPartitions.contains(tp);
                    boolean isPartitionInvolved = partitionsInvolved.contains(tp);
                    if (isExecutable && !isPartitionInProgress && !isPartitionInvolved) {
                        partitionsInvolved.add(tp);
                        executableReplicaMovements.add(task);
                        brokerInvolved.add(sourceBroker);
                        brokerInvolved.addAll(destinationBrokers);
                        proposalsForBroker.remove(task);
                        int nSourceSlots = task.requiredParallelism();
                        brokerExecutionTracker.addTaskForBroker(sourceBroker, nSourceSlots);
                        for (int broker : destinationBrokers) {
                            brokerExecutionTracker.addTaskForBroker(broker, 1);
                        }
                        newTaskAdded = true;
                        LOG.debug("Found ready task {} for broker {}. Broker concurrency state: {}", new Object[]{task, sourceBroker, brokerExecutionTracker});
                        continue block7;
                    }
                    LOG.trace("Skipped execution task {} - isExecutable: {}, isPartitionInProgress: {}, isPartitionInvolved: {}", new Object[]{task, isExecutable, isPartitionInProgress, isPartitionInvolved});
                }
            }
        }
        LOG.trace("Generated {} inter-broker replica movement tasks for brokers with concurrency {}", (Object)executableReplicaMovements.size(), (Object)brokerExecutionTracker);
        return executableReplicaMovements;
    }

    public void clear() {
        this.interPartMoveTaskByBrokerId.clear();
        this.remainingLeadershipMovements.clear();
    }

    private boolean isExecutableTask(ExecutionTask task, BrokerExecutionTaskTracker brokerExecutionTracker) {
        int nSimultaneousMoves = task.requiredParallelism();
        if (brokerExecutionTracker.wouldOverloadBroker(task.partitionProposal().oldLeader().brokerId(), nSimultaneousMoves)) {
            return false;
        }
        for (ReplicaId destinationBroker : task.partitionProposal().replicasToAdd()) {
            if (!brokerExecutionTracker.wouldOverloadBroker(destinationBroker.brokerId(), 1)) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, SortedSet<ExecutionTask>> orderInterBrokerReplicaMovementTasks(Set<ExecutionTask> tasks, Cluster cluster) {
        return this.defaultReplicaMovementTaskStrategy.applyStrategy(tasks, cluster);
    }
}

