/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.SbcClusterSnapshot;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionTracker.class);
    private final SbkAdminUtils adminUtils;
    private final ExecutionTaskManager executionTaskManager;
    public long leaderActionTimeoutMs;
    private final long statusCheckingIntervalMs;
    private final Time time;
    private final MetadataClient metadataClient;
    private final AtomicBoolean stopRequested;
    public long executorDeadTaskCheckTimeoutMs;
    private final boolean isV2ExecutorEnabled;

    public ExecutionTracker(ExecutionTaskManager executionTaskManager, MetadataClient metadataClient, AtomicBoolean stopRequested, Time time, long leaderActionTimeoutMs, long executorDeadTaskTimeoutMs, long statusCheckingIntervalMs, SbkAdminUtils adminUtils, boolean isV2ExecutorEnabled) {
        this.executionTaskManager = executionTaskManager;
        this.metadataClient = metadataClient;
        this.stopRequested = stopRequested;
        this.time = time;
        this.leaderActionTimeoutMs = leaderActionTimeoutMs;
        this.executorDeadTaskCheckTimeoutMs = executorDeadTaskTimeoutMs;
        this.statusCheckingIntervalMs = statusCheckingIntervalMs;
        this.adminUtils = adminUtils;
        this.isV2ExecutorEnabled = isV2ExecutorEnabled;
    }

    public List<ExecutionTask> waitForAnyExecutionTaskToFinish() {
        ArrayList<ExecutionTask> finishedTasks = new ArrayList<ExecutionTask>();
        boolean anyTaskFinished = false;
        boolean inExecutionTasksPresent = true;
        do {
            try {
                Thread.sleep(this.statusCheckingIntervalMs);
            }
            catch (InterruptedException e) {
                LOG.warn("The execution thread got interrupted during the execution.progress.check.interval.ms check", (Throwable)e);
            }
            finishedTasks.addAll(this.collectFinishedExecutionTasks());
            anyTaskFinished = !finishedTasks.isEmpty();
            boolean bl = inExecutionTasksPresent = !this.executionTaskManager.inExecutionTasks().isEmpty();
        } while (inExecutionTasksPresent && !anyTaskFinished);
        return finishedTasks;
    }

    List<ExecutionTask> collectFinishedExecutionTasks() {
        boolean cancelRequested;
        ArrayList<ExecutionTask> finishedTasks = new ArrayList<ExecutionTask>();
        Set<ExecutionTask> inExecutionTasks = this.executionTaskManager.inExecutionTasks();
        boolean checkForOfflineBrokers = false;
        Set<TopicPartition> reassigningPartitions = this.adminUtils.listTargetReplicasBeingReassigned(Optional.empty()).keySet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tasks in execution: {}, Ongoing reassigning partitions: {}", inExecutionTasks, reassigningPartitions);
        }
        if (cancelRequested = this.stopRequested.get()) {
            LOG.info("User initiated a cancellation of all ongoing tasks.");
        }
        for (ExecutionTask task : inExecutionTasks) {
            boolean isTaskDone;
            TopicPartition tp = task.partitionProposal().topicPartition();
            boolean bl = isTaskDone = !reassigningPartitions.contains(tp);
            if (isTaskDone) {
                if (this.isV2ExecutorEnabled) {
                    if (task.type() == ExecutionTask.TaskType.LEADER_ACTION || task.partitionProposal().isLeadershipShuffle()) {
                        this.executionTaskManager.markTaskDone(task);
                    } else if (task.partitionProposal().wouldCompleteAfterCurrentReassignment()) {
                        this.executionTaskManager.markTaskDone(task);
                        task.partitionProposal().finishAddingReplica();
                    } else {
                        this.executionTaskManager.markTaskBackAsPendingAfterIntermediateSuccess(task);
                        task.partitionProposal().finishAddingReplica();
                    }
                } else {
                    this.executionTaskManager.markTaskDone(task);
                }
                finishedTasks.add(task);
                continue;
            }
            if (this.checkIfCancelRequestedOrLeadershipTimeoutOccurs(task, cancelRequested)) {
                this.executionTaskManager.markTaskDead(task);
                finishedTasks.add(task);
                continue;
            }
            if (this.time.milliseconds() <= task.startTime() + this.executorDeadTaskCheckTimeoutMs) continue;
            checkForOfflineBrokers = true;
        }
        if (checkForOfflineBrokers) {
            SbcClusterSnapshot sbcClusterSnapshot;
            inExecutionTasks = this.executionTaskManager.inExecutionTasks();
            Set<String> topicNames = inExecutionTasks.stream().map(x -> x.partitionProposal().topic()).collect(Collectors.toSet());
            try {
                Optional<SbcClusterSnapshot> clusterSnapshotResult = this.metadataClient.fetchSbcClusterSnapshot(topicNames);
                if (!clusterSnapshotResult.isPresent()) {
                    return finishedTasks;
                }
                sbcClusterSnapshot = clusterSnapshotResult.get();
            }
            catch (InterruptedException e) {
                LOG.warn("The execution thread has been interrupted while trying to retrieve the cluster state to log progress on these tasks: {}", inExecutionTasks);
                return finishedTasks;
            }
            Map<Integer, Node> nodesById = sbcClusterSnapshot.nodes().stream().collect(Collectors.toMap(Node::id, Function.identity()));
            for (ExecutionTask task : inExecutionTasks) {
                TopicPartition tp = task.partitionProposal().topicPartition();
                PartitionInfo partitionInfo = sbcClusterSnapshot.partitionsByTopicPartition().get(tp);
                if (partitionInfo == null) {
                    LOG.debug("Task {} is marked as finished because the topic has been deleted", (Object)task);
                    finishedTasks.add(task);
                    this.executionTaskManager.markTaskAborting(task);
                    this.executionTaskManager.markTaskDone(task);
                    continue;
                }
                if (!this.shouldTaskBeTerminated(nodesById, task)) continue;
                this.executionTaskManager.markTaskDead(task);
                finishedTasks.add(task);
            }
        }
        return finishedTasks;
    }

    private boolean shouldTaskBeTerminated(Map<Integer, Node> nodesById, ExecutionTask task) {
        if (this.checkIfCancelRequestedOrLeadershipTimeoutOccurs(task, false)) {
            return true;
        }
        if (task.state() == ExecutionTask.State.IN_PROGRESS || task.state() == ExecutionTask.State.ABORTING) {
            switch (task.type()) {
                case LEADER_ACTION: {
                    if (nodesById.get(task.partitionProposal().newLeader().brokerId()) != null) break;
                    LOG.warn("Killing execution for task {} because the target leader is down", (Object)task);
                    return true;
                }
                case INTER_BROKER_REPLICA_ACTION: {
                    for (ReplicaId broker : task.partitionProposal().newReplicas()) {
                        if (nodesById.get(broker.brokerId()) != null) continue;
                        LOG.warn("Killing execution for task {} because the new replica to be added {} is down.", (Object)task, (Object)broker);
                        return true;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown task type " + (Object)((Object)task.type()));
                }
            }
        }
        return false;
    }

    private boolean checkIfCancelRequestedOrLeadershipTimeoutOccurs(ExecutionTask task, boolean cancelRequested) {
        if (cancelRequested && task.state() == ExecutionTask.State.IN_PROGRESS) {
            LOG.info("Cancelling task {}", (Object)task);
            return true;
        }
        if (task.type() == ExecutionTask.TaskType.LEADER_ACTION && (task.state() == ExecutionTask.State.IN_PROGRESS || task.state() == ExecutionTask.State.ABORTING)) {
            if (this.time.milliseconds() > task.startTime() + this.leaderActionTimeoutMs) {
                LOG.warn("Failed task {} because it took longer than {} to finish.", (Object)task, (Object)this.leaderActionTimeoutMs);
                return true;
            }
            LOG.info("Evaluating timeout of start: {} now: {} timeout: {}", new Object[]{task.startTime(), this.time.milliseconds(), this.leaderActionTimeoutMs});
        }
        return false;
    }
}

