/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.model.Tenant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TenantProposal {
    private static final String TENANT = "tenant";
    private static final String OLD_CELL_ID = "oldCellId";
    private static final String NEW_CELL_ID = "newCellId";
    private final Tenant tenant;
    private final int oldCellId;
    private final int newCellId;

    public TenantProposal(Tenant tenant, int oldCellId, int newCellId) {
        this.tenant = tenant;
        this.oldCellId = oldCellId;
        this.newCellId = newCellId;
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>(4);
        proposalMap.put(TENANT, this.tenant);
        proposalMap.put(OLD_CELL_ID, this.oldCellId);
        proposalMap.put(NEW_CELL_ID, this.newCellId);
        return proposalMap;
    }

    public Tenant tenant() {
        return this.tenant;
    }

    public int oldCellId() {
        return this.oldCellId;
    }

    public int newCellId() {
        return this.newCellId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantProposal)) {
            return false;
        }
        TenantProposal that = (TenantProposal)o;
        return this.oldCellId == that.oldCellId && this.newCellId == that.newCellId && Objects.equals(this.tenant, that.tenant);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.oldCellId);
        result = 31 * result + Integer.hashCode(this.newCellId);
        result = 31 * result + this.tenant.hashCode();
        return result;
    }

    public String toString() {
        return "TenantProposal{tenant='" + this.tenant + '\'' + ", oldCellId=" + this.oldCellId + ", newCellId=" + this.newCellId + '}';
    }
}

