/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.nio.ByteBuffer;

public class BrokerMetric
extends CruiseControlMetric {
    private BrokerMetric(RawMetricType rawMetricType, long time, int brokerId, float value) {
        super(rawMetricType, time, brokerId, value);
        if (rawMetricType.metricScope() != RawMetricType.MetricScope.BROKER) {
            throw new IllegalArgumentException(String.format("Cannot construct a BrokerMetric for %s whose scope is %s", new Object[]{rawMetricType, rawMetricType.metricScope()}));
        }
    }

    public BrokerMetric(RawMetricType rawMetricType, long time, int brokerId, double value) {
        this(rawMetricType, time, brokerId, (float)value);
    }

    @Override
    public CruiseControlMetric.MetricClassId metricClassId() {
        return CruiseControlMetric.MetricClassId.BROKER_METRIC;
    }

    @Override
    public ByteBuffer toBuffer(int headerPos) {
        ByteBuffer buffer = ByteBuffer.allocate(headerPos + 1 + 1 + 8 + 4 + 8);
        buffer.position(headerPos);
        buffer.put((byte)0);
        buffer.put(this.rawMetricType().id());
        buffer.putLong(this.time());
        buffer.putInt(this.brokerId());
        buffer.putDouble(this.value());
        return buffer;
    }

    static BrokerMetric fromBuffer(ByteBuffer buffer) throws UnknownVersionException {
        byte version = buffer.get();
        if (version > 0) {
            throw new UnknownVersionException("Cannot deserialize the topic metrics for version " + version + ". Current version is " + 0);
        }
        RawMetricType rawMetricType = RawMetricType.forId(buffer.get());
        long time = buffer.getLong();
        int brokerId = buffer.getInt();
        double value = buffer.getDouble();
        return new BrokerMetric(rawMetricType, time, brokerId, value);
    }

    @Override
    public String toString() {
        return String.format("[%s,%s,time=%d,brokerId=%d,value=%.3f]", new Object[]{CruiseControlMetric.MetricClassId.BROKER_METRIC, this.rawMetricType(), this.time(), this.brokerId(), this.value()});
    }
}

