/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import java.util.HashMap;
import java.util.Map;

public class DiskStats {
    private final int numLeaderReplicas;
    private final int numReplicas;
    private final Double utilization;
    private final double capacity;
    private static final String DISK_MB = "DiskMB";
    private static final String DISK_PCT = "DiskPct";
    private static final String NUM_LEADER_REPLICAS = "NumLeaderReplicas";
    private static final String NUM_REPLICAS = "NumReplicas";
    private static final String DEAD_STATE = "DEAD";

    DiskStats(int numLeaderReplicas, int numReplicas, double utilization, double capacity) {
        this.numLeaderReplicas = numLeaderReplicas;
        this.numReplicas = numReplicas;
        this.utilization = capacity > 0.0 ? Double.valueOf(utilization) : null;
        this.capacity = capacity;
    }

    public int numLeaderReplicas() {
        return this.numLeaderReplicas;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public Double utilization() {
        return this.utilization;
    }

    public double capacity() {
        return this.capacity;
    }

    public Double utilizationPercentage() {
        return this.utilization == null ? null : Double.valueOf(this.utilization * 100.0 / this.capacity);
    }

    public Map<String, Object> getJSONStructure() {
        HashMap<String, Object> entry = new HashMap<String, Object>(4);
        entry.put(DISK_MB, this.utilization == null ? DEAD_STATE : this.utilization);
        entry.put(DISK_PCT, this.utilization == null ? DEAD_STATE : this.utilizationPercentage());
        entry.put(NUM_LEADER_REPLICAS, this.numLeaderReplicas);
        entry.put(NUM_REPLICAS, this.numReplicas);
        return entry;
    }
}

