/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;

public class SortedReplicas {
    private final Broker broker;
    private final Disk disk;
    private final Map<Replica, ReplicaWrapper> replicaWrapperMap;
    private final NavigableSet<ReplicaWrapper> sortedReplicas;
    private final Function<Replica, Boolean> selectionFunc;
    private final Function<Replica, Integer> priorityFunc;
    private final Function<Replica, Double> scoreFunc;
    private boolean initialized;

    SortedReplicas(Broker broker, Function<Replica, Boolean> selectionFunc, Function<Replica, Integer> priorityFunction, Function<Replica, Double> scoreFunction) {
        this(broker, null, selectionFunc, priorityFunction, scoreFunction, true);
    }

    SortedReplicas(Broker broker, Disk disk, Function<Replica, Boolean> selectionFunc, Function<Replica, Integer> priorityFunc, Function<Replica, Double> scoreFunc, boolean initialize) {
        this.broker = broker;
        this.disk = disk;
        this.sortedReplicas = new TreeSet<ReplicaWrapper>();
        this.replicaWrapperMap = new HashMap<Replica, ReplicaWrapper>();
        this.selectionFunc = selectionFunc;
        this.scoreFunc = scoreFunc;
        this.priorityFunc = priorityFunc;
        this.initialized = !initialize;
    }

    public NavigableSet<ReplicaWrapper> sortedReplicaWrappers() {
        this.ensureInitialize();
        return Collections.unmodifiableNavigableSet(this.sortedReplicas);
    }

    public List<Replica> sortedReplicas() {
        this.ensureInitialize();
        ArrayList<Replica> result = new ArrayList<Replica>(this.sortedReplicas.size());
        this.sortedReplicas.forEach(rw -> result.add(rw.replica()));
        return result;
    }

    public List<Replica> reverselySortedReplicas() {
        Iterator<ReplicaWrapper> reverseIter = this.reverselySortedIterator();
        ArrayList<Replica> result = new ArrayList<Replica>(this.sortedReplicas.size());
        while (reverseIter.hasNext()) {
            result.add(reverseIter.next().replica());
        }
        return result;
    }

    public Iterator<ReplicaWrapper> reverselySortedIterator() {
        this.ensureInitialize();
        return this.sortedReplicas.descendingIterator();
    }

    public Function<Replica, Boolean> selectionFunction() {
        return this.selectionFunc;
    }

    public Function<Replica, Integer> priorityFunction() {
        return this.priorityFunc;
    }

    public void add(Replica replica) {
        if (this.initialized && (this.selectionFunc == null || this.selectionFunc.apply(replica).booleanValue())) {
            double score = this.scoreFunc.apply(replica);
            ReplicaWrapper rw = new ReplicaWrapper(replica, score, this.priorityFunc);
            this.add(rw);
        }
    }

    void remove(Replica replica) {
        ReplicaWrapper rw;
        if (this.initialized && (rw = this.replicaWrapperMap.remove(replica)) != null) {
            this.sortedReplicas.remove(rw);
        }
    }

    int numReplicas() {
        return this.sortedReplicas.size();
    }

    private void ensureInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.disk != null) {
                this.disk.replicas().forEach(this::add);
            } else {
                this.broker.replicas().forEach(this::add);
            }
        }
    }

    private void add(ReplicaWrapper rw) {
        ReplicaWrapper old = this.replicaWrapperMap.put(rw.replica(), rw);
        if (old != null) {
            this.sortedReplicas.remove(old);
        }
        this.sortedReplicas.add(rw);
    }
}

