/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;

public class TopicImbalanceScore {
    private double replicaDistributionBased = Double.MAX_VALUE;
    private double partitionDistributionBased = Double.MAX_VALUE;

    public Double getImbalanceScore(TopicImbalanceScoreType imbalanceScoreType) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                return this.replicaDistributionBased;
            }
            case PARTITION_DISTRIBUTION_BASED: {
                return this.partitionDistributionBased;
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + (Object)((Object)imbalanceScoreType) + " provided.");
    }

    public void setImbalanceScore(Double score, TopicImbalanceScoreType imbalanceScoreType) {
        switch (imbalanceScoreType) {
            case REPLICA_DISTRIBUTION_BASED: {
                this.replicaDistributionBased = score;
                return;
            }
            case PARTITION_DISTRIBUTION_BASED: {
                this.partitionDistributionBased = score;
                return;
            }
        }
        throw new IllegalArgumentException("UnSupported imbalance score type " + (Object)((Object)imbalanceScoreType) + " provided.");
    }
}

