/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model.util;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Comparator;

public class ReplicaByResourceUtilizationComparator
implements Comparator<Replica> {
    private final Resource resource;

    private ReplicaByResourceUtilizationComparator(Resource resource) {
        this.resource = resource;
    }

    public static ReplicaByResourceUtilizationComparator of(Resource resource) {
        return new ReplicaByResourceUtilizationComparator(resource);
    }

    @Override
    public int compare(Replica replica1, Replica replica2) {
        boolean isR1Offline = replica1.isCurrentOffline();
        boolean isR2Offline = replica2.isCurrentOffline();
        if (isR1Offline && !isR2Offline) {
            return -1;
        }
        if (!isR1Offline && isR2Offline) {
            return 1;
        }
        double resourceUtilizationOnReplica1 = replica1.load().expectedUtilizationFor(this.resource);
        double resourceUtilizationOnReplica2 = replica2.load().expectedUtilizationFor(this.resource);
        int result = Double.compare(resourceUtilizationOnReplica2, resourceUtilizationOnReplica1);
        if (result == 0) {
            result = replica1.compareTo(replica2);
        }
        return result;
    }
}

