/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.monitor.BasicStats;
import com.linkedin.kafka.cruisecontrol.monitor.SingleBrokerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class BrokerStats {
    protected static final String HOST = "Host";
    protected static final String HOSTS = "hosts";
    protected static final String BROKERS = "brokers";
    protected final List<SingleBrokerStats> brokerStats = new ArrayList<SingleBrokerStats>();
    protected final SortedMap<String, BasicStats> hostStats = new ConcurrentSkipListMap<String, BasicStats>();
    protected int hostFieldLength = 0;
    protected int logdirFieldLength = 1;
    protected boolean isBrokerStatsEstimated = false;

    public BrokerStats(KafkaCruiseControlConfig config) {
    }

    public void addSingleBrokerStats(String host, int id, Broker.Strategy strategy, double diskUtil, double cpuUtil, double leaderBytesInRate, double followerBytesInRate, double bytesOutRate, double potentialBytesOutRate, int numReplicas, int numLeaders, boolean isEstimated, double capacity) {
        SingleBrokerStats singleBrokerStats = new SingleBrokerStats(host, id, strategy, diskUtil, cpuUtil, leaderBytesInRate, followerBytesInRate, bytesOutRate, potentialBytesOutRate, numReplicas, numLeaders, isEstimated, capacity);
        this.brokerStats.add(singleBrokerStats);
        this.hostFieldLength = Math.max(this.hostFieldLength, host.length());
        this.hostStats.computeIfAbsent(host, h -> new BasicStats(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0.0)).addBasicStats(singleBrokerStats.basicStats());
        this.isBrokerStatsEstimated = this.isBrokerStatsEstimated || isEstimated;
    }

    public boolean isBrokerStatsEstimated() {
        return this.isBrokerStatsEstimated;
    }

    public Map<String, Object> getJsonStructure() {
        ArrayList<Map<String, Object>> hostStats = new ArrayList<Map<String, Object>>(this.hostStats.size());
        for (Map.Entry<String, BasicStats> entry : this.hostStats.entrySet()) {
            Map<String, Object> hostEntry = entry.getValue().getJSONStructure();
            hostEntry.put(HOST, entry.getKey());
            hostStats.add(hostEntry);
        }
        ArrayList<Map<String, Object>> brokerStats = new ArrayList<Map<String, Object>>(this.brokerStats.size());
        for (SingleBrokerStats stats : this.brokerStats) {
            Map<String, Object> brokerEntry = stats.getJSONStructure();
            brokerStats.add(brokerEntry);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(HOSTS, hostStats);
        hashMap.put(BROKERS, brokerStats);
        return hashMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n%n%" + this.hostFieldLength + "s%15s%" + this.logdirFieldLength + "s%26s%15s%25s%25s%20s%20s%20s%25s%n", "HOST", "BROKER", "", "DISK(MB)/_(%)_", "CPU(%)", "LEADER_NW_IN(KB/s)", "FOLLOWER_NW_IN(KB/s)", "NW_OUT(KB/s)", "PNW_OUT(KB/s)", "LEADERS/REPLICAS", "REPLICATION_IN(Kb/s)"));
        for (SingleBrokerStats stats : this.brokerStats) {
            sb.append(String.format("%" + this.hostFieldLength + "s,%14d,%" + this.logdirFieldLength + "s%19.3f/%05.2f,%14.3f,%24.3f,%24.3f,%19.3f,%19.3f,%14d/%d,%24.3f%n", stats.host(), stats.id(), "", stats.basicStats().diskUtil(), stats.basicStats().diskUtilPct(), stats.basicStats().cpuUtil(), stats.basicStats().leaderBytesInRate(), stats.basicStats().followerBytesInRate(), stats.basicStats().bytesOutRate(), stats.basicStats().potentialBytesOutRate(), stats.basicStats().numLeaders(), stats.basicStats().numReplicas(), stats.basicStats().followerBytesInRate()));
        }
        return sb.toString();
    }

    public List<SingleBrokerStats> stats() {
        return this.brokerStats;
    }
}

