/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import io.confluent.cruisecontrol.analyzer.goals.AbstractAcceptanceGoal;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxReplicaMovementParallelismGoal
extends AbstractAcceptanceGoal {
    private static final Logger LOG = LoggerFactory.getLogger(MaxReplicaMovementParallelismGoal.class);
    private int maxInterBrokerConcurrency;

    public MaxReplicaMovementParallelismGoal() {
    }

    public MaxReplicaMovementParallelismGoal(BalancingConstraint balancingConstraint) {
        this.balancingConstraint = balancingConstraint;
    }

    @Override
    public void configure(KafkaCruiseControlConfig kccConfig) {
        super.configure(kccConfig);
        this.maxInterBrokerConcurrency = kccConfig.getInt("num.concurrent.partition.movements.per.broker");
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: {
                List<Replica> replicas = clusterModel.partition(action.topicPartition()).replicas();
                if (replicas.stream().filter(Replica::isImmigrant).count() >= (long)this.maxInterBrokerConcurrency) {
                    return ActionAcceptance.BROKER_REJECT;
                }
                return ActionAcceptance.ACCEPT;
            }
        }
        throw new IllegalArgumentException("Balancing action " + (Object)((Object)action.balancingAction()) + " is not supported");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        Set<Replica> replicas = action.replicaMoves().keySet();
        if (replicas.size() > this.maxInterBrokerConcurrency) {
            LOG.error("Replication factor of partition is more than maximum allowed concurrency. Unable to move partition: {}, replication factor: {}", (Object)action.topicPartition(), (Object)action.replicaMoves().size());
            return ActionAcceptance.BROKER_REJECT;
        }
        return ActionAcceptance.ACCEPT;
    }

    @Override
    public String name() {
        return MaxReplicaMovementParallelismGoal.class.getSimpleName();
    }
}

