/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import com.linkedin.kafka.cruisecontrol.model.Tenant;
import io.confluent.cruisecontrol.analyzer.history.EntityMovement;
import io.confluent.cruisecontrol.analyzer.history.EntityMovementHistoryListener;
import io.confluent.cruisecontrol.analyzer.history.SuspendedTenant;
import io.confluent.cruisecontrol.analyzer.history.SuspendedTopicPartition;
import io.confluent.cruisecontrol.analyzer.history.TenantMovement;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import io.confluent.databalancer.utils.TableGenerator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EntityMovementLogger {
    private static final TableGenerator DEFAULT_TABLE_GENERATOR = new TableGenerator();
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(EntityMovementLogger.class);
    private static final List<String> HEADERS_LIST = Arrays.asList("TIMESTAMP", "TOPIC", "PARTITION", "BALANCE_EPOCH", "SRC", "DST", "GOAL", "REASON");
    private static final List<String> TENANT_HEADERS_LIST = Arrays.asList("TIMESTAMP", "TENANT", "BALANCE_EPOCH", "SRC", "DST", "GOAL", "REASON");
    private final TableGenerator tableGenerator;
    private final Logger log;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private long epoch = 0L;
    @GuardedBy(value="lock")
    private final Map<Long, Map<TopicPartition, SortedSet<TopicPartitionMovement>>> topicPartitionMovementsByEpoch = new HashMap<Long, Map<TopicPartition, SortedSet<TopicPartitionMovement>>>();
    @GuardedBy(value="lock")
    private final Map<Long, Map<Tenant, SortedSet<TenantMovement>>> tenantMovementsByEpoch = new HashMap<Long, Map<Tenant, SortedSet<TenantMovement>>>();

    public EntityMovementLogger() {
        this(DEFAULT_TABLE_GENERATOR, DEFAULT_LOGGER);
    }

    EntityMovementLogger(TableGenerator tableGenerator, Logger log) {
        this.tableGenerator = tableGenerator;
        this.log = log;
    }

    public EntityMovementHistoryListener<TopicPartitionMovement> topicPartitionMovementListener() {
        return new EntityMovementHistoryListener<TopicPartitionMovement>(){

            @Override
            public void onNewHistory(TopicPartitionMovement entityHistory) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTopicPartitionMovement(entityHistory, Operation.ADD);
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }

            @Override
            public void onExpiredHistory(TopicPartitionMovement entityHistory) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTopicPartitionMovement(entityHistory, Operation.REMOVE);
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }

            private void addOrRemoveTopicPartitionMovement(TopicPartitionMovement topicPartitionMovement, Operation operation) {
                long tpEpoch = topicPartitionMovement.epoch();
                TopicPartition tp = (TopicPartition)topicPartitionMovement.entity();
                if (EntityMovementLogger.this.epoch <= tpEpoch) {
                    SortedSet topicPartitionMovements = EntityMovementLogger.this.topicPartitionMovements(tpEpoch, tp);
                    switch (operation) {
                        case ADD: {
                            topicPartitionMovements.add(topicPartitionMovement);
                            break;
                        }
                        case REMOVE: {
                            topicPartitionMovements.remove(topicPartitionMovement);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Only ADD and REMOVE are the valid Operations");
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdatedEpoch(long newEpoch) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    if (EntityMovementLogger.this.epoch < newEpoch) {
                        long oldEpoch = EntityMovementLogger.this.epoch;
                        EntityMovementLogger.this.epoch = newEpoch;
                        EntityMovementLogger.this.topicPartitionMovementsByEpoch.remove(oldEpoch);
                    }
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }
        };
    }

    public EntityMovementHistoryListener<TenantMovement> tenantMovementListener() {
        return new EntityMovementHistoryListener<TenantMovement>(){

            @Override
            public void onNewHistory(TenantMovement entityHistory) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTenantMovement(entityHistory, Operation.ADD);
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }

            @Override
            public void onExpiredHistory(TenantMovement entityHistory) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    this.addOrRemoveTenantMovement(entityHistory, Operation.REMOVE);
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }

            private void addOrRemoveTenantMovement(TenantMovement tenantMovement, Operation operation) {
                long tenantEpoch = tenantMovement.epoch();
                Tenant tenant = (Tenant)tenantMovement.entity();
                if (EntityMovementLogger.this.epoch <= tenantEpoch) {
                    SortedSet tenantMovements = EntityMovementLogger.this.tenantMovements(tenantEpoch, tenant);
                    switch (operation) {
                        case ADD: {
                            tenantMovements.add(tenantMovement);
                            break;
                        }
                        case REMOVE: {
                            tenantMovements.remove(tenantMovement);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Only ADD and REMOVE are the valid Operations");
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdatedEpoch(long newEpoch) {
                EntityMovementLogger.this.lock.writeLock().lock();
                try {
                    if (EntityMovementLogger.this.epoch < newEpoch) {
                        long oldEpoch = EntityMovementLogger.this.epoch;
                        EntityMovementLogger.this.epoch = newEpoch;
                        EntityMovementLogger.this.tenantMovementsByEpoch.remove(oldEpoch);
                    }
                }
                finally {
                    EntityMovementLogger.this.lock.writeLock().unlock();
                }
            }
        };
    }

    public EntityMovementHistoryListener<SuspendedTopicPartition> suspendedTopicPartitionListener() {
        return new EntityMovementHistoryListener<SuspendedTopicPartition>(){

            @Override
            public void onNewHistory(SuspendedTopicPartition entityHistory) {
                long tpEpoch = entityHistory.epoch();
                TopicPartition tp = (TopicPartition)entityHistory.entity();
                Optional topicPartitionMovementsOpt = EntityMovementLogger.this.maybeGetTopicPartitionMovement(tpEpoch, tp);
                topicPartitionMovementsOpt.ifPresent(topicPartitionMovements -> {
                    long remainingSuspensionPeriod = entityHistory.untilDeadline(TimeUnit.SECONDS);
                    EntityMovementLogger.this.log.info("Topic Partition {} is suspended for movement due to excessive amount of repeated movements since last successful self-healing/broker addition/broker removal. Remaining suspension period: {} seconds", (Object)tp, (Object)remainingSuspensionPeriod);
                    if (EntityMovementLogger.this.log.isDebugEnabled()) {
                        EntityMovementLogger.this.tableGenerator.generateTable(HEADERS_LIST, EntityMovementLogger.this.topicPartitionMovementsRows(topicPartitionMovements)).ifPresent(arg_0 -> ((Logger)EntityMovementLogger.this.log).debug(arg_0));
                    }
                });
            }

            @Override
            public void onExpiredHistory(SuspendedTopicPartition entityHistory) {
            }

            @Override
            public void onUpdatedEpoch(long newEpoch) {
            }
        };
    }

    public EntityMovementHistoryListener<SuspendedTenant> suspendedTenantListener() {
        return new EntityMovementHistoryListener<SuspendedTenant>(){

            @Override
            public void onNewHistory(SuspendedTenant entityHistory) {
                long tenantEpoch = entityHistory.epoch();
                Tenant tenant = (Tenant)entityHistory.entity();
                Optional tenantMovementsOpt = EntityMovementLogger.this.maybeGetTenantMovement(tenantEpoch, tenant);
                tenantMovementsOpt.ifPresent(tenantMovements -> {
                    long remainingSuspensionPeriod = entityHistory.untilDeadline(TimeUnit.SECONDS);
                    EntityMovementLogger.this.log.info("Tenant {} is suspended for movement due to excessive amount of repeated movements since last successful self-healing/broker addition/broker removal. Remaining suspension period: {} seconds", (Object)tenant, (Object)remainingSuspensionPeriod);
                    if (EntityMovementLogger.this.log.isDebugEnabled()) {
                        EntityMovementLogger.this.tableGenerator.generateTable(TENANT_HEADERS_LIST, EntityMovementLogger.this.tenantMovementsRows(tenantMovements)).ifPresent(arg_0 -> ((Logger)EntityMovementLogger.this.log).debug(arg_0));
                    }
                });
            }

            @Override
            public void onExpiredHistory(SuspendedTenant entityHistory) {
            }

            @Override
            public void onUpdatedEpoch(long newEpoch) {
            }
        };
    }

    private List<List<String>> topicPartitionMovementsRows(Collection<TopicPartitionMovement> topicPartitionMovements) {
        ArrayList rows = new ArrayList();
        for (TopicPartitionMovement tpm : topicPartitionMovements) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(Instant.ofEpochMilli(tpm.timestampMs()).toString());
            row.add(((TopicPartition)tpm.entity()).topic());
            row.add(String.valueOf(((TopicPartition)tpm.entity()).partition()));
            row.add(String.valueOf(tpm.epoch()));
            row.add(String.valueOf(tpm.sourceBroker()));
            row.add(String.valueOf(tpm.destinationBroker()));
            row.add(tpm.proposingGoal().getSimpleName());
            row.add(tpm.movementReason());
            rows.add(Collections.unmodifiableList(row));
        }
        return Collections.unmodifiableList(rows);
    }

    private List<List<String>> tenantMovementsRows(Collection<TenantMovement> tenantMovements) {
        ArrayList rows = new ArrayList();
        for (TenantMovement tem : tenantMovements) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(Instant.ofEpochMilli(tem.timestampMs()).toString());
            row.add(((Tenant)tem.entity()).tenantId());
            row.add(String.valueOf(tem.epoch()));
            row.add(String.valueOf(tem.sourceCell()));
            row.add(String.valueOf(tem.destinationCell()));
            row.add(tem.proposingGoal().getSimpleName());
            row.add(tem.movementReason());
            rows.add(Collections.unmodifiableList(row));
        }
        return Collections.unmodifiableList(rows);
    }

    private SortedSet<TopicPartitionMovement> topicPartitionMovements(long epoch, TopicPartition tp) {
        return this.entityMovements(epoch, tp, this.topicPartitionMovementsByEpoch);
    }

    private SortedSet<TenantMovement> tenantMovements(long epoch, Tenant tenant) {
        return this.entityMovements(epoch, tenant, this.tenantMovementsByEpoch);
    }

    private <E, M extends EntityMovement> SortedSet<M> entityMovements(long epoch, E entity, Map<Long, Map<E, SortedSet<M>>> entityMovementsByEpoch) {
        Map entityMovementsByEntity = entityMovementsByEpoch.computeIfAbsent(epoch, e -> new HashMap());
        return entityMovementsByEntity.computeIfAbsent(entity, t -> new TreeSet());
    }

    private Optional<SortedSet<TopicPartitionMovement>> maybeGetTopicPartitionMovement(long tpEpoch, TopicPartition tp) {
        return this.maybeGetEntityMovement(tpEpoch, tp, this.topicPartitionMovementsByEpoch);
    }

    private Optional<SortedSet<TenantMovement>> maybeGetTenantMovement(long tenantEpoch, Tenant tenant) {
        return this.maybeGetEntityMovement(tenantEpoch, tenant, this.tenantMovementsByEpoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, M extends EntityMovement> Optional<SortedSet<M>> maybeGetEntityMovement(long entityEpoch, K entity, Map<Long, Map<K, SortedSet<M>>> entityMovementsByEpoch) {
        this.lock.readLock().lock();
        try {
            if (this.epoch <= entityEpoch) {
                Optional<SortedSet<M>> optional = Optional.ofNullable(entityMovementsByEpoch.get(this.epoch)).map(tenantMovementMap -> (SortedSet)tenantMovementMap.get(entity)).map(TreeSet::new);
                return optional;
            }
            Optional<SortedSet<M>> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<SortedSet<TopicPartitionMovement>> maybeGetTopicPartitionMovementFromEpoch(long epoch, TopicPartition tp) {
        this.lock.readLock().lock();
        try {
            Optional<SortedSet<TopicPartitionMovement>> optional = Optional.ofNullable(this.topicPartitionMovementsByEpoch.get(epoch)).map(topicPartitionMovementMap -> (SortedSet)topicPartitionMovementMap.get(tp)).map(TreeSet::new);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    long epoch() {
        this.lock.readLock().lock();
        try {
            long l = this.epoch;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void epoch(long newEpoch) {
        this.lock.writeLock().lock();
        try {
            this.epoch = newEpoch;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static enum Operation {
        ADD,
        REMOVE;

    }
}

