/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import com.linkedin.kafka.cruisecontrol.model.Tenant;
import io.confluent.cruisecontrol.analyzer.history.EntityEventHistoryUtils;
import io.confluent.cruisecontrol.analyzer.history.SuspendedEntity;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.utils.Time;

@Immutable
public class SuspendedTenant
extends SuspendedEntity<Tenant>
implements Comparable<SuspendedTenant> {
    public SuspendedTenant(Tenant tenant, long suspensionDurationMs, long epoch) {
        this(Time.SYSTEM, tenant, suspensionDurationMs, epoch);
    }

    SuspendedTenant(Time time, Tenant tenant, long suspensionDurationMs, long epoch) {
        super(time, tenant, suspensionDurationMs, epoch);
    }

    public SuspendedTenant(Object entity, long entityPartitionSuspensionMs, long epoch) {
        this((Tenant)entity, entityPartitionSuspensionMs, epoch);
    }

    @Override
    public String entityId() {
        return ((Tenant)this.entity()).tenantId();
    }

    public String toString() {
        return "SuspendedTenant{tenant=" + this.entity() + ", deadlineMs=" + this.deadlineMs() + ", epoch=" + this.epoch() + '}';
    }

    @Override
    public int compareTo(@Nonnull SuspendedTenant o) {
        return EntityEventHistoryUtils.compareTenantEventHistories(this, o, this.entityId(), o.entityId());
    }
}

