/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BalancerEnabledConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerEnabledConfig.class);
    private boolean isConfiguredEnabled;

    public BalancerEnabledConfig(boolean isEnabled) {
        this.isConfiguredEnabled = isEnabled;
    }

    public synchronized boolean isConfiguredAsEnabled() {
        return this.isConfiguredEnabled;
    }

    public synchronized boolean maybeUpdate(boolean newEnabledValue) {
        if (newEnabledValue == this.isConfiguredEnabled) {
            LOG.trace("Will not update balancer config {} as the supplied values are the same - enabled: {}", (Object)this, (Object)newEnabledValue);
            return false;
        }
        String logMessage = "Changed the configured SBC enabled value";
        boolean oldShouldBeEnabled = this.isConfiguredAsEnabled();
        this.isConfiguredEnabled = newEnabledValue;
        boolean newShouldBeEnabled = this.isConfiguredAsEnabled();
        boolean shouldChange = newShouldBeEnabled != oldShouldBeEnabled;
        logMessage = shouldChange ? logMessage + String.format(" The Balancer should be %s", newShouldBeEnabled) : logMessage + String.format(" The Balancer should still stay as %s", newShouldBeEnabled);
        logMessage = logMessage + String.format(" (%s)", this);
        LOG.info(logMessage);
        return shouldChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalancerEnabledConfig that = (BalancerEnabledConfig)o;
        return this.isConfiguredEnabled == that.isConfiguredEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.isConfiguredEnabled);
    }

    public String toString() {
        return "BalancerEnabledConfig{isEnabled=" + this.isConfiguredEnabled + "}";
    }
}

