/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import io.confluent.databalancer.KafkaDataBalanceManager;
import io.confluent.databalancer.SbcCellLoadEvent;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcAlteredExclusionsEvent;
import io.confluent.databalancer.event.SbcBalancerStatusEvent;
import io.confluent.databalancer.event.SbcBrokerFailureEvent;
import io.confluent.databalancer.event.SbcBrokerHealthChangeEvent;
import io.confluent.databalancer.event.SbcComputeEvenClusterLoadPlanEvent;
import io.confluent.databalancer.event.SbcEvenLoadStatusEvent;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.SbcEventQueue;
import io.confluent.databalancer.event.SbcKRaftScheduleBrokerRemovalEvent;
import io.confluent.databalancer.event.SbcLeaderUpdateEvent;
import io.confluent.databalancer.event.SbcListBrokerAdditionsEvent;
import io.confluent.databalancer.event.SbcListBrokerRemovalsEvent;
import io.confluent.databalancer.event.SbcMetadataUpdateEvent;
import io.confluent.databalancer.event.SbcResignationEvent;
import io.confluent.databalancer.event.SbcShutdownEvent;
import io.confluent.databalancer.event.SbcTriggerEvenClusterLoadEvent;
import io.confluent.databalancer.event.SbcZkBrokerAdditionEvent;
import io.confluent.databalancer.event.SbcZkConfigUpdateEvent;
import io.confluent.databalancer.event.SbcZkScheduleBrokerRemovalEvent;
import io.confluent.databalancer.event.SbcZkStartupEvent;
import io.confluent.databalancer.event.resource.BalancerResourceManager;
import io.confluent.databalancer.event.resource.SbcResourceManager;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.common.AliveBrokersMetadata;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.common.BrokerAdditionDescriptionInternal;
import kafka.common.BrokerRemovalDescriptionInternal;
import kafka.common.CellLoadDescriptionInternal;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.common.TopicsMetadataSnapshot;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.DataBalanceManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbcDataBalanceManager
implements DataBalanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(SbcDataBalanceManager.class);
    private final Logger log;
    private final SbcContext sbcContext;
    private final List<String> manualRebalanceGoalsList = new ArrayList<String>(KafkaCruiseControlConfig.MANUAL_REBALANCE_GOAL_WHITELIST);

    public SbcDataBalanceManager(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpoint) {
        this(kafkaConfig, bootstrapServerEndpoint, SbcDataBalanceManager.metricsRegistryContext());
    }

    private static DataBalancerMetricsRegistry metricsRegistryContext() {
        GeneralSBCMetricsRegistry generalSBCMetricsRegistry = new GeneralSBCMetricsRegistry(KafkaYammerMetrics.defaultRegistry());
        CellOverloadMetrics cellOverloadMetrics = new CellOverloadMetrics(KafkaYammerMetrics.defaultRegistry());
        return DataBalancerMetricsRegistry.builder().dataBalancerMetricsRegistry(generalSBCMetricsRegistry).cellOverloadMetrics(cellOverloadMetrics).build();
    }

    private SbcDataBalanceManager(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpoint, DataBalancerMetricsRegistry dataBalancerMetricsRegistry) {
        this(kafkaConfig, bootstrapServerEndpoint, dataBalancerMetricsRegistry, new SbcEventQueue(dataBalancerMetricsRegistry.dataBalancerMetricsRegistry()), Time.SYSTEM);
    }

    private SbcDataBalanceManager(KafkaConfig kafkaConfig, Optional<Endpoint> bootstrapServerEndpoint, DataBalancerMetricsRegistry dataBalancerMetricsRegistry, SbcEventQueue sbcEventQueue, Time time) {
        this(sbcEventQueue, new SbcResourceManager(sbcEventQueue), new KafkaDataBalanceManager(kafkaConfig, bootstrapServerEndpoint, dataBalancerMetricsRegistry, time), kafkaConfig, time, LOG);
    }

    SbcDataBalanceManager(SbcEventQueue eventQueue, BalancerResourceManager sbcResourceManager, KafkaDataBalanceManager kdbm, KafkaConfig kafkaConfig, Time time, Logger logger) {
        this.sbcContext = new SbcContext(kdbm, eventQueue, sbcResourceManager, kafkaConfig, time);
        this.log = logger;
    }

    public String name() {
        return "SbcDataBalanceManager";
    }

    public void onControllerChange(LeaderAndEpoch leader) {
        SbcLeaderUpdateEvent leaderUpdateEvent = new SbcLeaderUpdateEvent(this.sbcContext, leader.leaderId());
        this.enqueueSbcEvent(leaderUpdateEvent);
    }

    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest loaderManifest) {
        SbcMetadataUpdateEvent metadataImageUpdateEvent = new SbcMetadataUpdateEvent(this.sbcContext, metadataDelta, newMetadataImage);
        this.enqueueSbcEvent(metadataImageUpdateEvent);
    }

    public void close() {
        SbcShutdownEvent shutdownEvent = new SbcShutdownEvent(this.sbcContext);
        this.enqueueSbcEvent(shutdownEvent);
        try {
            this.sbcContext.eventQueue().shutdownQueue();
        }
        catch (InterruptedException ie) {
            this.log.error("SBC EventQueue shutdown did not complete", (Throwable)ie);
        }
    }

    public void scheduleZkBrokerRemoval(List<Integer> brokersToRemove, boolean shouldShutdown, TopicsMetadataSnapshot topicsMetadataSnapshot, AliveBrokersMetadata aliveBrokersMetadata, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        SbcZkScheduleBrokerRemovalEvent removeBrokerEvent = new SbcZkScheduleBrokerRemovalEvent(this.sbcContext, brokersToRemove, shouldShutdown, topicsMetadataSnapshot, aliveBrokersMetadata, cb);
        this.enqueueSbcEvent(removeBrokerEvent);
    }

    public void scheduleKraftBrokerRemoval(List<Integer> brokersToRemove, boolean shouldShutdown, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        SbcKRaftScheduleBrokerRemovalEvent removeBrokerEvent = new SbcKRaftScheduleBrokerRemovalEvent(this.sbcContext, brokersToRemove, shouldShutdown, cb);
        this.enqueueSbcEvent(removeBrokerEvent);
    }

    public void onBrokersStartup(Set<Integer> emptyBrokers, Set<Integer> newBrokers, AliveBrokersMetadata aliveBrokersMetadata) {
        SbcZkBrokerAdditionEvent addBrokersEvent = new SbcZkBrokerAdditionEvent(this.sbcContext, emptyBrokers, newBrokers, aliveBrokersMetadata);
        this.enqueueSbcEvent(addBrokersEvent);
    }

    public void onBrokersFailure(Set<Integer> deadBrokers) {
        SbcBrokerFailureEvent failedBrokersEvent = new SbcBrokerFailureEvent(this.sbcContext, deadBrokers);
        this.enqueueSbcEvent(failedBrokersEvent);
    }

    public void onAlteredExclusions(Set<Integer> newExclusions, Set<Integer> removedExclusions) {
        SbcAlteredExclusionsEvent alteredExclusionsEvent = new SbcAlteredExclusionsEvent(this.sbcContext, newExclusions, removedExclusions);
        this.enqueueSbcEvent(alteredExclusionsEvent);
    }

    public void brokerRemovals(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerRemovalDescriptionInternal>> cb) {
        SbcListBrokerRemovalsEvent listRemovalsEvent = new SbcListBrokerRemovalsEvent(this.sbcContext, cb);
        this.enqueueSbcEvent(listRemovalsEvent);
    }

    public void brokerAdditions(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerAdditionDescriptionInternal>> cb) {
        SbcListBrokerAdditionsEvent listAdditionsEvent = new SbcListBrokerAdditionsEvent(this.sbcContext, cb);
        this.enqueueSbcEvent(listAdditionsEvent);
    }

    public void balancerStatus(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal> cb) {
        SbcBalancerStatusEvent balancerStatusEvent = new SbcBalancerStatusEvent(this.sbcContext, cb);
        this.enqueueSbcEvent(balancerStatusEvent);
    }

    public void evenClusterLoadStatus(ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadStatusDescriptionInternal> cb) {
        SbcEvenLoadStatusEvent evenClusterLoadStatusEvent = new SbcEvenLoadStatusEvent(this.sbcContext, cb);
        this.enqueueSbcEvent(evenClusterLoadStatusEvent);
    }

    public void triggerEvenClusterLoadTask(List<String> goalList, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        if (goalList.isEmpty()) {
            SbcTriggerEvenClusterLoadEvent triggerEvenClusterLoadEvent = new SbcTriggerEvenClusterLoadEvent(goalList, this.sbcContext, cb);
            this.enqueueSbcEvent(triggerEvenClusterLoadEvent);
        } else {
            List invalidGoals = goalList.stream().filter(goal -> !this.manualRebalanceGoalsList.contains(goal)).collect(Collectors.toList());
            if (invalidGoals.isEmpty()) {
                SbcTriggerEvenClusterLoadEvent triggerEvenClusterLoadEvent = new SbcTriggerEvenClusterLoadEvent(goalList, this.sbcContext, cb);
                this.enqueueSbcEvent(triggerEvenClusterLoadEvent);
            } else {
                cb.respond(new ApiError(Errors.INVALID_REQUEST, "SBC cannot trigger rebalance because the following goals are not whitelisted for manual rebalance: " + invalidGoals));
            }
        }
    }

    public void computeEvenClusterLoadPlan(List<String> goalList, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> cb) {
        if (goalList.isEmpty()) {
            SbcComputeEvenClusterLoadPlanEvent computeEvenClusterLoadPlanEvent = new SbcComputeEvenClusterLoadPlanEvent(goalList, this.sbcContext, cb);
            this.enqueueSbcEvent(computeEvenClusterLoadPlanEvent);
        } else {
            List invalidGoals = goalList.stream().filter(goal -> !this.manualRebalanceGoalsList.contains(goal)).collect(Collectors.toList());
            if (invalidGoals.isEmpty()) {
                SbcComputeEvenClusterLoadPlanEvent computeEvenClusterLoadPlanEvent = new SbcComputeEvenClusterLoadPlanEvent(goalList, this.sbcContext, cb);
                this.enqueueSbcEvent(computeEvenClusterLoadPlanEvent);
            } else {
                cb.respond(new ApiError(Errors.INVALID_REQUEST, "SBC cannot trigger rebalance because the following goals are not whitelisted for manual rebalance: " + invalidGoals), Optional.empty());
            }
        }
    }

    public void onBrokerHealthChange(Set<Integer> newlyPromotedBrokers, Set<Integer> newlyDemotedBrokers, AliveBrokersMetadata aliveBrokersMetadata) {
        SbcBrokerHealthChangeEvent brokerHealthChangeEvent = new SbcBrokerHealthChangeEvent(this.sbcContext, newlyPromotedBrokers, newlyDemotedBrokers, aliveBrokersMetadata);
        this.enqueueSbcEvent(brokerHealthChangeEvent);
    }

    public void cellLoad(List<Integer> cellIds, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<CellLoadDescriptionInternal> cb) {
        SbcCellLoadEvent cellLoadEvent = new SbcCellLoadEvent(this.sbcContext, cellIds, cb);
        this.enqueueSbcEvent(cellLoadEvent);
    }

    public void onElection(AliveBrokersMetadata aliveBrokersMetadata) {
        LOG.info("Scheduling SBC Election");
        SbcZkStartupEvent startupEvent = new SbcZkStartupEvent(this.sbcContext, aliveBrokersMetadata);
        this.enqueueSbcEvent(startupEvent);
    }

    public void onResignation() {
        this.log.info("Scheduling SBC Resignation");
        SbcResignationEvent resignationEvent = new SbcResignationEvent(this.sbcContext);
        this.enqueueSbcEvent(resignationEvent);
    }

    public void updateConfig(KafkaConfig oldConfig, KafkaConfig newConfig) {
        SbcZkConfigUpdateEvent configUpdateEvent = new SbcZkConfigUpdateEvent(this.sbcContext, oldConfig, newConfig);
        this.enqueueSbcEvent(configUpdateEvent);
    }

    private void enqueueSbcEvent(SbcEvent newEvent) {
        try {
            this.sbcContext.eventQueue().enqueue(newEvent);
        }
        catch (Exception e) {
            this.log.error("Exception while enqueuing SBC event {}", (Object)newEvent, (Object)e);
        }
    }

    public KafkaDataBalanceManager getKafkaBalanceManager() {
        return this.sbcContext.kafkaDataBalanceManager();
    }
}

