/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.Optional;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.event.Level;

public class SbcBalancerStatusEvent
extends SbcEvent {
    private ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal> cb;

    public SbcBalancerStatusEvent(SbcContext context, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<BalancerStatusDescriptionInternal> cb) {
        super(context);
        this.cb = cb;
    }

    @Override
    protected Level logLevel() {
        return Level.DEBUG;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        return new SbcBalancerStatusResult(this.eventContext.kafkaDataBalanceManager().balancerStatus());
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        Optional<Object> balancerStatusOpt = Optional.ofNullable(result instanceof SbcBalancerStatusResult ? ((SbcBalancerStatusResult)result).balancerStatus : null);
        this.cb.respond(error, balancerStatusOpt);
    }

    private static class SbcBalancerStatusResult
    extends SbcEvent.SbcEventHandlerResult {
        public final BalancerStatusDescriptionInternal balancerStatus;

        public SbcBalancerStatusResult(BalancerStatusDescriptionInternal balancerStatus) {
            this.balancerStatus = balancerStatus;
        }
    }
}

