/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.BrokersMetadataSnapshot;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcAlteredExclusionsEvent;
import io.confluent.databalancer.event.SbcBrokerFailureEvent;
import io.confluent.databalancer.event.SbcBrokerHealthChangeEvent;
import io.confluent.databalancer.event.SbcClusterDelta;
import io.confluent.databalancer.event.SbcConfigUpdateEvent;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.SbcInternalEvent;
import io.confluent.databalancer.event.SbcKraftBrokerAdditionEvent;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.image.BrokerReplicaExclusionsDelta;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.slf4j.event.Level;

public class SbcMetadataUpdateEvent
extends SbcInternalEvent {
    private final MetadataDelta metadataDelta;
    private final MetadataImage newMetadataImage;
    private final List<SbcEvent> followUpEvents = new ArrayList<SbcEvent>();

    public SbcMetadataUpdateEvent(SbcContext context, MetadataDelta metadataDelta, MetadataImage newMetadataImage) {
        super(context);
        this.metadataDelta = metadataDelta;
        this.newMetadataImage = newMetadataImage;
    }

    @Override
    protected Level logLevel() {
        return Level.DEBUG;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        LOG.debug("Balancer received a new Metadata Image");
        if (!this.newMetadataImage.cluster().isEmpty()) {
            this.eventContext.resourceManager().provideResource(SbcResources.CLUSTER_IMAGE, this.newMetadataImage.cluster());
        }
        if (!this.newMetadataImage.topics().isEmpty()) {
            this.eventContext.resourceManager().provideResource(SbcResources.TOPICS_IMAGE, this.newMetadataImage.topics());
        }
        if (!this.newMetadataImage.configs().isEmpty()) {
            this.eventContext.resourceManager().provideResource(SbcResources.CONFIGS_IMAGE, this.newMetadataImage.configs());
        }
        this.eventContext.resourceManager().provideResource(SbcResources.EXCLUSIONS_IMAGE, this.newMetadataImage.brokerReplicaExclusions());
        if (this.metadataDelta != null) {
            if (this.metadataDelta.clusterDelta() != null) {
                LOG.debug("Balancer received a new Cluster Image, delta: {}", (Object)this.metadataDelta.clusterDelta());
                this.handleClusterUpdate(this.metadataDelta.clusterDelta(), this.newMetadataImage);
            }
            if (this.metadataDelta.configsDelta() != null) {
                this.followUpEvents.add(new SbcConfigUpdateEvent(this.eventContext, this.metadataDelta.configsDelta()));
            }
            if (this.metadataDelta.brokerReplicaExclusionsDelta() != null) {
                this.handleExclusionsUpdate(this.metadataDelta.brokerReplicaExclusionsDelta(), this.newMetadataImage.brokerReplicaExclusions());
            }
        }
        return SbcEvent.SbcEventHandlerResult.withFollowUpEvents(this.followUpEvents);
    }

    private void handleExclusionsUpdate(BrokerReplicaExclusionsDelta delta, BrokerReplicaExclusionsImage newImage) {
        try {
            LOG.info("Balancer received a new Replica Exclusions Image (image: {}, delta: {})", (Object)newImage, (Object)delta);
            SbcAlteredExclusionsEvent alteredExclusionsEvent = new SbcAlteredExclusionsEvent(this.eventContext, delta.newExclusions(), delta.removedExclusions());
            alteredExclusionsEvent.run();
        }
        catch (Exception e) {
            LOG.error("Caught an exception trying to handle an broker replica exclusions delta ({}) update", (Object)delta, (Object)e);
        }
    }

    private void handleClusterUpdate(ClusterDelta baseClusterDelta, MetadataImage newMetadataImage) {
        try {
            SbcClusterDelta clusterDelta = new SbcClusterDelta(baseClusterDelta);
            Set<Integer> newBrokers = clusterDelta.newBrokers().stream().map(b -> b.id()).collect(Collectors.toSet());
            Set<Integer> removedBrokers = clusterDelta.removedBrokers();
            Set<Integer> newlyDegradedBrokers = clusterDelta.newlyDegradedBrokers();
            Set<Integer> recoveredBrokers = clusterDelta.newlyRecoveredBrokers();
            if (!newBrokers.isEmpty()) {
                SbcKraftBrokerAdditionEvent newBrokersEvent = new SbcKraftBrokerAdditionEvent(this.eventContext, newBrokers);
                this.followUpEvents.add(newBrokersEvent);
            }
            if (!removedBrokers.isEmpty()) {
                SbcBrokerFailureEvent failedBrokersEvent = new SbcBrokerFailureEvent(this.eventContext, removedBrokers);
                this.followUpEvents.add(failedBrokersEvent);
            }
            if (!newlyDegradedBrokers.isEmpty() || !recoveredBrokers.isEmpty()) {
                BrokersMetadataSnapshot brokersMetadata = BrokersMetadataSnapshot.of(newMetadataImage.cluster().brokers(), newMetadataImage.brokerReplicaExclusions().activeBrokerReplicaExclusions().keySet());
                SbcBrokerHealthChangeEvent newDegradedBrokersEvent = new SbcBrokerHealthChangeEvent(this.eventContext, recoveredBrokers, newlyDegradedBrokers, brokersMetadata);
                this.followUpEvents.add(newDegradedBrokersEvent);
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception trying to handle a cluster delta ({}) update", (Object)baseClusterDelta, (Object)e);
        }
    }
}

