/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event.resource;

import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.SbcEventQueue;
import io.confluent.databalancer.event.resource.BalancerResourceManager;
import io.confluent.databalancer.event.resource.SbcResource;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SbcResourceManager
implements BalancerResourceManager {
    protected static final Logger LOG = LoggerFactory.getLogger(SbcResourceManager.class);
    private Map<SbcResource<?>, Object> resourceValues = new ConcurrentHashMap();
    private Map<SbcResource<?>, Deque<SbcEvent>> resourceWaiters = new ConcurrentHashMap();
    private SbcEventQueue resubmitEventQ;

    public SbcResourceManager(SbcEventQueue resubmitQ) {
        this.resubmitEventQ = resubmitQ;
    }

    @Override
    public synchronized <R> void provideResource(SbcResource<R> resourceId, R resourceValue) {
        LOG.debug("Resource type {} was provided (resource: {})", resourceId, resourceValue);
        this.resourceValues.put(resourceId, resourceValue);
        Deque<SbcEvent> waiters = this.resourceWaiters.remove(resourceId);
        if (waiters != null) {
            waiters.descendingIterator().forEachRemaining(this.resubmitEventQ::prepend);
        }
    }

    @Override
    public synchronized <R> Optional<R> maybeGetResourceValue(SbcResource<R> resourceId) {
        return Optional.ofNullable(resourceId.resourceKlass().cast(this.resourceValues.get(resourceId)));
    }

    @Override
    public synchronized void waitOnResource(SbcResource<?> resourceId, SbcEvent event) {
        if (resourceId == SbcResources.NONE) {
            return;
        }
        this.resourceWaiters.computeIfAbsent(resourceId, k -> new ConcurrentLinkedDeque()).add(event);
    }

    @Override
    public synchronized void clearAllResourcesAndWaiters() {
        this.resourceWaiters.clear();
        this.resourceValues.clear();
    }

    public synchronized Deque<SbcEvent> eventWaiters(SbcResource<?> resourceId) {
        Deque<SbcEvent> eventWaiters = this.resourceWaiters.get(resourceId);
        return eventWaiters == null ? new ArrayDeque<SbcEvent>() : new ArrayDeque<SbcEvent>(eventWaiters);
    }
}

