/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.common.TopicsMetadataSnapshot;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;

public class TopicsImageMetadataSnapshot
implements TopicsMetadataSnapshot {
    private final TopicsImage topicsImage;
    private final List<List<TopicsMetadataSnapshot.PartitionSnapshot>> partitionsByTopics;

    public TopicsImageMetadataSnapshot(TopicsImage topicsImage) {
        this.topicsImage = topicsImage;
        this.partitionsByTopics = topicsImage.topicsByName().entrySet().stream().map(this::snapshotsFromTopicImage).collect(Collectors.toList());
    }

    private List<TopicsMetadataSnapshot.PartitionSnapshot> snapshotsFromTopicImage(Map.Entry<String, TopicImage> topicImageEntry) {
        String topic = topicImageEntry.getKey();
        TopicImage topicImage = topicImageEntry.getValue();
        List snapshots = topicImage.partitions().entrySet().stream().map(partitionEntry -> {
            int partitionId = (Integer)partitionEntry.getKey();
            PartitionRegistration image = (PartitionRegistration)partitionEntry.getValue();
            return new TopicImagePartitionSnapshot(topic, partitionId, image.replicas.length);
        }).collect(Collectors.toList());
        return Collections.unmodifiableList(snapshots);
    }

    public List<List<TopicsMetadataSnapshot.PartitionSnapshot>> partitionsByTopic() {
        return Collections.unmodifiableList(this.partitionsByTopics);
    }

    public Optional<TopicsMetadataSnapshot.ReplicaInfo> partitionInfoSnapshot(TopicsMetadataSnapshot.PartitionSnapshot partitionSnapshot) {
        TopicImage topicImage = (TopicImage)this.topicsImage.topicsByName().get((Object)partitionSnapshot.topic());
        if (topicImage == null) {
            return Optional.empty();
        }
        PartitionRegistration partitionRegistration = (PartitionRegistration)topicImage.partitions().get(partitionSnapshot.partitionId());
        if (partitionRegistration == null) {
            return Optional.empty();
        }
        return Optional.of(new TopicImageReplicaInfo(partitionRegistration));
    }

    private static List<Integer> toList(int[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i : array) {
            list.add(i);
        }
        return list;
    }

    public class TopicImageReplicaInfo
    implements TopicsMetadataSnapshot.ReplicaInfo {
        private final PartitionRegistration partitionRegistration;

        public TopicImageReplicaInfo(PartitionRegistration partitionRegistration) {
            this.partitionRegistration = partitionRegistration;
        }

        public List<Integer> inSyncReplicas() {
            return TopicsImageMetadataSnapshot.toList(this.partitionRegistration.isr);
        }

        public List<Integer> offlineReplicas() {
            List<Integer> isr = this.inSyncReplicas();
            if (this.partitionRegistration.leader == -1 && isr.size() == 1) {
                return this.replicas();
            }
            List<Integer> offlineReplicas = this.replicas();
            offlineReplicas.removeAll(isr);
            return offlineReplicas;
        }

        public List<Integer> replicas() {
            return TopicsImageMetadataSnapshot.toList(this.partitionRegistration.replicas);
        }

        public List<Integer> observers() {
            return Collections.emptyList();
        }
    }

    public class TopicImagePartitionSnapshot
    implements TopicsMetadataSnapshot.PartitionSnapshot {
        private final String topic;
        private final int partitionId;
        private final int numReplicas;

        public TopicImagePartitionSnapshot(String topic, int partitionId, int numReplicas) {
            this.topic = topic;
            this.partitionId = partitionId;
            this.numReplicas = numReplicas;
        }

        public String topic() {
            return this.topic;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public int numReplicas() {
            return this.numReplicas;
        }
    }
}

