/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.Objects;

public final class DataBalancerMetricsRegistry {
    private final GeneralSBCMetricsRegistry generalSBCMetricsRegistry;
    private final CellOverloadMetrics cellOverloadMetrics;

    private DataBalancerMetricsRegistry(DataBalancerMetricsRegistryContextBuilder builder) {
        this.generalSBCMetricsRegistry = builder.generalSBCMetricsRegistry;
        this.cellOverloadMetrics = builder.cellOverloadMetrics;
    }

    public static DataBalancerMetricsRegistryContextBuilder builder() {
        return new DataBalancerMetricsRegistryContextBuilder();
    }

    public GeneralSBCMetricsRegistry dataBalancerMetricsRegistry() {
        return this.generalSBCMetricsRegistry;
    }

    public CellOverloadMetrics cellOverloadMetrics() {
        return this.cellOverloadMetrics;
    }

    public void clearMetrics() {
        this.generalSBCMetricsRegistry.clearShortLivedMetrics();
        this.cellOverloadMetrics.clearMetrics();
    }

    public static final class DataBalancerMetricsRegistryContextBuilder {
        private GeneralSBCMetricsRegistry generalSBCMetricsRegistry;
        private CellOverloadMetrics cellOverloadMetrics;

        private DataBalancerMetricsRegistryContextBuilder() {
        }

        public DataBalancerMetricsRegistryContextBuilder dataBalancerMetricsRegistry(GeneralSBCMetricsRegistry generalSBCMetricsRegistry) {
            this.generalSBCMetricsRegistry = generalSBCMetricsRegistry;
            return this;
        }

        public DataBalancerMetricsRegistryContextBuilder cellOverloadMetrics(CellOverloadMetrics cellOverloadMetrics) {
            this.cellOverloadMetrics = cellOverloadMetrics;
            return this;
        }

        public DataBalancerMetricsRegistry build() {
            Objects.requireNonNull(this.generalSBCMetricsRegistry, "GeneralSBCMetricsRegistry must be non-null");
            Objects.requireNonNull(this.cellOverloadMetrics, "CellOverloadMetrics must be non-null");
            return new DataBalancerMetricsRegistry(this);
        }
    }
}

