/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateMachine;
import io.confluent.databalancer.operation.StateMachineInitializer;
import io.confluent.databalancer.operation.StateTransitioner;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.common.utils.Time;

@ThreadSafe
public class BrokerRemovalStateMachine
extends StateMachine<BrokerRemovalState, BrokerRemovalEvent> {
    private static BrokerRemovalEvent[] cancelEvents = new BrokerRemovalEvent[]{BrokerRemovalEvent.BALANCER_RESIGNED, BrokerRemovalEvent.BROKER_RESTARTED, BrokerRemovalEvent.BALANCER_DISABLED, BrokerRemovalEvent.EXCLUSION_ADDED, BrokerRemovalEvent.EXCLUSION_REMOVED};
    private static StateTransitioner<BrokerRemovalState, BrokerRemovalEvent> transitioner = new StateTransitioner.Builder().with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.EXCLUSION_INITIATED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.INITIAL_PLAN_COMPUTATION_SUCCESS})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.INITIAL_PLAN_COMPUTATION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXECUTOR_RESERVATION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_CANCELED).when(cancelEvents)).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_CANCELED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.DEMOTED_ADDED})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_INITIATED).to(BrokerRemovalState.EXCLUSION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXCLUSION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_INITIATED).to(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXCLUSION_SUCCESS})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_INITIATED).to(BrokerRemovalState.EXCLUSION_CANCELED).when(cancelEvents)).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_INITIATED).to(BrokerRemovalState.EXCLUSION_CANCELED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.DEMOTED_ADDED})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.PLAN_COMPUTATION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.PLAN_COMPUTATION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.PLAN_COMPUTATION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXECUTOR_RESERVATION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.PLAN_COMPUTATION_CANCELED).when(cancelEvents)).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.PLAN_COMPUTATION_CANCELED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.DEMOTED_ADDED})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_COMPUTATION_INITIATED).to(BrokerRemovalState.PLAN_EXECUTION_INITIATED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.PLAN_COMPUTATION_SUCCESS})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_EXECUTION_INITIATED).to(BrokerRemovalState.PLAN_EXECUTION_CANCELED).when(cancelEvents)).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_EXECUTION_INITIATED).to(BrokerRemovalState.PLAN_EXECUTION_CANCELED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.DEMOTED_ADDED})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_EXECUTION_INITIATED).to(BrokerRemovalState.PLAN_EXECUTION_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.PLAN_EXECUTION_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_EXECUTION_INITIATED).to(BrokerRemovalState.PLAN_EXECUTION_SUCCEEDED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.PLAN_EXECUTION_SUCCESS_NO_SHUTDOWN})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.PLAN_EXECUTION_INITIATED).to(BrokerRemovalState.BROKER_SHUTDOWN_INITIATED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.PLAN_EXECUTION_SUCCESS_WITH_SHUTDOWN})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.BROKER_SHUTDOWN_INITIATED).to(BrokerRemovalState.BROKER_SHUTDOWN_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.BROKER_SHUTDOWN_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.BROKER_SHUTDOWN_INITIATED).to(BrokerRemovalState.BROKER_SHUTDOWN_CANCELED).when(cancelEvents)).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.BROKER_SHUTDOWN_INITIATED).to(BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.BROKER_SHUTDOWN_SUCCESS})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED).to(BrokerRemovalState.EXCLUSION_REMOVAL_FAILED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXCLUSION_REMOVAL_FAILURE})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED).to(BrokerRemovalState.EXCLUSION_REMOVAL_CANCELED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.BALANCER_RESIGNED, BrokerRemovalEvent.BROKER_RESTARTED, BrokerRemovalEvent.BALANCER_DISABLED, BrokerRemovalEvent.EXCLUSION_ADDED})).with(BrokerRemovalStateMachine.transition().from(BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED).to(BrokerRemovalState.EXCLUSION_REMOVAL_SUCCEEDED).when(new BrokerRemovalEvent[]{BrokerRemovalEvent.EXCLUSION_REMOVAL_SUCCESS})).build();
    private static StateMachineInitializer<BrokerRemovalState> stateMachineInitializer = new StateMachineInitializer.Builder<BrokerRemovalState>().with(BrokerRemovalStateMachine.initRule().given(BrokerRemovalState.PLAN_EXECUTION_INITIATED).initializeTo(BrokerRemovalState.PLAN_COMPUTATION_INITIATED)).setDefaultStartState(BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED).build(StateMachineInitializer.InitializationMode.ALLOW_UNDEFINED_INITIALIZATIONS);
    public static final BrokerRemovalState START_STATE = BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED;

    public BrokerRemovalStateMachine(Set<Integer> brokerIds) {
        this(brokerIds, stateMachineInitializer.defaultStartState());
    }

    public BrokerRemovalStateMachine(Set<Integer> brokerIds, BrokerRemovalState currentState) {
        this(brokerIds, currentState, Time.SYSTEM);
    }

    public BrokerRemovalStateMachine(Set<Integer> brokerIds, BrokerRemovalState currentState, Time time) {
        super(brokerIds, "Broker Removal", stateMachineInitializer.init(currentState), time);
    }

    private static StateTransitioner.TransitionBuilder<BrokerRemovalState, BrokerRemovalEvent> transition() {
        return new StateTransitioner.TransitionBuilder<BrokerRemovalState, BrokerRemovalEvent>();
    }

    private static StateMachineInitializer.InitializationRuleBuilder<BrokerRemovalState> initRule() {
        return new StateMachineInitializer.InitializationRuleBuilder<BrokerRemovalState>();
    }

    @Override
    StateTransitioner<BrokerRemovalState, BrokerRemovalEvent> transitioner() {
        return transitioner;
    }

    public static boolean isStateTerminal(BrokerRemovalState state) {
        return transitioner.isTerminalState(state);
    }

    public static enum BrokerRemovalEvent implements BalancerOperationEvent
    {
        EXECUTOR_RESERVATION_FAILURE,
        INITIAL_PLAN_COMPUTATION_SUCCESS,
        INITIAL_PLAN_COMPUTATION_FAILURE,
        EXCLUSION_SUCCESS,
        EXCLUSION_FAILURE,
        PLAN_COMPUTATION_SUCCESS,
        PLAN_COMPUTATION_FAILURE,
        PLAN_EXECUTION_SUCCESS_NO_SHUTDOWN,
        PLAN_EXECUTION_SUCCESS_WITH_SHUTDOWN,
        PLAN_EXECUTION_FAILURE,
        BROKER_SHUTDOWN_SUCCESS,
        BROKER_SHUTDOWN_FAILURE,
        EXCLUSION_REMOVAL_SUCCESS,
        EXCLUSION_REMOVAL_FAILURE,
        BROKER_RESTARTED(true),
        BALANCER_RESIGNED(true),
        BALANCER_DISABLED(true),
        EXCLUSION_ADDED(true),
        EXCLUSION_REMOVED(true),
        DEMOTED_ADDED(true);

        private final boolean isExternal;

        private BrokerRemovalEvent(boolean isExternal) {
            this.isExternal = isExternal;
        }

        private BrokerRemovalEvent() {
            this(false);
        }

        public boolean canCancelRemoval() {
            return this.isExternal;
        }
    }

    @Immutable
    public static enum BrokerRemovalState implements BalancerOperationState
    {
        CANCELED(BrokerReplicaExclusionStatus.CANCELED, PartitionReassignmentsStatus.CANCELED, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        INITIAL_PLAN_COMPUTATION_INITIATED(BrokerReplicaExclusionStatus.PENDING, PartitionReassignmentsStatus.PENDING, BrokerShutdownStatus.PENDING),
        INITIAL_PLAN_COMPUTATION_FAILED(BrokerReplicaExclusionStatus.CANCELED, PartitionReassignmentsStatus.ERROR, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        INITIAL_PLAN_COMPUTATION_CANCELED(BrokerReplicaExclusionStatus.CANCELED, PartitionReassignmentsStatus.CANCELED, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        EXCLUSION_INITIATED(BrokerReplicaExclusionStatus.IN_PROGRESS, PartitionReassignmentsStatus.PENDING, BrokerShutdownStatus.PENDING),
        EXCLUSION_FAILED(BrokerReplicaExclusionStatus.ERROR, PartitionReassignmentsStatus.CANCELED, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        EXCLUSION_CANCELED(BrokerReplicaExclusionStatus.ERROR, PartitionReassignmentsStatus.CANCELED, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        PLAN_COMPUTATION_INITIATED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerShutdownStatus.PENDING),
        PLAN_COMPUTATION_FAILED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.ERROR, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        PLAN_COMPUTATION_CANCELED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.ERROR, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        PLAN_EXECUTION_INITIATED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerShutdownStatus.PENDING),
        PLAN_EXECUTION_CANCELED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.ERROR, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        PLAN_EXECUTION_FAILED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.ERROR, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        PLAN_EXECUTION_SUCCEEDED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.CANCELED, BalancerOperationState.BalancerOperationStateCharacteristics.SUCCESSFUL_OPERATION),
        BROKER_SHUTDOWN_INITIATED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.PENDING),
        BROKER_SHUTDOWN_CANCELED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.ERROR, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        BROKER_SHUTDOWN_FAILED(BrokerReplicaExclusionStatus.EXCLUDED, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.ERROR, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        EXCLUSION_REMOVAL_INITIATED(BrokerReplicaExclusionStatus.REMOVING, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.COMPLETED, BalancerOperationState.BalancerOperationStateCharacteristics.IN_PROGRESS_OPERATION),
        EXCLUSION_REMOVAL_FAILED(BrokerReplicaExclusionStatus.ERROR, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.COMPLETED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        EXCLUSION_REMOVAL_CANCELED(BrokerReplicaExclusionStatus.ERROR, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.COMPLETED, BalancerOperationState.BalancerOperationStateCharacteristics.FAILED_OPERATION),
        EXCLUSION_REMOVAL_SUCCEEDED(BrokerReplicaExclusionStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerShutdownStatus.COMPLETED, BalancerOperationState.BalancerOperationStateCharacteristics.SUCCESSFUL_OPERATION);

        private final BrokerShutdownStatus shutdownStatus;
        private final PartitionReassignmentsStatus partitionReassignmentsStatus;
        private final BrokerReplicaExclusionStatus exclusionStatus;
        private final BalancerOperationState.BalancerOperationStateCharacteristics opCharacteristics;

        private BrokerRemovalState(BrokerReplicaExclusionStatus replicaExclusionStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, BrokerShutdownStatus shutdownStatus) {
            this(replicaExclusionStatus, partitionReassignmentsStatus, shutdownStatus, BalancerOperationState.BalancerOperationStateCharacteristics.IN_PROGRESS_OPERATION);
        }

        private BrokerRemovalState(BrokerReplicaExclusionStatus replicaExclusionStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, BrokerShutdownStatus shutdownStatus, BalancerOperationState.BalancerOperationStateCharacteristics characteristics) {
            this.shutdownStatus = shutdownStatus;
            this.partitionReassignmentsStatus = partitionReassignmentsStatus;
            this.exclusionStatus = replicaExclusionStatus;
            this.opCharacteristics = characteristics;
        }

        public BrokerShutdownStatus brokerShutdownStatus() {
            return this.shutdownStatus;
        }

        public PartitionReassignmentsStatus partitionReassignmentsStatus() {
            return this.partitionReassignmentsStatus;
        }

        public BrokerReplicaExclusionStatus replicaExclusionStatus() {
            return this.exclusionStatus;
        }

        @Override
        public boolean isTerminal() {
            return this.opCharacteristics.isTerminal();
        }

        public boolean isSuccess() {
            return this.opCharacteristics.isSuccess();
        }

        public BalancerOperationStatus toBalancerOperationStatus() {
            if (this.isSuccess()) {
                return BalancerOperationStatus.SUCCESS;
            }
            if (this.isTerminal()) {
                return BalancerOperationStatus.FAILED;
            }
            return BalancerOperationStatus.IN_PROGRESS;
        }
    }
}

