/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateMachine;
import io.confluent.databalancer.operation.StateTransitioner;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.common.utils.Time;

public class EvenClusterLoadStateMachine
extends StateMachine<EvenClusterLoadState, EvenClusterLoadEvent> {
    private static final StateTransitioner<EvenClusterLoadState, EvenClusterLoadEvent> TRANSITIONER = new StateTransitioner.Builder().with(EvenClusterLoadStateMachine.transition().from(EvenClusterLoadState.BALANCING).to(EvenClusterLoadState.BALANCED).when(new EvenClusterLoadEvent[]{EvenClusterLoadEvent.BALANCING_SUCCESS})).with(EvenClusterLoadStateMachine.transition().from(EvenClusterLoadState.BALANCING).to(EvenClusterLoadState.BALANCING_FAILED).when(new EvenClusterLoadEvent[]{EvenClusterLoadEvent.BALANCING_FAILED})).addEventBasedTransition(EvenClusterLoadEvent.ADD_BROKER_TRIGGERED, EvenClusterLoadState.ABORTED).addEventBasedTransition(EvenClusterLoadEvent.REMOVE_BROKER_TRIGGERED, EvenClusterLoadState.ABORTED).addEventBasedTransition(EvenClusterLoadEvent.STOPPED, EvenClusterLoadState.ABORTED).build();
    private Exception evenLoadBalancingError = null;

    public EvenClusterLoadStateMachine(int brokerId, Time time) {
        this(brokerId, EvenClusterLoadState.BALANCING, time);
    }

    public EvenClusterLoadStateMachine(int brokerId, EvenClusterLoadState startState, Time time) {
        super(brokerId, "Even Cluster Load Status", startState, time);
    }

    public EvenClusterLoadStateMachine(int brokerId, EvenClusterLoadState startState, long stateCreatedAt, long stateLastUpdatedAt, Time time, Exception evenLoadBalancingError) {
        super(brokerId, "Even Cluster Load Status", startState, stateCreatedAt, stateLastUpdatedAt, time);
        this.evenLoadBalancingError = evenLoadBalancingError;
    }

    private static StateTransitioner.TransitionBuilder<EvenClusterLoadState, EvenClusterLoadEvent> transition() {
        return new StateTransitioner.TransitionBuilder<EvenClusterLoadState, EvenClusterLoadEvent>();
    }

    public Exception evenLoadBalancingError() {
        return this.evenLoadBalancingError;
    }

    public void evenLoadBalancingError(Exception evenLoadBalancingError) {
        this.evenLoadBalancingError = evenLoadBalancingError;
    }

    @Override
    StateTransitioner<EvenClusterLoadState, EvenClusterLoadEvent> transitioner() {
        return TRANSITIONER;
    }

    @Override
    public synchronized EvenClusterLoadState advanceState(EvenClusterLoadEvent event) {
        return ((EvenClusterLoadState)this.currentState()).isTerminal ? (EvenClusterLoadState)this.currentState() : (EvenClusterLoadState)super.advanceState(event);
    }

    public static enum EvenClusterLoadEvent implements BalancerOperationEvent
    {
        ADD_BROKER_TRIGGERED,
        BALANCING_SUCCESS,
        BALANCING_FAILED,
        REMOVE_BROKER_TRIGGERED,
        STOPPED;

    }

    @Immutable
    public static enum EvenClusterLoadState implements BalancerOperationState
    {
        INITIALIZING(EvenClusterLoadStatus.STARTING, false),
        BALANCING(EvenClusterLoadStatus.BALANCING, false),
        BALANCED(EvenClusterLoadStatus.BALANCED, true),
        BALANCING_FAILED(EvenClusterLoadStatus.BALANCING_FAILED, true),
        ABORTED(EvenClusterLoadStatus.ABORTED, true);

        private final EvenClusterLoadStatus status;
        private final boolean isTerminal;

        private EvenClusterLoadState(EvenClusterLoadStatus status, boolean isTerminal) {
            this.status = status;
            this.isTerminal = isTerminal;
        }

        public EvenClusterLoadStatus status() {
            return this.status;
        }

        @Override
        public boolean isTerminal() {
            return this.isTerminal;
        }

        public boolean isFailedOrAborted() {
            return this == BALANCING_FAILED || this == ABORTED;
        }
    }
}

