/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.utils;

public interface RetryableResult<T> {
    public T get();

    public boolean shouldRetry();

    public boolean shouldStop();

    public static class Failure<T>
    implements RetryableResult<T> {
        private Failure() {
        }

        public static <T> Failure<T> instance() {
            return new Failure<T>();
        }

        @Override
        public T get() {
            throw new RuntimeException("Invalid method call.");
        }

        @Override
        public boolean shouldRetry() {
            return false;
        }

        @Override
        public boolean shouldStop() {
            return true;
        }
    }

    public static class Incomplete<T>
    implements RetryableResult<T> {
        private Incomplete() {
        }

        public static <T> Incomplete<T> instance() {
            return new Incomplete<T>();
        }

        @Override
        public T get() {
            throw new RuntimeException("Invalid method call.");
        }

        @Override
        public boolean shouldRetry() {
            return true;
        }

        @Override
        public boolean shouldStop() {
            return false;
        }
    }

    public static class Success<T>
    implements RetryableResult<T> {
        private final T result;

        private Success(T result) {
            this.result = result;
        }

        public static <T> Success<T> of(T result) {
            return new Success<T>(result);
        }

        @Override
        public T get() {
            return this.result;
        }

        @Override
        public boolean shouldRetry() {
            return false;
        }

        @Override
        public boolean shouldStop() {
            return false;
        }
    }
}

