/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.errors.PolicyViolationException;

public class PolicyUtils {
    private PolicyUtils() {
    }

    protected static final void validateConfigsAreUpdatable(Map<String, String> configs, Predicate<String> predicate) {
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            String configName = entry.getKey();
            if (predicate.test(configName)) continue;
            throw new PolicyViolationException("Altering config property '" + configName + "' is disallowed.");
        }
    }
}

